/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,uselessCode} checked by tsc
 */
import { HttpClient } from '@angular/common/http';
import { Injectable, Optional, SecurityContext } from '@angular/core';
import { DomSanitizer } from '@angular/platform-browser';
import { parse, Renderer } from 'marked';
import { map } from 'rxjs/operators';
import { MarkedOptions } from './marked-options';
/** @type {?} */
export const errorSrcWithoutHttpClient = '[ngx-markdown] When using the [src] attribute you *have to* pass the `HttpClient` as a parameter of the `forRoot` method. See README for more information';
export class MarkdownService {
    /**
     * @param {?} http
     * @param {?} domSanitizer
     * @param {?} options
     */
    constructor(http, domSanitizer, options) {
        this.http = http;
        this.domSanitizer = domSanitizer;
        this.options = options;
        if (!this.renderer) {
            this.renderer = new Renderer();
        }
    }
    /**
     * @return {?}
     */
    get renderer() { return this.options.renderer; }
    /**
     * @param {?} value
     * @return {?}
     */
    set renderer(value) {
        this.options.renderer = value;
    }
    /**
     * @param {?} markdown
     * @param {?=} decodeHtml
     * @param {?=} markedOptions
     * @return {?}
     */
    compile(markdown, decodeHtml = false, markedOptions = this.options) {
        /** @type {?} */
        const precompiled = this.precompile(markdown);
        /** @type {?} */
        const compiled = parse(decodeHtml ? this.decodeHtml(precompiled) : precompiled, markedOptions);
        return markedOptions.sanitize && !markedOptions.sanitizer
            ? this.domSanitizer.sanitize(SecurityContext.HTML, compiled)
            : compiled;
    }
    /**
     * @param {?} src
     * @return {?}
     */
    getSource(src) {
        if (!this.http) {
            throw new Error(errorSrcWithoutHttpClient);
        }
        return this.http
            .get(src, { responseType: 'text' })
            .pipe(map(markdown => this.handleExtension(src, markdown)));
    }
    /**
     * @return {?}
     */
    highlight() {
        if (typeof Prism !== 'undefined') {
            Prism.highlightAll(false);
        }
    }
    /**
     * @param {?} html
     * @return {?}
     */
    decodeHtml(html) {
        /** @type {?} */
        const textarea = document.createElement('textarea');
        textarea.innerHTML = html;
        return textarea.value;
    }
    /**
     * @param {?} src
     * @param {?} markdown
     * @return {?}
     */
    handleExtension(src, markdown) {
        /** @type {?} */
        const extension = src
            ? src.split('.').splice(-1).join()
            : null;
        return extension !== 'md'
            ? '```' + extension + '\n' + markdown + '\n```'
            : markdown;
    }
    /**
     * @param {?} markdown
     * @return {?}
     */
    precompile(markdown) {
        if (!markdown) {
            return '';
        }
        /** @type {?} */
        let indentStart;
        return markdown
            .split('\n')
            .map(line => {
            /** @type {?} */
            let lineIdentStart = indentStart;
            // find position of 1st non-whitespace character
            // to determine the current line indentation start
            if (line.length > 0) {
                lineIdentStart = isNaN(lineIdentStart)
                    ? line.search(/\S|$/)
                    : Math.min(line.search(/\S|$/), lineIdentStart);
            }
            // keep 1st non-whitespace line indentation
            // as base reference for other lines
            if (isNaN(indentStart)) {
                indentStart = lineIdentStart;
            }
            // remove whitespaces before current line indentation
            return !!lineIdentStart
                ? line.substring(lineIdentStart)
                : line;
        }).join('\n');
    }
}
MarkdownService.decorators = [
    { type: Injectable },
];
/** @nocollapse */
MarkdownService.ctorParameters = () => [
    { type: HttpClient, decorators: [{ type: Optional }] },
    { type: DomSanitizer },
    { type: MarkedOptions }
];
if (false) {
    /** @type {?} */
    MarkdownService.prototype.http;
    /** @type {?} */
    MarkdownService.prototype.domSanitizer;
    /** @type {?} */
    MarkdownService.prototype.options;
}

//# sourceMappingURL=data:application/json;base64,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