/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
import { Component, ElementRef, ViewEncapsulation, Renderer2 } from '@angular/core';
import { BaseDynamicComponent } from './base-dynamic-component';
/**
 * Represents the modal backdrop shaped by CSS.
 */
export class CSSBackdrop extends BaseDynamicComponent {
    /**
     * @param {?} el
     * @param {?} renderer
     */
    constructor(el, renderer) {
        super(el, renderer);
        this.activateAnimationListener();
        const /** @type {?} */ style = {
            position: 'absolute',
            top: 0,
            left: 0,
            width: '100%',
            height: '100%'
        };
        Object.keys(style).forEach(k => this.setStyle(k, style[k]));
    }
}
CSSBackdrop.decorators = [
    { type: Component, args: [{
                selector: 'css-backdrop',
                host: {
                    '[attr.class]': 'cssClass',
                    '[attr.style]': 'styleStr'
                },
                encapsulation: ViewEncapsulation.None,
                template: ``
            },] },
];
/** @nocollapse */
CSSBackdrop.ctorParameters = () => [
    { type: ElementRef, },
    { type: Renderer2, },
];
function CSSBackdrop_tsickle_Closure_declarations() {
    /** @type {!Array<{type: !Function, args: (undefined|!Array<?>)}>} */
    CSSBackdrop.decorators;
    /**
     * @nocollapse
     * @type {function(): !Array<(null|{type: ?, decorators: (undefined|!Array<{type: !Function, args: (undefined|!Array<?>)}>)})>}
     */
    CSSBackdrop.ctorParameters;
    /** @type {?} */
    CSSBackdrop.prototype.cssClass;
    /** @type {?} */
    CSSBackdrop.prototype.styleStr;
}
//# sourceMappingURL=css-backdrop.js.map
