/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
const /** @type {?} */ BASKET_GROUP = {};
/**
 * A dumb stack implementation over an array.
 * @template T
 */
export class DialogRefStack {
    constructor() {
        this._stack = [];
        this._stackMap = new Map();
    }
    /**
     * @return {?}
     */
    get length() {
        return this._stack.length;
    }
    /**
     * @param {?=} result
     * @return {?}
     */
    closeAll(result = null) {
        for (let /** @type {?} */ i = 0, /** @type {?} */ len = this._stack.length; i < len; i++) {
            this._stack.pop().close(result);
        }
    }
    /**
     * @param {?} dialogRef
     * @param {?=} group
     * @return {?}
     */
    push(dialogRef, group) {
        if (this._stack.indexOf(dialogRef) === -1) {
            this._stack.push(dialogRef);
            this._stackMap.set(dialogRef, group || BASKET_GROUP);
        }
    }
    /**
     * Push a DialogRef into the stack and manage it so when it's done
     * it will automatically kick itself out of the stack.
     * @param {?} dialogRef
     * @param {?=} group
     * @return {?}
     */
    pushManaged(dialogRef, group) {
        this.push(dialogRef, group);
        dialogRef.onDestroy.subscribe(() => this.remove(dialogRef));
    }
    /**
     * @return {?}
     */
    pop() {
        const /** @type {?} */ dialogRef = this._stack.pop();
        this._stackMap.delete(dialogRef);
        return dialogRef;
    }
    /**
     * Remove a DialogRef from the stack.
     * @param {?} dialogRef
     * @return {?}
     */
    remove(dialogRef) {
        let /** @type {?} */ idx = this.indexOf(dialogRef);
        if (idx > -1) {
            this._stack.splice(idx, 1);
            this._stackMap.delete(dialogRef);
        }
    }
    /**
     * @param {?} index
     * @return {?}
     */
    index(index) {
        return this._stack[index];
    }
    /**
     * @param {?} dialogRef
     * @return {?}
     */
    indexOf(dialogRef) {
        return this._stack.indexOf(dialogRef);
    }
    /**
     * @param {?} dialogRef
     * @return {?}
     */
    groupOf(dialogRef) {
        return this._stackMap.get(dialogRef);
    }
    /**
     * @param {?} group
     * @return {?}
     */
    groupBy(group) {
        let /** @type {?} */ arr = [];
        if (group) {
            this._stackMap.forEach((value, key) => {
                if (value === group) {
                    arr.push(key);
                }
            });
        }
        return arr;
    }
    /**
     * @param {?} group
     * @return {?}
     */
    groupLength(group) {
        let /** @type {?} */ count = 0;
        if (group) {
            this._stackMap.forEach((value) => {
                if (value === group) {
                    count++;
                }
            });
        }
        return count;
    }
}
function DialogRefStack_tsickle_Closure_declarations() {
    /** @type {?} */
    DialogRefStack.prototype._stack;
    /** @type {?} */
    DialogRefStack.prototype._stackMap;
}
//# sourceMappingURL=dialog-ref-stack.js.map
