import * as tslib_1 from "tslib";
/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
import { Component, ViewEncapsulation, ElementRef, Renderer2 } from '@angular/core';
import { BaseDynamicComponent } from './base-dynamic-component';
import { DialogRef } from '../models/dialog-ref';
/**
 * A component that acts as a top level container for an open modal window.
 */
var CSSDialogContainer = /** @class */ (function (_super) {
    tslib_1.__extends(CSSDialogContainer, _super);
    /**
     * @param {?} dialog
     * @param {?} el
     * @param {?} renderer
     */
    function CSSDialogContainer(dialog, el, renderer) {
        var _this = _super.call(this, el, renderer) || this;
        _this.dialog = dialog;
        _this.activateAnimationListener();
        return _this;
    }
    return CSSDialogContainer;
}(BaseDynamicComponent));
export { CSSDialogContainer };
CSSDialogContainer.decorators = [
    { type: Component, args: [{
                selector: 'css-dialog-container',
                host: {
                    'tabindex': '-1',
                    'role': 'dialog'
                },
                encapsulation: ViewEncapsulation.None,
                template: "<ng-content></ng-content>"
            },] },
];
/** @nocollapse */
CSSDialogContainer.ctorParameters = function () { return [
    { type: DialogRef, },
    { type: ElementRef, },
    { type: Renderer2, },
]; };
function CSSDialogContainer_tsickle_Closure_declarations() {
    /** @type {!Array<{type: !Function, args: (undefined|!Array<?>)}>} */
    CSSDialogContainer.decorators;
    /**
     * @nocollapse
     * @type {function(): !Array<(null|{type: ?, decorators: (undefined|!Array<{type: !Function, args: (undefined|!Array<?>)}>)})>}
     */
    CSSDialogContainer.ctorParameters;
    /** @type {?} */
    CSSDialogContainer.prototype.dialog;
}
//# sourceMappingURL=css-dialog-container.js.map
