/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
import { ComponentFactoryResolver } from '@angular/core';
/**
 * @record
 */
export function CreateComponentArgs() { }
function CreateComponentArgs_tsickle_Closure_declarations() {
    /** @type {?} */
    CreateComponentArgs.prototype.component;
    /** @type {?} */
    CreateComponentArgs.prototype.vcRef;
    /** @type {?|undefined} */
    CreateComponentArgs.prototype.injector;
    /** @type {?|undefined} */
    CreateComponentArgs.prototype.projectableNodes;
}
/**
 * @param {?} instructions
 * @return {?}
 */
export function createComponent(instructions) {
    var /** @type {?} */ injector = instructions.injector || instructions.vcRef.parentInjector;
    var /** @type {?} */ cmpFactory = injector.get(ComponentFactoryResolver).resolveComponentFactory(instructions.component);
    if (instructions.vcRef) {
        return instructions.vcRef.createComponent(cmpFactory, instructions.vcRef.length, injector, instructions.projectableNodes);
    }
    else {
        return cmpFactory.create(injector);
    }
}
//# sourceMappingURL=createComponent.js.map
