import * as tslib_1 from "tslib";
/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
import { Modal } from '../providers/index';
import { ModalContext, ModalContextBuilder } from './modal-context';
import { arrayUnion } from '../framework/utils';
var /** @type {?} */ DEFAULT_SETTERS = [
    'component'
];
var ModalOpenContext = /** @class */ (function (_super) {
    tslib_1.__extends(ModalOpenContext, _super);
    function ModalOpenContext() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    return ModalOpenContext;
}(ModalContext));
export { ModalOpenContext };
function ModalOpenContext_tsickle_Closure_declarations() {
    /** @type {?} */
    ModalOpenContext.prototype.component;
    /** @type {?} */
    ModalOpenContext.prototype.modal;
}
// unsupported: template constraints.
/**
 * A Modal Context that knows about the modal service, and so can open a modal window on demand.
 * Use the fluent API to configure the preset and then invoke the 'open' method to open a modal
 * based on the context.
 * @abstract
 * @template T
 */
var ModalOpenContextBuilder = /** @class */ (function (_super) {
    tslib_1.__extends(ModalOpenContextBuilder, _super);
    /**
     * @param {?=} defaultValues
     * @param {?=} initialSetters
     * @param {?=} baseType
     */
    function ModalOpenContextBuilder(defaultValues, initialSetters, baseType) {
        if (defaultValues === void 0) { defaultValues = undefined; }
        if (initialSetters === void 0) { initialSetters = undefined; }
        if (baseType === void 0) { baseType = undefined; }
        return _super.call(this, defaultValues || /** @type {?} */ ({}), arrayUnion(DEFAULT_SETTERS, initialSetters || []), baseType) || this;
    }
    /**
     * Hook to alter config and return bindings.
     * @param {?} config
     * @return {?}
     */
    ModalOpenContextBuilder.prototype.$$beforeOpen = function (config) { };
    /**
     * Open a modal window based on the configuration of this config instance.
     * @param {?=} viewContainer If set opens the modal inside the supplied viewContainer
     * @return {?}
     */
    ModalOpenContextBuilder.prototype.open = function (viewContainer) {
        var /** @type {?} */ context = this.toJSON();
        if (!(context.modal instanceof Modal)) {
            return /** @type {?} */ (Promise.reject(new Error('Configuration Error: modal service not set.')));
        }
        this.$$beforeOpen(context);
        var /** @type {?} */ overlayConfig = {
            context: context,
            viewContainer: viewContainer
        };
        return context.modal.open(context.component, overlayConfig);
    };
    return ModalOpenContextBuilder;
}(ModalContextBuilder));
export { ModalOpenContextBuilder };
function ModalOpenContextBuilder_tsickle_Closure_declarations() {
    /**
     * A Class for the footer container.
     * Default: modal-footer
     * @type {?}
     */
    ModalOpenContextBuilder.prototype.component;
}
//# sourceMappingURL=modal-open-context.js.map
