/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
/**
 * @param {?} dropInName
 * @return {?}
 */
export function unsupportedDropInError(dropInName) {
    return new Error("Unsupported Drop-In " + dropInName);
}
/**
 * @abstract
 */
var Modal = /** @class */ (function () {
    /**
     * @param {?} overlay
     */
    function Modal(overlay) {
        this.overlay = overlay;
    }
    /**
     * @return {?}
     */
    Modal.prototype.alert = function () {
        throw unsupportedDropInError('alert');
    };
    /**
     * @return {?}
     */
    Modal.prototype.prompt = function () {
        throw unsupportedDropInError('prompt');
    };
    /**
     * @return {?}
     */
    Modal.prototype.confirm = function () {
        throw unsupportedDropInError('confirm');
    };
    /**
     * Opens a modal window inside an existing component.
     * @param {?} content The content to display, either string, template ref or a component.
     * @param {?=} config Additional settings.
     * @return {?}
     */
    Modal.prototype.open = function (content, config) {
        config = config || /** @type {?} */ ({});
        var /** @type {?} */ dialogs = this.overlay.open(config, this.constructor);
        if (dialogs.length > 1) {
            console.warn("Attempt to open more then 1 overlay detected.\n      Multiple modal copies are not supported at the moment, \n      only the first viewContainer will display.");
        }
        // TODO:  Currently supporting 1 view container, hence working on dialogs[0].
        //        upgrade to multiple containers.
        return this.create(dialogs[0], content);
    };
    /**
     * @template T
     * @param {?} dialogRef
     * @param {?} BackdropComponent
     * @return {?}
     */
    Modal.prototype.createBackdrop = function (dialogRef, BackdropComponent) {
        return dialogRef.overlayRef.instance.addComponent(BackdropComponent);
    };
    /**
     * @template T
     * @param {?} dialogRef
     * @param {?} ContainerComponent
     * @param {?} content
     * @return {?}
     */
    Modal.prototype.createContainer = function (dialogRef, ContainerComponent, content) {
        var /** @type {?} */ nodes = dialogRef.overlayRef.instance.getProjectables(content);
        return dialogRef.overlayRef.instance.addComponent(ContainerComponent, nodes);
    };
    return Modal;
}());
export { Modal };
function Modal_tsickle_Closure_declarations() {
    /** @type {?} */
    Modal.prototype.overlay;
    /**
     * A Hook that enables derived classes to add content to the overlay.
     * @abstract
     * @param {?} dialogRef
     * @param {?} type
     * @return {?}
     */
    Modal.prototype.create = function (dialogRef, type) { };
}
//# sourceMappingURL=modal.js.map
