import { ComponentRef } from '@angular/core';
import { Overlay } from '../overlay/index';
import { Class } from '../framework/utils';
import { OverlayConfig, ContainerContent } from '../models/tokens';
import { DialogRef } from '../models/dialog-ref';
import { ModalControllingContextBuilder } from '../models/overlay-context';
export declare function unsupportedDropInError(dropInName: string): Error;
export declare abstract class Modal {
    overlay: Overlay;
    constructor(overlay: Overlay);
    alert(): ModalControllingContextBuilder<any>;
    prompt(): ModalControllingContextBuilder<any>;
    confirm(): ModalControllingContextBuilder<any>;
    /**
     * Opens a modal window inside an existing component.
     * @param content The content to display, either string, template ref or a component.
     * @param config Additional settings.
     */
    open(content: ContainerContent, config?: OverlayConfig): DialogRef<any>;
    /**
     * A Hook that enables derived classes to add content to the overlay.
     * @param dialogRef
     * @param type
     */
    protected abstract create(dialogRef: DialogRef<any>, type: ContainerContent): DialogRef<any>;
    protected createBackdrop<T>(dialogRef: DialogRef<any>, BackdropComponent: Class<T>): ComponentRef<T>;
    protected createContainer<T>(dialogRef: DialogRef<any>, ContainerComponent: Class<T>, content: ContainerContent): ComponentRef<T>;
}
