/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
import { Component, ViewEncapsulation } from '@angular/core';
import { DialogRef } from 'ngx-modialog';
/**
 * @record
 */
export function BSMessageModalButtonHandler() { }
function BSMessageModalButtonHandler_tsickle_Closure_declarations() {
    /* TODO: handle strange member:
    (cmp: ModalComponent<MessageModalPreset>, $event: MouseEvent): void;
    */
}
/**
 * Interface for button definition
 * @record
 */
export function BSMessageModalButtonConfig() { }
function BSMessageModalButtonConfig_tsickle_Closure_declarations() {
    /** @type {?} */
    BSMessageModalButtonConfig.prototype.cssClass;
    /** @type {?} */
    BSMessageModalButtonConfig.prototype.caption;
    /** @type {?} */
    BSMessageModalButtonConfig.prototype.onClick;
}
export class BSMessageModalTitle {
    /**
     * @param {?} dialog
     */
    constructor(dialog) {
        this.dialog = dialog;
        this.context = dialog.context;
    }
    /**
     * @return {?}
     */
    get titleHtml() {
        return this.context.titleHtml ? 1 : 0;
    }
}
BSMessageModalTitle.decorators = [
    { type: Component, args: [{
                selector: 'modal-title',
                encapsulation: ViewEncapsulation.None,
                template: `<div [ngClass]="context.headerClass" [ngSwitch]="titleHtml">
      <button *ngIf="context.showClose" type="button" class="close"
              aria-label="Close" (click)="dialog.dismiss()">
          <span aria-hidden="true">×</span>
      </button>
      <div *ngSwitchCase="1" [innerHtml]="context.titleHtml"></div>
      <h3 *ngSwitchDefault class="modal-title">{{context.title}}</h3>
 </div>`
            },] },
];
/** @nocollapse */
BSMessageModalTitle.ctorParameters = () => [
    { type: DialogRef, },
];
function BSMessageModalTitle_tsickle_Closure_declarations() {
    /** @type {!Array<{type: !Function, args: (undefined|!Array<?>)}>} */
    BSMessageModalTitle.decorators;
    /**
     * @nocollapse
     * @type {function(): !Array<(null|{type: ?, decorators: (undefined|!Array<{type: !Function, args: (undefined|!Array<?>)}>)})>}
     */
    BSMessageModalTitle.ctorParameters;
    /** @type {?} */
    BSMessageModalTitle.prototype.context;
    /** @type {?} */
    BSMessageModalTitle.prototype.dialog;
}
export class BSMessageModalBody {
    /**
     * @param {?} dialog
     */
    constructor(dialog) {
        this.dialog = dialog;
        this.context = /** @type {?} */ (dialog.context);
    }
}
BSMessageModalBody.decorators = [
    { type: Component, args: [{
                selector: 'modal-body',
                encapsulation: ViewEncapsulation.None,
                styles: [`.form-group {
    margin-top: 10px;
  }`],
                template: `<div [ngClass]="context.bodyClass">
    <div [innerHtml]="context.message"></div>
      <div *ngIf="context.showInput" class="form-group">
        <input autofocus #input
            name="bootstrap"
            type="text"
            class="form-control"
            [value]="context.defaultValue"
            (change)="context.defaultValue = input.value"
            placeholder="{{context.placeholder}}">
      </div>
    </div>
`
            },] },
];
/** @nocollapse */
BSMessageModalBody.ctorParameters = () => [
    { type: DialogRef, },
];
function BSMessageModalBody_tsickle_Closure_declarations() {
    /** @type {!Array<{type: !Function, args: (undefined|!Array<?>)}>} */
    BSMessageModalBody.decorators;
    /**
     * @nocollapse
     * @type {function(): !Array<(null|{type: ?, decorators: (undefined|!Array<{type: !Function, args: (undefined|!Array<?>)}>)})>}
     */
    BSMessageModalBody.ctorParameters;
    /** @type {?} */
    BSMessageModalBody.prototype.context;
    /** @type {?} */
    BSMessageModalBody.prototype.dialog;
}
/**
 * Represents the modal footer for storing buttons.
 */
export class BSModalFooter {
    /**
     * @param {?} dialog
     */
    constructor(dialog) {
        this.dialog = dialog;
    }
    /**
     * @param {?} btn
     * @param {?} $event
     * @return {?}
     */
    onClick(btn, $event) {
        $event.stopPropagation();
        btn.onClick(this, $event);
    }
}
BSModalFooter.decorators = [
    { type: Component, args: [{
                selector: 'modal-footer',
                encapsulation: ViewEncapsulation.None,
                template: `<div [ngClass]="dialog.context.footerClass">
    <button *ngFor="let btn of dialog.context.buttons;"
            [ngClass]="btn.cssClass"
            (click)="onClick(btn, $event)">{{btn.caption}}</button>
</div>`
            },] },
];
/** @nocollapse */
BSModalFooter.ctorParameters = () => [
    { type: DialogRef, },
];
function BSModalFooter_tsickle_Closure_declarations() {
    /** @type {!Array<{type: !Function, args: (undefined|!Array<?>)}>} */
    BSModalFooter.decorators;
    /**
     * @nocollapse
     * @type {function(): !Array<(null|{type: ?, decorators: (undefined|!Array<{type: !Function, args: (undefined|!Array<?>)}>)})>}
     */
    BSModalFooter.ctorParameters;
    /** @type {?} */
    BSModalFooter.prototype.dialog;
}
/**
 * A Component representing a generic bootstrap modal content element.
 *
 * By configuring a MessageModalContext instance you can:
 *
 *  Header:
 *      - Set header container class (default: modal-header)
 *      - Set title text (enclosed in H3 element)
 *      - Set title html (overrides text)
 *
 *  Body:
 *      - Set body container class.  (default: modal-body)
 *      - Set body container HTML.
 *
 *  Footer:
 *      - Set footer class.  (default: modal-footer)
 *      - Set button configuration (from 0 to n)
 */
export class BSMessageModal {
    /**
     * @param {?} dialog
     */
    constructor(dialog) {
        this.dialog = dialog;
    }
}
BSMessageModal.decorators = [
    { type: Component, args: [{
                selector: 'modal-content',
                encapsulation: ViewEncapsulation.None,
                template: `<modal-title></modal-title><modal-body></modal-body><modal-footer></modal-footer>`
            },] },
];
/** @nocollapse */
BSMessageModal.ctorParameters = () => [
    { type: DialogRef, },
];
function BSMessageModal_tsickle_Closure_declarations() {
    /** @type {!Array<{type: !Function, args: (undefined|!Array<?>)}>} */
    BSMessageModal.decorators;
    /**
     * @nocollapse
     * @type {function(): !Array<(null|{type: ?, decorators: (undefined|!Array<{type: !Function, args: (undefined|!Array<?>)}>)})>}
     */
    BSMessageModal.ctorParameters;
    /** @type {?} */
    BSMessageModal.prototype.dialog;
}
//# sourceMappingURL=message-modal.component.js.map
