/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
import { Component, ElementRef, ViewEncapsulation, Renderer2 } from '@angular/core';
import { BaseDynamicComponent, DialogRef } from 'ngx-modialog';
export class BSModalContainer extends BaseDynamicComponent {
    /**
     * @param {?} dialog
     * @param {?} el
     * @param {?} renderer
     */
    constructor(dialog, el, renderer) {
        super(el, renderer);
        this.dialog = dialog;
        this.activateAnimationListener();
    }
}
BSModalContainer.decorators = [
    { type: Component, args: [{
                selector: 'bs-modal-container',
                host: {
                    'tabindex': '-1',
                    'role': 'dialog',
                    'class': 'modal fade',
                    'style': 'position: absolute; display: block'
                },
                encapsulation: ViewEncapsulation.None,
                template: `<div [ngClass]="dialog.context.dialogClass"
      [class.modal-lg]="dialog.context.size == \'lg\'"
      [class.modal-sm]="dialog.context.size == \'sm\'">
  <div class="modal-content" style="display:block" role="document" overlayDialogBoundary>
    <ng-content></ng-content>
  </div>
</div>`
            },] },
];
/** @nocollapse */
BSModalContainer.ctorParameters = () => [
    { type: DialogRef, },
    { type: ElementRef, },
    { type: Renderer2, },
];
function BSModalContainer_tsickle_Closure_declarations() {
    /** @type {!Array<{type: !Function, args: (undefined|!Array<?>)}>} */
    BSModalContainer.decorators;
    /**
     * @nocollapse
     * @type {function(): !Array<(null|{type: ?, decorators: (undefined|!Array<{type: !Function, args: (undefined|!Array<?>)}>)})>}
     */
    BSModalContainer.ctorParameters;
    /** @type {?} */
    BSModalContainer.prototype.dialog;
}
//# sourceMappingURL=modal-container.component.js.map
