/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
import { combineLatest } from 'rxjs';
import { Injectable } from '@angular/core';
import { Overlay, Modal as Modal_, CSSBackdrop, PromiseCompleter } from 'ngx-modialog';
import { BSModalContainer } from './modal-container.component';
import { OneButtonPresetBuilder } from './presets/one-button-preset';
import { TwoButtonPresetBuilder, PromptPresetBuilder } from './presets/two-button-preset';
// TODO: use DI factory for this.
// TODO: consolidate dup code
const /** @type {?} */ isDoc = !(typeof document === 'undefined' || !document);
let /** @type {?} */ animationClass = 'show';
/**
 * Execute this method to flag that you are working with Bootstrap version 4.
 * @deprecated From version 5, ngx-modialog's bootstrap plugin is set to work with version 4 of bootstrap by default.
 * @return {?}
 */
export function bootstrap4Mode() { }
/**
 * Execute this method to flag that you are working with Bootstrap version 3.
 * @return {?}
 */
export function bootstrap3Mode() { animationClass = 'in'; }
export class Modal extends Modal_ {
    /**
     * @param {?} overlay
     */
    constructor(overlay) {
        super(overlay);
    }
    /**
     * @return {?}
     */
    alert() {
        return new OneButtonPresetBuilder(this, /** @type {?} */ ({ isBlocking: false }));
    }
    /**
     * @return {?}
     */
    prompt() {
        return new PromptPresetBuilder(this, /** @type {?} */ ({ isBlocking: true, keyboard: null }));
    }
    /**
     * @return {?}
     */
    confirm() {
        return new TwoButtonPresetBuilder(this, /** @type {?} */ ({ isBlocking: true, keyboard: null }));
    }
    /**
     * @param {?} dialogRef
     * @param {?} content
     * @return {?}
     */
    create(dialogRef, content) {
        const /** @type {?} */ backdropRef = this.createBackdrop(dialogRef, CSSBackdrop);
        const /** @type {?} */ containerRef = this.createContainer(dialogRef, BSModalContainer, content);
        let /** @type {?} */ overlay = dialogRef.overlayRef.instance;
        let /** @type {?} */ backdrop = backdropRef.instance;
        let /** @type {?} */ container = containerRef.instance;
        dialogRef.inElement ? overlay.insideElement() : overlay.fullscreen();
        // add body class if this is the only dialog in the stack
        if (isDoc && !document.body.classList.contains('modal-open')) {
            document.body.classList.add('modal-open');
        }
        if (dialogRef.inElement) {
            backdrop.setStyle('position', 'absolute');
        }
        backdrop.addClass('modal-backdrop fade', true);
        backdrop.addClass(animationClass);
        container.addClass(animationClass);
        if (containerRef.location.nativeElement) {
            containerRef.location.nativeElement.focus();
        }
        overlay.beforeDestroy(() => {
            const /** @type {?} */ completer = new PromiseCompleter();
            backdrop.removeClass(animationClass);
            container.removeClass(animationClass);
            combineLatest.call(backdrop.myAnimationEnd$(), container.myAnimationEnd$(), (s1, s2) => [s1, s2])
                .subscribe(sources => {
                isDoc && this.overlay.groupStackLength(dialogRef) === 1 && document.body.classList.remove('modal-open');
                completer.resolve();
            });
            return completer.promise;
        });
        return dialogRef;
    }
}
Modal.decorators = [
    { type: Injectable },
];
/** @nocollapse */
Modal.ctorParameters = () => [
    { type: Overlay, },
];
function Modal_tsickle_Closure_declarations() {
    /** @type {!Array<{type: !Function, args: (undefined|!Array<?>)}>} */
    Modal.decorators;
    /**
     * @nocollapse
     * @type {function(): !Array<(null|{type: ?, decorators: (undefined|!Array<{type: !Function, args: (undefined|!Array<?>)}>)})>}
     */
    Modal.ctorParameters;
}
//# sourceMappingURL=modal.js.map
