/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
import { privateKey, setAssignAlias, extend, arrayUnion } from 'ngx-modialog';
import { BSMessageModal } from '../message-modal.component';
import { BSModalContextBuilder } from '../modal-context';
const /** @type {?} */ DEFAULT_VALUES = {
    component: BSMessageModal,
    headerClass: 'modal-header',
    bodyClass: 'modal-body',
    footerClass: 'modal-footer'
};
const /** @type {?} */ DEFAULT_SETTERS = [
    'headerClass',
    'title',
    'titleHtml',
    'bodyClass',
    'footerClass'
];
/**
 * Data definition
 * @record
 */
export function MessageModalPreset() { }
function MessageModalPreset_tsickle_Closure_declarations() {
    /**
     * A Class for the header (title) container.
     * Default: modal-header
     * @type {?}
     */
    MessageModalPreset.prototype.headerClass;
    /**
     * Caption for the title, enclosed in a H3 container.
     * @type {?}
     */
    MessageModalPreset.prototype.title;
    /**
     * HTML for the title, if set overrides title property.
     * The HTML is wrapped in a DIV element, inside the header container.
     * Example:
     * <div class="modal-header">
     * <div> HTML CONTENT INSERTED HERE </div>
     * </div>
     * Note: HTML is not compiled.
     * @type {?}
     */
    MessageModalPreset.prototype.titleHtml;
    /**
     * aliased by 'body'
     * \@aliasedBy body
     * @type {?}
     */
    MessageModalPreset.prototype.message;
    /**
     * The body of the modal.
     * Can be either text or HTML.
     * Note: When using HTML, the template is not compiled. (binding and expression will not parse)
     * \@aliasOf message
     * @type {?}
     */
    MessageModalPreset.prototype.body;
    /**
     * A Class for the body container.
     * Default: modal-body
     * @type {?}
     */
    MessageModalPreset.prototype.bodyClass;
    /**
     * A Class for the footer container.
     * Default: modal-footer
     * @type {?}
     */
    MessageModalPreset.prototype.footerClass;
    /** @type {?} */
    MessageModalPreset.prototype.buttons;
    /** @type {?|undefined} */
    MessageModalPreset.prototype.showInput;
}
// unsupported: template constraints.
/**
 * A Preset representing the configuration needed to open MessageModal.
 * This is an abstract implementation with no concrete behaviour.
 * Use derived implementation.
 * @abstract
 * @template T
 */
export class MessageModalPresetBuilder extends BSModalContextBuilder {
    /**
     * @param {?=} defaultValues
     * @param {?=} initialSetters
     * @param {?=} baseType
     */
    constructor(defaultValues = undefined, initialSetters = undefined, baseType = undefined) {
        super(extend(extend({ buttons: [] }, DEFAULT_VALUES), defaultValues || {}), arrayUnion(DEFAULT_SETTERS, initialSetters || []), baseType);
        setAssignAlias(this, 'body', 'message', true);
    }
    /**
     * @param {?} css
     * @param {?} caption
     * @param {?} onClick
     * @return {?}
     */
    addButton(css, caption, onClick) {
        let /** @type {?} */ btn = {
            cssClass: css,
            caption: caption,
            onClick: onClick
        };
        let /** @type {?} */ key = privateKey('buttons');
        (/** @type {?} */ (this[key])).push(btn);
        return this;
    }
}
function MessageModalPresetBuilder_tsickle_Closure_declarations() {
    /**
     * A Class for the header (title) container.
     * Default: modal-header
     * @type {?}
     */
    MessageModalPresetBuilder.prototype.headerClass;
    /**
     * Caption for the title, enclosed in a H3 container.
     * @type {?}
     */
    MessageModalPresetBuilder.prototype.title;
    /**
     * HTML for the title, if set overrides title property.
     * The HTML is wrapped in a DIV element, inside the header container.
     * Example:
     * <div class="modal-header">
     * <div> HTML CONTENT INSERTED HERE </div>
     * </div>
     * Note: HTML is not compiled.
     * @type {?}
     */
    MessageModalPresetBuilder.prototype.titleHtml;
    /**
     * aliased by 'body'
     * \@aliasedBy body
     * @type {?}
     */
    MessageModalPresetBuilder.prototype.message;
    /**
     * The body of the modal.
     * Can be either text or HTML.
     * Note: When using HTML, the template is not compiled. (binding and expression will not parse)
     * \@aliasOf message
     * @type {?}
     */
    MessageModalPresetBuilder.prototype.body;
    /**
     * A Class for the body container.
     * Default: modal-body
     * @type {?}
     */
    MessageModalPresetBuilder.prototype.bodyClass;
    /**
     * A Class for the footer container.
     * Default: modal-footer
     * @type {?}
     */
    MessageModalPresetBuilder.prototype.footerClass;
}
//# sourceMappingURL=message-modal-preset.js.map
