/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
import { extend } from 'ngx-modialog';
import { MessageModalPresetBuilder } from './message-modal-preset';
/**
 * @record
 */
export function OneButtonPreset() { }
function OneButtonPreset_tsickle_Closure_declarations() {
    /**
     * Caption for the OK button.
     * Default: OK
     * @type {?}
     */
    OneButtonPreset.prototype.okBtn;
    /**
     * A Class for the OK button.
     * Default: btn btn-primary
     * @type {?}
     */
    OneButtonPreset.prototype.okBtnClass;
}
/**
 * A Preset for a classic 1 button modal window.
 */
export class OneButtonPresetBuilder extends MessageModalPresetBuilder {
    /**
     * @param {?} modal
     * @param {?=} defaultValues
     */
    constructor(modal, defaultValues = undefined) {
        super(extend({
            modal: modal,
            okBtn: 'OK',
            okBtnClass: 'btn btn-primary'
        }, defaultValues || {}), [
            'okBtn',
            'okBtnClass'
        ]);
    }
    /**
     * @param {?} config
     * @return {?}
     */
    $$beforeOpen(config) {
        super.$$beforeOpen(config);
        this.addButton(config.okBtnClass, config.okBtn, (cmp, $event) => cmp.dialog.close(true));
    }
}
function OneButtonPresetBuilder_tsickle_Closure_declarations() {
    /** @type {?} */
    OneButtonPresetBuilder.prototype.okBtn;
    /** @type {?} */
    OneButtonPresetBuilder.prototype.okBtnClass;
}
//# sourceMappingURL=one-button-preset.js.map
