import * as tslib_1 from "tslib";
/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
import { combineLatest } from 'rxjs';
import { Injectable } from '@angular/core';
import { Overlay, Modal as Modal_, CSSBackdrop, PromiseCompleter } from 'ngx-modialog';
import { BSModalContainer } from './modal-container.component';
import { OneButtonPresetBuilder } from './presets/one-button-preset';
import { TwoButtonPresetBuilder, PromptPresetBuilder } from './presets/two-button-preset';
// TODO: use DI factory for this.
// TODO: consolidate dup code
var /** @type {?} */ isDoc = !(typeof document === 'undefined' || !document);
var /** @type {?} */ animationClass = 'show';
/**
 * Execute this method to flag that you are working with Bootstrap version 4.
 * @deprecated From version 5, ngx-modialog's bootstrap plugin is set to work with version 4 of bootstrap by default.
 * @return {?}
 */
export function bootstrap4Mode() { }
/**
 * Execute this method to flag that you are working with Bootstrap version 3.
 * @return {?}
 */
export function bootstrap3Mode() { animationClass = 'in'; }
var Modal = /** @class */ (function (_super) {
    tslib_1.__extends(Modal, _super);
    /**
     * @param {?} overlay
     */
    function Modal(overlay) {
        return _super.call(this, overlay) || this;
    }
    /**
     * @return {?}
     */
    Modal.prototype.alert = function () {
        return new OneButtonPresetBuilder(this, /** @type {?} */ ({ isBlocking: false }));
    };
    /**
     * @return {?}
     */
    Modal.prototype.prompt = function () {
        return new PromptPresetBuilder(this, /** @type {?} */ ({ isBlocking: true, keyboard: null }));
    };
    /**
     * @return {?}
     */
    Modal.prototype.confirm = function () {
        return new TwoButtonPresetBuilder(this, /** @type {?} */ ({ isBlocking: true, keyboard: null }));
    };
    /**
     * @param {?} dialogRef
     * @param {?} content
     * @return {?}
     */
    Modal.prototype.create = function (dialogRef, content) {
        var _this = this;
        var /** @type {?} */ backdropRef = this.createBackdrop(dialogRef, CSSBackdrop);
        var /** @type {?} */ containerRef = this.createContainer(dialogRef, BSModalContainer, content);
        var /** @type {?} */ overlay = dialogRef.overlayRef.instance;
        var /** @type {?} */ backdrop = backdropRef.instance;
        var /** @type {?} */ container = containerRef.instance;
        dialogRef.inElement ? overlay.insideElement() : overlay.fullscreen();
        // add body class if this is the only dialog in the stack
        if (isDoc && !document.body.classList.contains('modal-open')) {
            document.body.classList.add('modal-open');
        }
        if (dialogRef.inElement) {
            backdrop.setStyle('position', 'absolute');
        }
        backdrop.addClass('modal-backdrop fade', true);
        backdrop.addClass(animationClass);
        container.addClass(animationClass);
        if (containerRef.location.nativeElement) {
            containerRef.location.nativeElement.focus();
        }
        overlay.beforeDestroy(function () {
            var /** @type {?} */ completer = new PromiseCompleter();
            backdrop.removeClass(animationClass);
            container.removeClass(animationClass);
            combineLatest.call(backdrop.myAnimationEnd$(), container.myAnimationEnd$(), function (s1, s2) { return [s1, s2]; })
                .subscribe(function (sources) {
                isDoc && _this.overlay.groupStackLength(dialogRef) === 1 && document.body.classList.remove('modal-open');
                completer.resolve();
            });
            return completer.promise;
        });
        return dialogRef;
    };
    return Modal;
}(Modal_));
export { Modal };
Modal.decorators = [
    { type: Injectable },
];
/** @nocollapse */
Modal.ctorParameters = function () { return [
    { type: Overlay, },
]; };
function Modal_tsickle_Closure_declarations() {
    /** @type {!Array<{type: !Function, args: (undefined|!Array<?>)}>} */
    Modal.decorators;
    /**
     * @nocollapse
     * @type {function(): !Array<(null|{type: ?, decorators: (undefined|!Array<{type: !Function, args: (undefined|!Array<?>)}>)})>}
     */
    Modal.ctorParameters;
}
//# sourceMappingURL=modal.js.map
