import * as tslib_1 from "tslib";
/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
import { extend } from 'ngx-modialog';
import { MessageModalPresetBuilder } from './message-modal-preset';
/**
 * @record
 */
export function OneButtonPreset() { }
function OneButtonPreset_tsickle_Closure_declarations() {
    /**
     * Caption for the OK button.
     * Default: OK
     * @type {?}
     */
    OneButtonPreset.prototype.okBtn;
    /**
     * A Class for the OK button.
     * Default: btn btn-primary
     * @type {?}
     */
    OneButtonPreset.prototype.okBtnClass;
}
/**
 * A Preset for a classic 1 button modal window.
 */
var OneButtonPresetBuilder = /** @class */ (function (_super) {
    tslib_1.__extends(OneButtonPresetBuilder, _super);
    /**
     * @param {?} modal
     * @param {?=} defaultValues
     */
    function OneButtonPresetBuilder(modal, defaultValues) {
        if (defaultValues === void 0) { defaultValues = undefined; }
        return _super.call(this, extend({
            modal: modal,
            okBtn: 'OK',
            okBtnClass: 'btn btn-primary'
        }, defaultValues || {}), [
            'okBtn',
            'okBtnClass'
        ]) || this;
    }
    /**
     * @param {?} config
     * @return {?}
     */
    OneButtonPresetBuilder.prototype.$$beforeOpen = function (config) {
        _super.prototype.$$beforeOpen.call(this, config);
        this.addButton(config.okBtnClass, config.okBtn, function (cmp, $event) { return cmp.dialog.close(true); });
    };
    return OneButtonPresetBuilder;
}(MessageModalPresetBuilder));
export { OneButtonPresetBuilder };
function OneButtonPresetBuilder_tsickle_Closure_declarations() {
    /** @type {?} */
    OneButtonPresetBuilder.prototype.okBtn;
    /** @type {?} */
    OneButtonPresetBuilder.prototype.okBtnClass;
}
//# sourceMappingURL=one-button-preset.js.map
