import * as tslib_1 from "tslib";
/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
import { extend, arrayUnion } from 'ngx-modialog';
import { MessageModalPresetBuilder } from './message-modal-preset';
/**
 * @record
 */
export function TwoButtonPreset() { }
function TwoButtonPreset_tsickle_Closure_declarations() {
    /**
     * Caption for the Cancel button.
     * Default: Cancel
     * @type {?}
     */
    TwoButtonPreset.prototype.cancelBtn;
    /**
     * A Class for the Cancel button.
     * Default: btn btn-default
     * @type {?}
     */
    TwoButtonPreset.prototype.cancelBtnClass;
}
/**
 * Common two button preset
 * @abstract
 */
var AbstractTwoButtonPresetBuilder = /** @class */ (function (_super) {
    tslib_1.__extends(AbstractTwoButtonPresetBuilder, _super);
    /**
     * @param {?} modal
     * @param {?=} defaultValues
     * @param {?=} initialSetters
     */
    function AbstractTwoButtonPresetBuilder(modal, defaultValues, initialSetters) {
        if (defaultValues === void 0) { defaultValues = undefined; }
        if (initialSetters === void 0) { initialSetters = []; }
        return _super.call(this, extend({
            modal: modal,
            okBtn: 'OK',
            okBtnClass: 'btn btn-primary',
            cancelBtn: 'Cancel',
            cancelBtnClass: 'btn btn-default'
        }, defaultValues || {}), arrayUnion([
            'okBtn',
            'okBtnClass',
            'cancelBtn',
            'cancelBtnClass',
        ], initialSetters)) || this;
    }
    /**
     * @param {?} config
     * @return {?}
     */
    AbstractTwoButtonPresetBuilder.prototype.$$beforeOpen = function (config) {
        _super.prototype.$$beforeOpen.call(this, config);
        this.addButton(config.cancelBtnClass, config.cancelBtn, function (cmp, $event) { return cmp.dialog.dismiss(); });
    };
    return AbstractTwoButtonPresetBuilder;
}(MessageModalPresetBuilder));
export { AbstractTwoButtonPresetBuilder };
function AbstractTwoButtonPresetBuilder_tsickle_Closure_declarations() {
    /** @type {?} */
    AbstractTwoButtonPresetBuilder.prototype.okBtn;
    /** @type {?} */
    AbstractTwoButtonPresetBuilder.prototype.okBtnClass;
    /** @type {?} */
    AbstractTwoButtonPresetBuilder.prototype.cancelBtn;
    /** @type {?} */
    AbstractTwoButtonPresetBuilder.prototype.cancelBtnClass;
}
/**
 * A Preset for a classic 2 button modal window.
 */
var TwoButtonPresetBuilder = /** @class */ (function (_super) {
    tslib_1.__extends(TwoButtonPresetBuilder, _super);
    /**
     * @param {?} modal
     * @param {?=} defaultValues
     */
    function TwoButtonPresetBuilder(modal, defaultValues) {
        if (defaultValues === void 0) { defaultValues = undefined; }
        return _super.call(this, modal, defaultValues) || this;
    }
    /**
     * @param {?} config
     * @return {?}
     */
    TwoButtonPresetBuilder.prototype.$$beforeOpen = function (config) {
        _super.prototype.$$beforeOpen.call(this, config);
        this.addButton(config.okBtnClass, config.okBtn, function (cmp, $event) { return cmp.dialog.close(true); });
    };
    return TwoButtonPresetBuilder;
}(AbstractTwoButtonPresetBuilder));
export { TwoButtonPresetBuilder };
/**
 * @record
 */
export function PromptPreset() { }
function PromptPreset_tsickle_Closure_declarations() {
    /** @type {?} */
    PromptPreset.prototype.showInput;
    /**
     * Default value shown in the prompt.
     * @type {?}
     */
    PromptPreset.prototype.defaultValue;
    /**
     * A placeholder for the input element.
     * @type {?}
     */
    PromptPreset.prototype.placeholder;
}
var PromptPresetBuilder = /** @class */ (function (_super) {
    tslib_1.__extends(PromptPresetBuilder, _super);
    /**
     * @param {?} modal
     * @param {?=} defaultValues
     */
    function PromptPresetBuilder(modal, defaultValues) {
        if (defaultValues === void 0) { defaultValues = undefined; }
        return _super.call(this, modal, extend({ showInput: true, defaultValue: '' }, defaultValues || {}), ['placeholder', 'defaultValue']) || this;
    }
    /**
     * @param {?} config
     * @return {?}
     */
    PromptPresetBuilder.prototype.$$beforeOpen = function (config) {
        _super.prototype.$$beforeOpen.call(this, config);
        this.addButton(config.okBtnClass, config.okBtn, function (cmp, $event) { return cmp.dialog.close(((cmp.dialog.context)).defaultValue); });
    };
    return PromptPresetBuilder;
}(AbstractTwoButtonPresetBuilder));
export { PromptPresetBuilder };
function PromptPresetBuilder_tsickle_Closure_declarations() {
    /** @type {?} */
    PromptPresetBuilder.prototype.placeholder;
    /** @type {?} */
    PromptPresetBuilder.prototype.defaultValue;
}
//# sourceMappingURL=two-button-preset.js.map
