import { ModalOpenContext, ModalOpenContextBuilder, extend, arrayUnion, BaseDynamicComponent, DialogRef, privateKey, setAssignAlias, Overlay, Modal, CSSBackdrop, PromiseCompleter, ModalModule } from 'ngx-modialog';
export { ModalOpenContext, ModalOpenContextBuilder } from 'ngx-modialog';
import { Component, ElementRef, ViewEncapsulation, Renderer2, Injectable, NgModule } from '@angular/core';
import { combineLatest } from 'rxjs';
import { CommonModule } from '@angular/common';

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
const /** @type {?} */ DEFAULT_VALUES = {
    dialogClass: 'modal-dialog',
    showClose: false
};
const /** @type {?} */ DEFAULT_SETTERS = [
    'dialogClass',
    'size',
    'showClose'
];
class BSModalContext extends ModalOpenContext {
    /**
     * @return {?}
     */
    normalize() {
        if (!this.dialogClass) {
            this.dialogClass = DEFAULT_VALUES.dialogClass;
        }
        super.normalize();
    }
}
// unsupported: template constraints.
/**
 * @template T
 */
class BSModalContextBuilder extends ModalOpenContextBuilder {
    /**
     * @param {?=} defaultValues
     * @param {?=} initialSetters
     * @param {?=} baseType
     */
    constructor(defaultValues = undefined, initialSetters = undefined, baseType = undefined) {
        super(extend(DEFAULT_VALUES, defaultValues || {}), arrayUnion(DEFAULT_SETTERS, initialSetters || []), baseType || /** @type {?} */ (BSModalContext // https://github.com/Microsoft/TypeScript/issues/7234
        ) // https://github.com/Microsoft/TypeScript/issues/7234
        );
    }
}

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
class BSModalContainer extends BaseDynamicComponent {
    /**
     * @param {?} dialog
     * @param {?} el
     * @param {?} renderer
     */
    constructor(dialog, el, renderer) {
        super(el, renderer);
        this.dialog = dialog;
        this.activateAnimationListener();
    }
}
BSModalContainer.decorators = [
    { type: Component, args: [{
                selector: 'bs-modal-container',
                host: {
                    'tabindex': '-1',
                    'role': 'dialog',
                    'class': 'modal fade',
                    'style': 'position: absolute; display: block'
                },
                encapsulation: ViewEncapsulation.None,
                template: `<div [ngClass]="dialog.context.dialogClass"
      [class.modal-lg]="dialog.context.size == \'lg\'"
      [class.modal-sm]="dialog.context.size == \'sm\'">
  <div class="modal-content" style="display:block" role="document" overlayDialogBoundary>
    <ng-content></ng-content>
  </div>
</div>`
            },] },
];
/** @nocollapse */
BSModalContainer.ctorParameters = () => [
    { type: DialogRef, },
    { type: ElementRef, },
    { type: Renderer2, },
];

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
class BSMessageModalTitle {
    /**
     * @param {?} dialog
     */
    constructor(dialog) {
        this.dialog = dialog;
        this.context = dialog.context;
    }
    /**
     * @return {?}
     */
    get titleHtml() {
        return this.context.titleHtml ? 1 : 0;
    }
}
BSMessageModalTitle.decorators = [
    { type: Component, args: [{
                selector: 'modal-title',
                encapsulation: ViewEncapsulation.None,
                template: `<div [ngClass]="context.headerClass" [ngSwitch]="titleHtml">
      <button *ngIf="context.showClose" type="button" class="close"
              aria-label="Close" (click)="dialog.dismiss()">
          <span aria-hidden="true">×</span>
      </button>
      <div *ngSwitchCase="1" [innerHtml]="context.titleHtml"></div>
      <h3 *ngSwitchDefault class="modal-title">{{context.title}}</h3>
 </div>`
            },] },
];
/** @nocollapse */
BSMessageModalTitle.ctorParameters = () => [
    { type: DialogRef, },
];
class BSMessageModalBody {
    /**
     * @param {?} dialog
     */
    constructor(dialog) {
        this.dialog = dialog;
        this.context = /** @type {?} */ (dialog.context);
    }
}
BSMessageModalBody.decorators = [
    { type: Component, args: [{
                selector: 'modal-body',
                encapsulation: ViewEncapsulation.None,
                styles: [`.form-group {
    margin-top: 10px;
  }`],
                template: `<div [ngClass]="context.bodyClass">
    <div [innerHtml]="context.message"></div>
      <div *ngIf="context.showInput" class="form-group">
        <input autofocus #input
            name="bootstrap"
            type="text"
            class="form-control"
            [value]="context.defaultValue"
            (change)="context.defaultValue = input.value"
            placeholder="{{context.placeholder}}">
      </div>
    </div>
`
            },] },
];
/** @nocollapse */
BSMessageModalBody.ctorParameters = () => [
    { type: DialogRef, },
];
/**
 * Represents the modal footer for storing buttons.
 */
class BSModalFooter {
    /**
     * @param {?} dialog
     */
    constructor(dialog) {
        this.dialog = dialog;
    }
    /**
     * @param {?} btn
     * @param {?} $event
     * @return {?}
     */
    onClick(btn, $event) {
        $event.stopPropagation();
        btn.onClick(this, $event);
    }
}
BSModalFooter.decorators = [
    { type: Component, args: [{
                selector: 'modal-footer',
                encapsulation: ViewEncapsulation.None,
                template: `<div [ngClass]="dialog.context.footerClass">
    <button *ngFor="let btn of dialog.context.buttons;"
            [ngClass]="btn.cssClass"
            (click)="onClick(btn, $event)">{{btn.caption}}</button>
</div>`
            },] },
];
/** @nocollapse */
BSModalFooter.ctorParameters = () => [
    { type: DialogRef, },
];
/**
 * A Component representing a generic bootstrap modal content element.
 *
 * By configuring a MessageModalContext instance you can:
 *
 *  Header:
 *      - Set header container class (default: modal-header)
 *      - Set title text (enclosed in H3 element)
 *      - Set title html (overrides text)
 *
 *  Body:
 *      - Set body container class.  (default: modal-body)
 *      - Set body container HTML.
 *
 *  Footer:
 *      - Set footer class.  (default: modal-footer)
 *      - Set button configuration (from 0 to n)
 */
class BSMessageModal {
    /**
     * @param {?} dialog
     */
    constructor(dialog) {
        this.dialog = dialog;
    }
}
BSMessageModal.decorators = [
    { type: Component, args: [{
                selector: 'modal-content',
                encapsulation: ViewEncapsulation.None,
                template: `<modal-title></modal-title><modal-body></modal-body><modal-footer></modal-footer>`
            },] },
];
/** @nocollapse */
BSMessageModal.ctorParameters = () => [
    { type: DialogRef, },
];

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
const /** @type {?} */ DEFAULT_VALUES$1 = {
    component: BSMessageModal,
    headerClass: 'modal-header',
    bodyClass: 'modal-body',
    footerClass: 'modal-footer'
};
const /** @type {?} */ DEFAULT_SETTERS$1 = [
    'headerClass',
    'title',
    'titleHtml',
    'bodyClass',
    'footerClass'
];
// unsupported: template constraints.
/**
 * A Preset representing the configuration needed to open MessageModal.
 * This is an abstract implementation with no concrete behaviour.
 * Use derived implementation.
 * @abstract
 * @template T
 */
class MessageModalPresetBuilder extends BSModalContextBuilder {
    /**
     * @param {?=} defaultValues
     * @param {?=} initialSetters
     * @param {?=} baseType
     */
    constructor(defaultValues = undefined, initialSetters = undefined, baseType = undefined) {
        super(extend(extend({ buttons: [] }, DEFAULT_VALUES$1), defaultValues || {}), arrayUnion(DEFAULT_SETTERS$1, initialSetters || []), baseType);
        setAssignAlias(this, 'body', 'message', true);
    }
    /**
     * @param {?} css
     * @param {?} caption
     * @param {?} onClick
     * @return {?}
     */
    addButton(css, caption, onClick) {
        let /** @type {?} */ btn = {
            cssClass: css,
            caption: caption,
            onClick: onClick
        };
        let /** @type {?} */ key = privateKey('buttons');
        (/** @type {?} */ (this[key])).push(btn);
        return this;
    }
}

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
/**
 * A Preset for a classic 1 button modal window.
 */
class OneButtonPresetBuilder extends MessageModalPresetBuilder {
    /**
     * @param {?} modal
     * @param {?=} defaultValues
     */
    constructor(modal, defaultValues = undefined) {
        super(extend({
            modal: modal,
            okBtn: 'OK',
            okBtnClass: 'btn btn-primary'
        }, defaultValues || {}), [
            'okBtn',
            'okBtnClass'
        ]);
    }
    /**
     * @param {?} config
     * @return {?}
     */
    $$beforeOpen(config) {
        super.$$beforeOpen(config);
        this.addButton(config.okBtnClass, config.okBtn, (cmp, $event) => cmp.dialog.close(true));
    }
}

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
/**
 * Common two button preset
 * @abstract
 */
class AbstractTwoButtonPresetBuilder extends MessageModalPresetBuilder {
    /**
     * @param {?} modal
     * @param {?=} defaultValues
     * @param {?=} initialSetters
     */
    constructor(modal, defaultValues = undefined, initialSetters = []) {
        super(extend({
            modal: modal,
            okBtn: 'OK',
            okBtnClass: 'btn btn-primary',
            cancelBtn: 'Cancel',
            cancelBtnClass: 'btn btn-default'
        }, defaultValues || {}), arrayUnion([
            'okBtn',
            'okBtnClass',
            'cancelBtn',
            'cancelBtnClass',
        ], initialSetters));
    }
    /**
     * @param {?} config
     * @return {?}
     */
    $$beforeOpen(config) {
        super.$$beforeOpen(config);
        this.addButton(config.cancelBtnClass, config.cancelBtn, (cmp, $event) => cmp.dialog.dismiss());
    }
}
/**
 * A Preset for a classic 2 button modal window.
 */
class TwoButtonPresetBuilder extends AbstractTwoButtonPresetBuilder {
    /**
     * @param {?} modal
     * @param {?=} defaultValues
     */
    constructor(modal, defaultValues = undefined) {
        super(modal, defaultValues);
    }
    /**
     * @param {?} config
     * @return {?}
     */
    $$beforeOpen(config) {
        super.$$beforeOpen(config);
        this.addButton(config.okBtnClass, config.okBtn, (cmp, $event) => cmp.dialog.close(true));
    }
}
class PromptPresetBuilder extends AbstractTwoButtonPresetBuilder {
    /**
     * @param {?} modal
     * @param {?=} defaultValues
     */
    constructor(modal, defaultValues = undefined) {
        super(modal, extend({ showInput: true, defaultValue: '' }, defaultValues || {}), ['placeholder', 'defaultValue']);
    }
    /**
     * @param {?} config
     * @return {?}
     */
    $$beforeOpen(config) {
        super.$$beforeOpen(config);
        this.addButton(config.okBtnClass, config.okBtn, (cmp, $event) => cmp.dialog.close((/** @type {?} */ (cmp.dialog.context)).defaultValue));
    }
}

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
// TODO: use DI factory for this.
// TODO: consolidate dup code
const /** @type {?} */ isDoc = !(typeof document === 'undefined' || !document);
let /** @type {?} */ animationClass = 'show';
/**
 * Execute this method to flag that you are working with Bootstrap version 4.
 * @deprecated From version 5, ngx-modialog's bootstrap plugin is set to work with version 4 of bootstrap by default.
 * @return {?}
 */
function bootstrap4Mode() { }
/**
 * Execute this method to flag that you are working with Bootstrap version 3.
 * @return {?}
 */
function bootstrap3Mode() { animationClass = 'in'; }
class Modal$1 extends Modal {
    /**
     * @param {?} overlay
     */
    constructor(overlay) {
        super(overlay);
    }
    /**
     * @return {?}
     */
    alert() {
        return new OneButtonPresetBuilder(this, /** @type {?} */ ({ isBlocking: false }));
    }
    /**
     * @return {?}
     */
    prompt() {
        return new PromptPresetBuilder(this, /** @type {?} */ ({ isBlocking: true, keyboard: null }));
    }
    /**
     * @return {?}
     */
    confirm() {
        return new TwoButtonPresetBuilder(this, /** @type {?} */ ({ isBlocking: true, keyboard: null }));
    }
    /**
     * @param {?} dialogRef
     * @param {?} content
     * @return {?}
     */
    create(dialogRef, content) {
        const /** @type {?} */ backdropRef = this.createBackdrop(dialogRef, CSSBackdrop);
        const /** @type {?} */ containerRef = this.createContainer(dialogRef, BSModalContainer, content);
        let /** @type {?} */ overlay = dialogRef.overlayRef.instance;
        let /** @type {?} */ backdrop = backdropRef.instance;
        let /** @type {?} */ container = containerRef.instance;
        dialogRef.inElement ? overlay.insideElement() : overlay.fullscreen();
        // add body class if this is the only dialog in the stack
        if (isDoc && !document.body.classList.contains('modal-open')) {
            document.body.classList.add('modal-open');
        }
        if (dialogRef.inElement) {
            backdrop.setStyle('position', 'absolute');
        }
        backdrop.addClass('modal-backdrop fade', true);
        backdrop.addClass(animationClass);
        container.addClass(animationClass);
        if (containerRef.location.nativeElement) {
            containerRef.location.nativeElement.focus();
        }
        overlay.beforeDestroy(() => {
            const /** @type {?} */ completer = new PromiseCompleter();
            backdrop.removeClass(animationClass);
            container.removeClass(animationClass);
            combineLatest.call(backdrop.myAnimationEnd$(), container.myAnimationEnd$(), (s1, s2) => [s1, s2])
                .subscribe(sources => {
                isDoc && this.overlay.groupStackLength(dialogRef) === 1 && document.body.classList.remove('modal-open');
                completer.resolve();
            });
            return completer.promise;
        });
        return dialogRef;
    }
}
Modal$1.decorators = [
    { type: Injectable },
];
/** @nocollapse */
Modal$1.ctorParameters = () => [
    { type: Overlay, },
];

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
const /** @type {?} */ providers = [
    { provide: Modal, useClass: Modal$1 },
    { provide: Modal$1, useClass: Modal$1 }
];
class BootstrapModalModule {
    /**
     * @return {?}
     */
    static getProviders() {
        return providers;
    }
}
BootstrapModalModule.decorators = [
    { type: NgModule, args: [{
                imports: [ModalModule, CommonModule],
                declarations: [
                    BSModalFooter,
                    BSMessageModalTitle,
                    BSMessageModalBody,
                    BSMessageModal,
                    BSModalContainer
                ],
                providers,
                entryComponents: [
                    BSModalContainer,
                    BSMessageModal
                ]
            },] },
];

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */

export { BSModalContext, BSModalContextBuilder, BSModalContainer, BSMessageModal, BSMessageModalTitle, BSMessageModalBody, BSModalFooter, MessageModalPresetBuilder, OneButtonPresetBuilder, TwoButtonPresetBuilder, PromptPresetBuilder, Modal$1 as Modal, bootstrap3Mode, bootstrap4Mode, BootstrapModalModule, providers, AbstractTwoButtonPresetBuilder as ɵa };
//# sourceMappingURL=ngx-modialog-plugins-bootstrap.js.map
