(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('tslib'), require('ngx-modialog'), require('@angular/core')) :
    typeof define === 'function' && define.amd ? define('ngxModialog.plugins.jsNative', ['exports', 'tslib', 'ngx-modialog', '@angular/core'], factory) :
    (factory((global.ngxModialog = global.ngxModialog || {}, global.ngxModialog.plugins = global.ngxModialog.plugins || {}, global.ngxModialog.plugins.jsNative = {}),global.tslib,global.ngxModialog,global.ng.core));
}(this, (function (exports,tslib,ngxModialog,core) { 'use strict';

    var /** @type {?} */ DEFAULT_SETTERS = [
        'promptDefault'
    ];
    var JSNativeModalContext = (function (_super) {
        tslib.__extends(JSNativeModalContext, _super);
        function JSNativeModalContext() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        /**
         * @return {?}
         */
        JSNativeModalContext.prototype.normalize = function () {
            if (!this.message)
                this.message = '';
            if (this.dialogType === undefined)
                this.dialogType = ngxModialog.DROP_IN_TYPE.alert;
        };
        return JSNativeModalContext;
    }(ngxModialog.ModalOpenContext));
    // unsupported: template constraints.
    /**
     * @template T
     */
    var JSNativeModalContextBuilder = (function (_super) {
        tslib.__extends(JSNativeModalContextBuilder, _super);
        /**
         * @param {?=} defaultValues
         * @param {?=} initialSetters
         * @param {?=} baseType
         */
        function JSNativeModalContextBuilder(defaultValues, initialSetters, baseType) {
            if (defaultValues === void 0) {
                defaultValues = undefined;
            }
            if (initialSetters === void 0) {
                initialSetters = undefined;
            }
            if (baseType === void 0) {
                baseType = undefined;
            }
            return _super.call(this, defaultValues || /** @type {?} */ ({}), ngxModialog.arrayUnion(DEFAULT_SETTERS, initialSetters || []), baseType || /** @type {?} */ (JSNativeModalContext)) || this;
        }
        return JSNativeModalContextBuilder;
    }(ngxModialog.ModalOpenContextBuilder));
    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var JSNativeModalRenderer = (function () {
        function JSNativeModalRenderer() {
        }
        /**
         * @param {?} dialog
         * @param {?} vcRef
         * @return {?}
         */
        JSNativeModalRenderer.prototype.render = function (dialog, vcRef) {
            var /** @type {?} */ result;
            switch (dialog.context.dialogType) {
                case ngxModialog.DROP_IN_TYPE.alert:
                    window.alert(dialog.context.message);
                    result = true;
                    break;
                case ngxModialog.DROP_IN_TYPE.prompt:
                    result = window.prompt(dialog.context.message, dialog.context.promptDefault);
                    break;
                case ngxModialog.DROP_IN_TYPE.confirm:
                    result = window.confirm(dialog.context.message);
                    break;
            }
            dialog.destroy = function () {
            };
            if (result === false) {
                dialog.dismiss();
            }
            else {
                dialog.close(result);
            }
            // we need to return ComponentRef<ModalOverlay> but a native dialog does'nt have that
            // so we resolve an empty promise, the user of this renderer should expect that.
            return /** @type {?} */ ({});
        };
        return JSNativeModalRenderer;
    }());
    JSNativeModalRenderer.decorators = [
        { type: core.Injectable },
    ];
    var JSNativePresetBuilder = (function (_super) {
        tslib.__extends(JSNativePresetBuilder, _super);
        /**
         * @param {?} modal
         * @param {?} dialogType
         */
        function JSNativePresetBuilder(modal, dialogType) {
            return _super.call(this, /** @type {?} */ ({ modal: modal, dialogType: dialogType })) || this;
        }
        /**
         * Open a modal window based on the configuration of this config instance.
         * @param {?=} viewContainer If set opens the modal inside the supplied viewContainer
         * @return {?}
         */
        JSNativePresetBuilder.prototype.open = function (viewContainer) {
            var /** @type {?} */ context = this.toJSON();
            if (!(context.modal instanceof Modal$1)) {
                return /** @type {?} */ (Promise.reject(new Error('Configuration Error: modal service not set.')));
            }
            this.$$beforeOpen(context);
            var /** @type {?} */ overlayConfig = {
                context: context,
                renderer: new JSNativeModalRenderer(),
                viewContainer: viewContainer
            };
            return context.modal.open(context.component, overlayConfig);
        };
        return JSNativePresetBuilder;
    }(JSNativeModalContextBuilder));
    var Modal$1 = (function (_super) {
        tslib.__extends(Modal$$1, _super);
        /**
         * @param {?} overlay
         */
        function Modal$$1(overlay) {
            return _super.call(this, overlay) || this;
        }
        /**
         * @return {?}
         */
        Modal$$1.prototype.alert = function () {
            return new JSNativePresetBuilder(this, ngxModialog.DROP_IN_TYPE.alert);
        };
        /**
         * @return {?}
         */
        Modal$$1.prototype.prompt = function () {
            return new JSNativePresetBuilder(this, ngxModialog.DROP_IN_TYPE.prompt);
        };
        /**
         * @return {?}
         */
        Modal$$1.prototype.confirm = function () {
            return new JSNativePresetBuilder(this, ngxModialog.DROP_IN_TYPE.confirm);
        };
        /**
         * @param {?} dialogRef
         * @param {?} type
         * @return {?}
         */
        Modal$$1.prototype.create = function (dialogRef, type) {
            return dialogRef;
        };
        return Modal$$1;
    }(ngxModialog.Modal));
    Modal$1.decorators = [
        { type: core.Injectable },
    ];
    /** @nocollapse */
    Modal$1.ctorParameters = function () {
        return [
            { type: ngxModialog.Overlay, },
        ];
    };
    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var /** @type {?} */ providers = [
        { provide: ngxModialog.Modal, useClass: Modal$1 },
        { provide: Modal$1, useClass: Modal$1 }
    ];
    var JSNativeModalModule = (function () {
        function JSNativeModalModule() {
        }
        /**
         * @return {?}
         */
        JSNativeModalModule.getProviders = function () {
            return providers;
        };
        return JSNativeModalModule;
    }());
    JSNativeModalModule.decorators = [
        { type: core.NgModule, args: [{
                    providers: providers
                },] },
    ];

    exports.Modal = Modal$1;
    exports.JSNativeModalContext = JSNativeModalContext;
    exports.JSNativeModalContextBuilder = JSNativeModalContextBuilder;
    exports.JSNativeModalRenderer = JSNativeModalRenderer;
    exports.JSNativePresetBuilder = JSNativePresetBuilder;
    exports.JSNativeModalModule = JSNativeModalModule;
    exports.providers = providers;

    Object.defineProperty(exports, '__esModule', { value: true });

})));
//# sourceMappingURL=ngx-modialog-plugins-js-native.umd.js.map
