/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
import { Modal } from '../modal';
import { JSNativeModalContextBuilder } from '../modal-context';
import { JSNativeModalRenderer } from '../js-native-modal-renderer';
export class JSNativePresetBuilder extends JSNativeModalContextBuilder {
    /**
     * @param {?} modal
     * @param {?} dialogType
     */
    constructor(modal, dialogType) {
        super(/** @type {?} */ ({ modal, dialogType }));
    }
    /**
     * Open a modal window based on the configuration of this config instance.
     * @param {?=} viewContainer If set opens the modal inside the supplied viewContainer
     * @return {?}
     */
    open(viewContainer) {
        let /** @type {?} */ context = this.toJSON();
        if (!(context.modal instanceof Modal)) {
            return /** @type {?} */ (Promise.reject(new Error('Configuration Error: modal service not set.')));
        }
        this.$$beforeOpen(context);
        let /** @type {?} */ overlayConfig = {
            context: context,
            renderer: new JSNativeModalRenderer(),
            viewContainer: viewContainer
        };
        return context.modal.open(context.component, overlayConfig);
    }
}
//# sourceMappingURL=js-native-preset.js.map
