import * as tslib_1 from "tslib";
/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
import { Modal } from '../modal';
import { JSNativeModalContextBuilder } from '../modal-context';
import { JSNativeModalRenderer } from '../js-native-modal-renderer';
var JSNativePresetBuilder = /** @class */ (function (_super) {
    tslib_1.__extends(JSNativePresetBuilder, _super);
    /**
     * @param {?} modal
     * @param {?} dialogType
     */
    function JSNativePresetBuilder(modal, dialogType) {
        return _super.call(this, /** @type {?} */ ({ modal: modal, dialogType: dialogType })) || this;
    }
    /**
     * Open a modal window based on the configuration of this config instance.
     * @param {?=} viewContainer If set opens the modal inside the supplied viewContainer
     * @return {?}
     */
    JSNativePresetBuilder.prototype.open = function (viewContainer) {
        var /** @type {?} */ context = this.toJSON();
        if (!(context.modal instanceof Modal)) {
            return /** @type {?} */ (Promise.reject(new Error('Configuration Error: modal service not set.')));
        }
        this.$$beforeOpen(context);
        var /** @type {?} */ overlayConfig = {
            context: context,
            renderer: new JSNativeModalRenderer(),
            viewContainer: viewContainer
        };
        return context.modal.open(context.component, overlayConfig);
    };
    return JSNativePresetBuilder;
}(JSNativeModalContextBuilder));
export { JSNativePresetBuilder };
//# sourceMappingURL=js-native-preset.js.map
