import { DROP_IN_TYPE, ModalOpenContextBuilder, ModalOpenContext, arrayUnion, Overlay, Modal } from 'ngx-modialog';
import { Injectable, NgModule } from '@angular/core';

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
const /** @type {?} */ DEFAULT_SETTERS = [
    'promptDefault'
];
class JSNativeModalContext extends ModalOpenContext {
    /**
     * @return {?}
     */
    normalize() {
        if (!this.message)
            this.message = '';
        if (this.dialogType === undefined)
            this.dialogType = DROP_IN_TYPE.alert;
    }
}
// unsupported: template constraints.
/**
 * @template T
 */
class JSNativeModalContextBuilder extends ModalOpenContextBuilder {
    /**
     * @param {?=} defaultValues
     * @param {?=} initialSetters
     * @param {?=} baseType
     */
    constructor(defaultValues = undefined, initialSetters = undefined, baseType = undefined) {
        super(defaultValues || /** @type {?} */ ({}), arrayUnion(DEFAULT_SETTERS, initialSetters || []), baseType || /** @type {?} */ (JSNativeModalContext));
    }
}

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
class JSNativeModalRenderer {
    /**
     * @param {?} dialog
     * @param {?} vcRef
     * @return {?}
     */
    render(dialog, vcRef) {
        let /** @type {?} */ result;
        switch (dialog.context.dialogType) {
            case DROP_IN_TYPE.alert:
                window.alert(dialog.context.message);
                result = true;
                break;
            case DROP_IN_TYPE.prompt:
                result = window.prompt(dialog.context.message, dialog.context.promptDefault);
                break;
            case DROP_IN_TYPE.confirm:
                result = window.confirm(dialog.context.message);
                break;
        }
        dialog.destroy = () => {
        };
        if (result === false) {
            dialog.dismiss();
        }
        else {
            dialog.close(result);
        }
        // we need to return ComponentRef<ModalOverlay> but a native dialog does'nt have that
        // so we resolve an empty promise, the user of this renderer should expect that.
        return /** @type {?} */ ({});
    }
}
JSNativeModalRenderer.decorators = [
    { type: Injectable },
];

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
class JSNativePresetBuilder extends JSNativeModalContextBuilder {
    /**
     * @param {?} modal
     * @param {?} dialogType
     */
    constructor(modal, dialogType) {
        super(/** @type {?} */ ({ modal, dialogType }));
    }
    /**
     * Open a modal window based on the configuration of this config instance.
     * @param {?=} viewContainer If set opens the modal inside the supplied viewContainer
     * @return {?}
     */
    open(viewContainer) {
        let /** @type {?} */ context = this.toJSON();
        if (!(context.modal instanceof Modal$1)) {
            return /** @type {?} */ (Promise.reject(new Error('Configuration Error: modal service not set.')));
        }
        this.$$beforeOpen(context);
        let /** @type {?} */ overlayConfig = {
            context: context,
            renderer: new JSNativeModalRenderer(),
            viewContainer: viewContainer
        };
        return context.modal.open(context.component, overlayConfig);
    }
}

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
class Modal$1 extends Modal {
    /**
     * @param {?} overlay
     */
    constructor(overlay) {
        super(overlay);
    }
    /**
     * @return {?}
     */
    alert() {
        return new JSNativePresetBuilder(this, DROP_IN_TYPE.alert);
    }
    /**
     * @return {?}
     */
    prompt() {
        return new JSNativePresetBuilder(this, DROP_IN_TYPE.prompt);
    }
    /**
     * @return {?}
     */
    confirm() {
        return new JSNativePresetBuilder(this, DROP_IN_TYPE.confirm);
    }
    /**
     * @param {?} dialogRef
     * @param {?} type
     * @return {?}
     */
    create(dialogRef, type) {
        return dialogRef;
    }
}
Modal$1.decorators = [
    { type: Injectable },
];
/** @nocollapse */
Modal$1.ctorParameters = () => [
    { type: Overlay, },
];

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
const /** @type {?} */ providers = [
    { provide: Modal, useClass: Modal$1 },
    { provide: Modal$1, useClass: Modal$1 }
];
class JSNativeModalModule {
    /**
     * @return {?}
     */
    static getProviders() {
        return providers;
    }
}
JSNativeModalModule.decorators = [
    { type: NgModule, args: [{
                providers
            },] },
];

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */

export { Modal$1 as Modal, JSNativeModalContext, JSNativeModalContextBuilder, JSNativeModalRenderer, JSNativePresetBuilder, JSNativeModalModule, providers };
//# sourceMappingURL=ngx-modialog-plugins-js-native.js.map
