/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
import { privateKey, extend, arrayUnion } from 'ngx-modialog';
import { VEXModalContext, VEXModalContextBuilder } from '../modal-context';
import { DialogFormModal as component } from '../dialog-form-modal';
const /** @type {?} */ DEFAULT_SETTERS = [
    'content'
];
/**
 * Data definition
 */
export class DialogPreset extends VEXModalContext {
}
function DialogPreset_tsickle_Closure_declarations() {
    /** @type {?} */
    DialogPreset.prototype.defaultResult;
    /** @type {?} */
    DialogPreset.prototype.content;
    /** @type {?} */
    DialogPreset.prototype.buttons;
    /** @type {?} */
    DialogPreset.prototype.showInput;
}
// unsupported: template constraints.
/**
 * A Preset representing the configuration needed to open MessageModal.
 * This is an abstract implementation with no concrete behaviour.
 * Use derived implementation.
 * @template T
 */
export class DialogPresetBuilder extends VEXModalContextBuilder {
    /**
     * @param {?} modal
     * @param {?=} defaultValues
     * @param {?=} initialSetters
     * @param {?=} baseType
     */
    constructor(modal, defaultValues = undefined, initialSetters = undefined, baseType = undefined) {
        super(extend({ modal, component, buttons: [], defaultResult: true }, defaultValues || {}), arrayUnion(DEFAULT_SETTERS, initialSetters || []), baseType || /** @type {?} */ (DialogPreset // https://github.com/Microsoft/TypeScript/issues/7234
        ) // https://github.com/Microsoft/TypeScript/issues/7234
        );
    }
    /**
     * @param {?} css
     * @param {?} caption
     * @param {?} onClick
     * @return {?}
     */
    addButton(css, caption, onClick) {
        let /** @type {?} */ btn = {
            cssClass: css,
            caption: caption,
            onClick: onClick
        };
        let /** @type {?} */ key = privateKey('buttons');
        (/** @type {?} */ (this[key])).push(btn);
        return this;
    }
    /**
     * @param {?=} text
     * @return {?}
     */
    addOkButton(text = 'OK') {
        this.addButton('vex-dialog-button-primary vex-dialog-button vex-first', text, (cmp, $event) => cmp.dialog.close(cmp.dialog.context.defaultResult));
        return this;
    }
    /**
     * @param {?=} text
     * @return {?}
     */
    addCancelButton(text = 'CANCEL') {
        this.addButton('vex-dialog-button-secondary vex-dialog-button vex-last', text, (cmp, $event) => cmp.dialog.dismiss());
        return this;
    }
}
function DialogPresetBuilder_tsickle_Closure_declarations() {
    /**
     * the message to display on the modal.
     * @type {?}
     */
    DialogPresetBuilder.prototype.content;
}
//# sourceMappingURL=dialog-preset.js.map
