/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
import { extend, arrayUnion } from './../framework/utils';
import { OverlayContext, OverlayContextBuilder } from './overlay-context';
export const /** @type {?} */ DEFAULT_VALUES = {};
const /** @type {?} */ DEFAULT_SETTERS = [
    'message'
];
export class ModalContext extends OverlayContext {
}
function ModalContext_tsickle_Closure_declarations() {
    /**
     * The core message to display.
     * A modal might have an extended message (e.g: HTML message) or other fields (e.g: title) but
     * all models, at core, convey a message thus message is common to all modals.
     * @type {?}
     */
    ModalContext.prototype.message;
}
// unsupported: template constraints.
/**
 * A core context builder for a modal window instance, used to define the context upon
 * a modal choose it's behaviour.
 * @template T
 */
export class ModalContextBuilder extends OverlayContextBuilder {
    /**
     * @param {?=} defaultValues
     * @param {?=} initialSetters
     * @param {?=} baseType
     */
    constructor(defaultValues = undefined, initialSetters = undefined, baseType = undefined) {
        super(extend(DEFAULT_VALUES, defaultValues || {}), arrayUnion(DEFAULT_SETTERS, initialSetters || []), baseType);
    }
}
function ModalContextBuilder_tsickle_Closure_declarations() {
    /**
     * The core message to display.
     * A modal might have an extended message (e.g: HTML message) or other fields (e.g: title) but
     * all models, at core, convey a message thus message is common to all modals.
     * @type {?}
     */
    ModalContextBuilder.prototype.message;
}
//# sourceMappingURL=modal-context.js.map
