/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
import { Modal } from '../providers/index';
import { ModalContext, ModalContextBuilder } from './modal-context';
import { arrayUnion } from '../framework/utils';
const /** @type {?} */ DEFAULT_SETTERS = [
    'component'
];
export class ModalOpenContext extends ModalContext {
}
function ModalOpenContext_tsickle_Closure_declarations() {
    /** @type {?} */
    ModalOpenContext.prototype.component;
    /** @type {?} */
    ModalOpenContext.prototype.modal;
}
// unsupported: template constraints.
/**
 * A Modal Context that knows about the modal service, and so can open a modal window on demand.
 * Use the fluent API to configure the preset and then invoke the 'open' method to open a modal
 * based on the context.
 * @abstract
 * @template T
 */
export class ModalOpenContextBuilder extends ModalContextBuilder {
    /**
     * @param {?=} defaultValues
     * @param {?=} initialSetters
     * @param {?=} baseType
     */
    constructor(defaultValues = undefined, initialSetters = undefined, baseType = undefined) {
        super(defaultValues || /** @type {?} */ ({}), arrayUnion(DEFAULT_SETTERS, initialSetters || []), baseType);
    }
    /**
     * Hook to alter config and return bindings.
     * @param {?} config
     * @return {?}
     */
    $$beforeOpen(config) { }
    /**
     * Open a modal window based on the configuration of this config instance.
     * @param {?=} viewContainer If set opens the modal inside the supplied viewContainer
     * @return {?}
     */
    open(viewContainer) {
        let /** @type {?} */ context = this.toJSON();
        if (!(context.modal instanceof Modal)) {
            return /** @type {?} */ (Promise.reject(new Error('Configuration Error: modal service not set.')));
        }
        this.$$beforeOpen(context);
        let /** @type {?} */ overlayConfig = {
            context: context,
            viewContainer: viewContainer
        };
        return context.modal.open(context.component, overlayConfig);
    }
}
function ModalOpenContextBuilder_tsickle_Closure_declarations() {
    /**
     * A Class for the footer container.
     * Default: modal-footer
     * @type {?}
     */
    ModalOpenContextBuilder.prototype.component;
}
//# sourceMappingURL=modal-open-context.js.map
