/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
const /** @type {?} */ vcRefCollection = {};
/**
 * @param {?} key
 * @return {?}
 */
function getVCRef(key) {
    return vcRefCollection[key] ? vcRefCollection[key].slice() : [];
}
/**
 * @param {?} key
 * @param {?} vcRef
 * @return {?}
 */
function setVCRef(key, vcRef) {
    if (!vcRefCollection.hasOwnProperty(key)) {
        vcRefCollection[key] = [];
    }
    vcRefCollection[key].push(vcRef);
}
/**
 * @param {?} key
 * @param {?=} vcRef
 * @return {?}
 */
function delVCRef(key, vcRef) {
    if (!vcRef) {
        vcRefCollection[key] = [];
    }
    else {
        const /** @type {?} */ coll = vcRefCollection[key] || [], /** @type {?} */
        idx = coll.indexOf(vcRef);
        if (idx > -1) {
            coll.splice(idx, 1);
        }
    }
}
/**
 * A Simple store that holds a reference to ViewContainerRef instances by a user defined key.
 * This, with the OverlayTarget directive makes it easy to block the overlay inside an element
 * without having to use the angular query boilerplate.
 */
export const /** @type {?} */ vcRefStore = { getVCRef, setVCRef, delVCRef };
//# sourceMappingURL=vc-ref-store.js.map
