/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
import { Directive, Input, ElementRef, ViewContainerRef } from '@angular/core';
import { DialogRef } from '../models/dialog-ref';
import { vcRefStore } from '../models/vc-ref-store';
/**
 * A directive use to signal the overlay that the host of this directive
 * is a dialog boundary, i.e: over click outside of the element should close the modal
 * (if non blocking)
 */
export class OverlayDialogBoundary {
    /**
     * @param {?} el
     * @param {?} dialogRef
     */
    constructor(el, dialogRef) {
        if (dialogRef && el.nativeElement) {
            dialogRef.overlayRef.instance.setClickBoundary(el.nativeElement);
        }
    }
}
OverlayDialogBoundary.decorators = [
    { type: Directive, args: [{
                selector: '[overlayDialogBoundary]'
            },] },
];
/** @nocollapse */
OverlayDialogBoundary.ctorParameters = () => [
    { type: ElementRef, },
    { type: DialogRef, },
];
function OverlayDialogBoundary_tsickle_Closure_declarations() {
    /** @type {!Array<{type: !Function, args: (undefined|!Array<?>)}>} */
    OverlayDialogBoundary.decorators;
    /**
     * @nocollapse
     * @type {function(): !Array<(null|{type: ?, decorators: (undefined|!Array<{type: !Function, args: (undefined|!Array<?>)}>)})>}
     */
    OverlayDialogBoundary.ctorParameters;
}
export class OverlayTarget {
    /**
     * @param {?} vcRef
     */
    constructor(vcRef) {
        this.vcRef = vcRef;
    }
    /**
     * @param {?} value
     * @return {?}
     */
    set targetKey(value) {
        this._targetKey = value;
        if (value) {
            vcRefStore.setVCRef(value, this.vcRef);
        }
    }
    /**
     * @return {?}
     */
    ngOnDestroy() {
        if (this._targetKey) {
            vcRefStore.delVCRef(this._targetKey, this.vcRef);
        }
    }
}
OverlayTarget.decorators = [
    { type: Directive, args: [{
                selector: '[overlayTarget]'
            },] },
];
/** @nocollapse */
OverlayTarget.ctorParameters = () => [
    { type: ViewContainerRef, },
];
OverlayTarget.propDecorators = {
    "targetKey": [{ type: Input, args: ['overlayTarget',] },],
};
function OverlayTarget_tsickle_Closure_declarations() {
    /** @type {!Array<{type: !Function, args: (undefined|!Array<?>)}>} */
    OverlayTarget.decorators;
    /**
     * @nocollapse
     * @type {function(): !Array<(null|{type: ?, decorators: (undefined|!Array<{type: !Function, args: (undefined|!Array<?>)}>)})>}
     */
    OverlayTarget.ctorParameters;
    /** @type {!Object<string,!Array<{type: !Function, args: (undefined|!Array<?>)}>>} */
    OverlayTarget.propDecorators;
    /** @type {?} */
    OverlayTarget.prototype._targetKey;
    /** @type {?} */
    OverlayTarget.prototype.vcRef;
}
//# sourceMappingURL=overlay.directives.js.map
