/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
import { Injectable, Injector } from '@angular/core';
import { OverlayRenderer } from '../models/tokens';
import { DialogRefStack } from '../models/dialog-ref-stack';
import { vcRefStore } from '../models/vc-ref-store';
import { DialogRef } from '../models/dialog-ref';
const /** @type {?} */ _stack = new DialogRefStack();
export class Overlay {
    /**
     * @param {?} _modalRenderer
     * @param {?} injector
     */
    constructor(_modalRenderer, injector) {
        this._modalRenderer = _modalRenderer;
        this.injector = injector;
    }
    /**
     * @return {?}
     */
    get stackLength() {
        return _stack.length;
    }
    /**
     * Check if a given DialogRef is the top most ref in the stack.
     * TODO: distinguish between body modal vs in element modal.
     * @param {?} dialogRef
     * @return {?}
     */
    isTopMost(dialogRef) {
        return _stack.indexOf(dialogRef) === _stack.length - 1;
    }
    /**
     * @param {?} dialogRef
     * @return {?}
     */
    stackPosition(dialogRef) {
        return _stack.indexOf(dialogRef);
    }
    /**
     * @param {?} dialogRef
     * @return {?}
     */
    groupStackLength(dialogRef) {
        return _stack.groupLength(_stack.groupOf(dialogRef));
    }
    /**
     * @param {?=} result
     * @return {?}
     */
    closeAll(result = null) {
        _stack.closeAll(result);
    }
    /**
     * Creates an overlay and returns a dialog ref.
     * @template T
     * @param {?} config instructions how to create the overlay
     * @param {?=} group A token to associate the new overlay with, used for reference (stacks usually)
     * @return {?}
     */
    open(config, group) {
        let /** @type {?} */ viewContainer = config.viewContainer, /** @type {?} */
        containers = [];
        if (typeof viewContainer === 'string') {
            containers = vcRefStore.getVCRef(/** @type {?} */ (viewContainer));
        }
        else if (Array.isArray(viewContainer)) {
            containers = /** @type {?} */ (viewContainer);
        }
        else if (viewContainer) {
            containers = /** @type {?} */ ([viewContainer]);
        }
        else {
            containers = [null];
        }
        return containers
            .map(vc => this.createOverlay(config.renderer || this._modalRenderer, vc, config, group));
    }
    /**
     * @param {?} renderer
     * @param {?} vcRef
     * @param {?} config
     * @param {?} group
     * @return {?}
     */
    createOverlay(renderer, vcRef, config, group) {
        if (config.context) {
            config.context.normalize();
        }
        if (!config.injector) {
            config.injector = this.injector;
        }
        let /** @type {?} */ dialog = new DialogRef(this, config.context || {});
        dialog.inElement = config.context && !!config.context.inElement;
        let /** @type {?} */ cmpRef = renderer.render(dialog, vcRef, config.injector);
        Object.defineProperty(dialog, 'overlayRef', { value: cmpRef });
        _stack.pushManaged(dialog, group);
        return dialog;
    }
}
Overlay.decorators = [
    { type: Injectable },
];
/** @nocollapse */
Overlay.ctorParameters = () => [
    { type: OverlayRenderer, },
    { type: Injector, },
];
function Overlay_tsickle_Closure_declarations() {
    /** @type {!Array<{type: !Function, args: (undefined|!Array<?>)}>} */
    Overlay.decorators;
    /**
     * @nocollapse
     * @type {function(): !Array<(null|{type: ?, decorators: (undefined|!Array<{type: !Function, args: (undefined|!Array<?>)}>)})>}
     */
    Overlay.ctorParameters;
    /** @type {?} */
    Overlay.prototype._modalRenderer;
    /** @type {?} */
    Overlay.prototype.injector;
}
//# sourceMappingURL=overlay.service.js.map
