/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
/**
 * @param {?} dropInName
 * @return {?}
 */
export function unsupportedDropInError(dropInName) {
    return new Error(`Unsupported Drop-In ${dropInName}`);
}
/**
 * @abstract
 */
export class Modal {
    /**
     * @param {?} overlay
     */
    constructor(overlay) {
        this.overlay = overlay;
    }
    /**
     * @return {?}
     */
    alert() {
        throw unsupportedDropInError('alert');
    }
    /**
     * @return {?}
     */
    prompt() {
        throw unsupportedDropInError('prompt');
    }
    /**
     * @return {?}
     */
    confirm() {
        throw unsupportedDropInError('confirm');
    }
    /**
     * Opens a modal window inside an existing component.
     * @param {?} content The content to display, either string, template ref or a component.
     * @param {?=} config Additional settings.
     * @return {?}
     */
    open(content, config) {
        config = config || /** @type {?} */ ({});
        let /** @type {?} */ dialogs = this.overlay.open(config, this.constructor);
        if (dialogs.length > 1) {
            console.warn(`Attempt to open more then 1 overlay detected.
      Multiple modal copies are not supported at the moment, 
      only the first viewContainer will display.`);
        }
        // TODO:  Currently supporting 1 view container, hence working on dialogs[0].
        //        upgrade to multiple containers.
        return this.create(dialogs[0], content);
    }
    /**
     * @template T
     * @param {?} dialogRef
     * @param {?} BackdropComponent
     * @return {?}
     */
    createBackdrop(dialogRef, BackdropComponent) {
        return dialogRef.overlayRef.instance.addComponent(BackdropComponent);
    }
    /**
     * @template T
     * @param {?} dialogRef
     * @param {?} ContainerComponent
     * @param {?} content
     * @return {?}
     */
    createContainer(dialogRef, ContainerComponent, content) {
        let /** @type {?} */ nodes = dialogRef.overlayRef.instance.getProjectables(content);
        return dialogRef.overlayRef.instance.addComponent(ContainerComponent, nodes);
    }
}
function Modal_tsickle_Closure_declarations() {
    /** @type {?} */
    Modal.prototype.overlay;
    /**
     * A Hook that enables derived classes to add content to the overlay.
     * @abstract
     * @param {?} dialogRef
     * @param {?} type
     * @return {?}
     */
    Modal.prototype.create = function (dialogRef, type) { };
}
//# sourceMappingURL=modal.js.map
