import * as tslib_1 from "tslib";
/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
import { extend, arrayUnion } from './../framework/utils';
import { OverlayContext, OverlayContextBuilder } from './overlay-context';
export var /** @type {?} */ DEFAULT_VALUES = {};
var /** @type {?} */ DEFAULT_SETTERS = [
    'message'
];
var ModalContext = /** @class */ (function (_super) {
    tslib_1.__extends(ModalContext, _super);
    function ModalContext() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    return ModalContext;
}(OverlayContext));
export { ModalContext };
function ModalContext_tsickle_Closure_declarations() {
    /**
     * The core message to display.
     * A modal might have an extended message (e.g: HTML message) or other fields (e.g: title) but
     * all models, at core, convey a message thus message is common to all modals.
     * @type {?}
     */
    ModalContext.prototype.message;
}
// unsupported: template constraints.
/**
 * A core context builder for a modal window instance, used to define the context upon
 * a modal choose it's behaviour.
 * @template T
 */
var ModalContextBuilder = /** @class */ (function (_super) {
    tslib_1.__extends(ModalContextBuilder, _super);
    /**
     * @param {?=} defaultValues
     * @param {?=} initialSetters
     * @param {?=} baseType
     */
    function ModalContextBuilder(defaultValues, initialSetters, baseType) {
        if (defaultValues === void 0) { defaultValues = undefined; }
        if (initialSetters === void 0) { initialSetters = undefined; }
        if (baseType === void 0) { baseType = undefined; }
        return _super.call(this, extend(DEFAULT_VALUES, defaultValues || {}), arrayUnion(DEFAULT_SETTERS, initialSetters || []), baseType) || this;
    }
    return ModalContextBuilder;
}(OverlayContextBuilder));
export { ModalContextBuilder };
function ModalContextBuilder_tsickle_Closure_declarations() {
    /**
     * The core message to display.
     * A modal might have an extended message (e.g: HTML message) or other fields (e.g: title) but
     * all models, at core, convey a message thus message is common to all modals.
     * @type {?}
     */
    ModalContextBuilder.prototype.message;
}
//# sourceMappingURL=modal-context.js.map
