/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
import { Directive, Input, ElementRef, ViewContainerRef } from '@angular/core';
import { DialogRef } from '../models/dialog-ref';
import { vcRefStore } from '../models/vc-ref-store';
/**
 * A directive use to signal the overlay that the host of this directive
 * is a dialog boundary, i.e: over click outside of the element should close the modal
 * (if non blocking)
 */
var OverlayDialogBoundary = /** @class */ (function () {
    /**
     * @param {?} el
     * @param {?} dialogRef
     */
    function OverlayDialogBoundary(el, dialogRef) {
        if (dialogRef && el.nativeElement) {
            dialogRef.overlayRef.instance.setClickBoundary(el.nativeElement);
        }
    }
    return OverlayDialogBoundary;
}());
export { OverlayDialogBoundary };
OverlayDialogBoundary.decorators = [
    { type: Directive, args: [{
                selector: '[overlayDialogBoundary]'
            },] },
];
/** @nocollapse */
OverlayDialogBoundary.ctorParameters = function () { return [
    { type: ElementRef, },
    { type: DialogRef, },
]; };
function OverlayDialogBoundary_tsickle_Closure_declarations() {
    /** @type {!Array<{type: !Function, args: (undefined|!Array<?>)}>} */
    OverlayDialogBoundary.decorators;
    /**
     * @nocollapse
     * @type {function(): !Array<(null|{type: ?, decorators: (undefined|!Array<{type: !Function, args: (undefined|!Array<?>)}>)})>}
     */
    OverlayDialogBoundary.ctorParameters;
}
var OverlayTarget = /** @class */ (function () {
    /**
     * @param {?} vcRef
     */
    function OverlayTarget(vcRef) {
        this.vcRef = vcRef;
    }
    Object.defineProperty(OverlayTarget.prototype, "targetKey", {
        /**
         * @param {?} value
         * @return {?}
         */
        set: function (value) {
            this._targetKey = value;
            if (value) {
                vcRefStore.setVCRef(value, this.vcRef);
            }
        },
        enumerable: true,
        configurable: true
    });
    /**
     * @return {?}
     */
    OverlayTarget.prototype.ngOnDestroy = function () {
        if (this._targetKey) {
            vcRefStore.delVCRef(this._targetKey, this.vcRef);
        }
    };
    return OverlayTarget;
}());
export { OverlayTarget };
OverlayTarget.decorators = [
    { type: Directive, args: [{
                selector: '[overlayTarget]'
            },] },
];
/** @nocollapse */
OverlayTarget.ctorParameters = function () { return [
    { type: ViewContainerRef, },
]; };
OverlayTarget.propDecorators = {
    "targetKey": [{ type: Input, args: ['overlayTarget',] },],
};
function OverlayTarget_tsickle_Closure_declarations() {
    /** @type {!Array<{type: !Function, args: (undefined|!Array<?>)}>} */
    OverlayTarget.decorators;
    /**
     * @nocollapse
     * @type {function(): !Array<(null|{type: ?, decorators: (undefined|!Array<{type: !Function, args: (undefined|!Array<?>)}>)})>}
     */
    OverlayTarget.ctorParameters;
    /** @type {!Object<string,!Array<{type: !Function, args: (undefined|!Array<?>)}>>} */
    OverlayTarget.propDecorators;
    /** @type {?} */
    OverlayTarget.prototype._targetKey;
    /** @type {?} */
    OverlayTarget.prototype.vcRef;
}
//# sourceMappingURL=overlay.directives.js.map
