/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
import { ModalOpenContext, ModalOpenContextBuilder, extend, arrayUnion } from 'ngx-modialog';
const /** @type {?} */ DEFAULT_VALUES = {
    dialogClass: 'modal-dialog',
    showClose: false
};
const /** @type {?} */ DEFAULT_SETTERS = [
    'dialogClass',
    'size',
    'showClose'
];
export class BSModalContext extends ModalOpenContext {
    /**
     * @return {?}
     */
    normalize() {
        if (!this.dialogClass) {
            this.dialogClass = DEFAULT_VALUES.dialogClass;
        }
        super.normalize();
    }
}
function BSModalContext_tsickle_Closure_declarations() {
    /**
     * A Class for the modal dialog container.
     * Default: modal-dialog
     * @type {?}
     */
    BSModalContext.prototype.dialogClass;
    /**
     * Size of the modal. 'lg' or 'sm' only.
     *
     * If you want to use custom sizes leave this empty and set the dialogClass property.
     * e.g: dialogClass = 'modal-dialog my-custom-dialog`
     * NOTE: No validation.
     * Default: ''
     * @type {?}
     */
    BSModalContext.prototype.size;
    /**
     * When true, show a close button on the top right corner.
     * @type {?}
     */
    BSModalContext.prototype.showClose;
}
// unsupported: template constraints.
/**
 * @template T
 */
export class BSModalContextBuilder extends ModalOpenContextBuilder {
    /**
     * @param {?=} defaultValues
     * @param {?=} initialSetters
     * @param {?=} baseType
     */
    constructor(defaultValues = undefined, initialSetters = undefined, baseType = undefined) {
        super(extend(DEFAULT_VALUES, defaultValues || {}), arrayUnion(DEFAULT_SETTERS, initialSetters || []), baseType || /** @type {?} */ (BSModalContext // https://github.com/Microsoft/TypeScript/issues/7234
        ) // https://github.com/Microsoft/TypeScript/issues/7234
        );
    }
}
function BSModalContextBuilder_tsickle_Closure_declarations() {
    /**
     * A Class for the modal dialog container.
     * Default: modal-dialog
     * @type {?}
     */
    BSModalContextBuilder.prototype.dialogClass;
    /**
     * Size of the modal. 'lg' or 'sm' only.
     *
     * If you want to use custom sizes leave this empty and set the dialogClass property.
     * e.g: dialogClass = 'modal-dialog my-custom-dialog`
     * NOTE: No validation.
     * Default: ''
     * @type {?}
     */
    BSModalContextBuilder.prototype.size;
    /**
     * When true, show a close button on the top right corner.
     * @type {?}
     */
    BSModalContextBuilder.prototype.showClose;
}
//# sourceMappingURL=modal-context.js.map
