/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
import { extend, arrayUnion } from 'ngx-modialog';
import { MessageModalPresetBuilder } from './message-modal-preset';
/**
 * @record
 */
export function TwoButtonPreset() { }
function TwoButtonPreset_tsickle_Closure_declarations() {
    /**
     * Caption for the Cancel button.
     * Default: Cancel
     * @type {?}
     */
    TwoButtonPreset.prototype.cancelBtn;
    /**
     * A Class for the Cancel button.
     * Default: btn btn-default
     * @type {?}
     */
    TwoButtonPreset.prototype.cancelBtnClass;
}
/**
 * Common two button preset
 * @abstract
 */
export class AbstractTwoButtonPresetBuilder extends MessageModalPresetBuilder {
    /**
     * @param {?} modal
     * @param {?=} defaultValues
     * @param {?=} initialSetters
     */
    constructor(modal, defaultValues = undefined, initialSetters = []) {
        super(extend({
            modal: modal,
            okBtn: 'OK',
            okBtnClass: 'btn btn-primary',
            cancelBtn: 'Cancel',
            cancelBtnClass: 'btn btn-default'
        }, defaultValues || {}), arrayUnion([
            'okBtn',
            'okBtnClass',
            'cancelBtn',
            'cancelBtnClass',
        ], initialSetters));
    }
    /**
     * @param {?} config
     * @return {?}
     */
    $$beforeOpen(config) {
        super.$$beforeOpen(config);
        this.addButton(config.cancelBtnClass, config.cancelBtn, (cmp, $event) => cmp.dialog.dismiss());
    }
}
function AbstractTwoButtonPresetBuilder_tsickle_Closure_declarations() {
    /** @type {?} */
    AbstractTwoButtonPresetBuilder.prototype.okBtn;
    /** @type {?} */
    AbstractTwoButtonPresetBuilder.prototype.okBtnClass;
    /** @type {?} */
    AbstractTwoButtonPresetBuilder.prototype.cancelBtn;
    /** @type {?} */
    AbstractTwoButtonPresetBuilder.prototype.cancelBtnClass;
}
/**
 * A Preset for a classic 2 button modal window.
 */
export class TwoButtonPresetBuilder extends AbstractTwoButtonPresetBuilder {
    /**
     * @param {?} modal
     * @param {?=} defaultValues
     */
    constructor(modal, defaultValues = undefined) {
        super(modal, defaultValues);
    }
    /**
     * @param {?} config
     * @return {?}
     */
    $$beforeOpen(config) {
        super.$$beforeOpen(config);
        this.addButton(config.okBtnClass, config.okBtn, (cmp, $event) => cmp.dialog.close(true));
    }
}
/**
 * @record
 */
export function PromptPreset() { }
function PromptPreset_tsickle_Closure_declarations() {
    /** @type {?} */
    PromptPreset.prototype.showInput;
    /**
     * Default value shown in the prompt.
     * @type {?}
     */
    PromptPreset.prototype.defaultValue;
    /**
     * A placeholder for the input element.
     * @type {?}
     */
    PromptPreset.prototype.placeholder;
}
export class PromptPresetBuilder extends AbstractTwoButtonPresetBuilder {
    /**
     * @param {?} modal
     * @param {?=} defaultValues
     */
    constructor(modal, defaultValues = undefined) {
        super(modal, extend({ showInput: true, defaultValue: '' }, defaultValues || {}), ['placeholder', 'defaultValue']);
    }
    /**
     * @param {?} config
     * @return {?}
     */
    $$beforeOpen(config) {
        super.$$beforeOpen(config);
        this.addButton(config.okBtnClass, config.okBtn, (cmp, $event) => cmp.dialog.close((/** @type {?} */ (cmp.dialog.context)).defaultValue));
    }
}
function PromptPresetBuilder_tsickle_Closure_declarations() {
    /** @type {?} */
    PromptPresetBuilder.prototype.placeholder;
    /** @type {?} */
    PromptPresetBuilder.prototype.defaultValue;
}
//# sourceMappingURL=two-button-preset.js.map
