import * as tslib_1 from "tslib";
/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
import { Component, ElementRef, ViewEncapsulation, Renderer2 } from '@angular/core';
import { BaseDynamicComponent, DialogRef } from 'ngx-modialog';
var BSModalContainer = /** @class */ (function (_super) {
    tslib_1.__extends(BSModalContainer, _super);
    /**
     * @param {?} dialog
     * @param {?} el
     * @param {?} renderer
     */
    function BSModalContainer(dialog, el, renderer) {
        var _this = _super.call(this, el, renderer) || this;
        _this.dialog = dialog;
        _this.activateAnimationListener();
        return _this;
    }
    return BSModalContainer;
}(BaseDynamicComponent));
export { BSModalContainer };
BSModalContainer.decorators = [
    { type: Component, args: [{
                selector: 'bs-modal-container',
                host: {
                    'tabindex': '-1',
                    'role': 'dialog',
                    'class': 'modal fade',
                    'style': 'position: absolute; display: block'
                },
                encapsulation: ViewEncapsulation.None,
                template: "<div [ngClass]=\"dialog.context.dialogClass\"\n      [class.modal-lg]=\"dialog.context.size == 'lg'\"\n      [class.modal-sm]=\"dialog.context.size == 'sm'\">\n  <div class=\"modal-content\" style=\"display:block\" role=\"document\" overlayDialogBoundary>\n    <ng-content></ng-content>\n  </div>\n</div>"
            },] },
];
/** @nocollapse */
BSModalContainer.ctorParameters = function () { return [
    { type: DialogRef, },
    { type: ElementRef, },
    { type: Renderer2, },
]; };
function BSModalContainer_tsickle_Closure_declarations() {
    /** @type {!Array<{type: !Function, args: (undefined|!Array<?>)}>} */
    BSModalContainer.decorators;
    /**
     * @nocollapse
     * @type {function(): !Array<(null|{type: ?, decorators: (undefined|!Array<{type: !Function, args: (undefined|!Array<?>)}>)})>}
     */
    BSModalContainer.ctorParameters;
    /** @type {?} */
    BSModalContainer.prototype.dialog;
}
//# sourceMappingURL=modal-container.component.js.map
