import { __extends } from 'tslib';
import { DROP_IN_TYPE, ModalOpenContextBuilder, ModalOpenContext, arrayUnion, Overlay, Modal } from 'ngx-modialog';
import { Injectable, NgModule } from '@angular/core';

var /** @type {?} */ DEFAULT_SETTERS = [
    'promptDefault'
];
var JSNativeModalContext = /** @class */ (function (_super) {
    __extends(JSNativeModalContext, _super);
    function JSNativeModalContext() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * @return {?}
     */
    JSNativeModalContext.prototype.normalize = function () {
        if (!this.message)
            this.message = '';
        if (this.dialogType === undefined)
            this.dialogType = DROP_IN_TYPE.alert;
    };
    return JSNativeModalContext;
}(ModalOpenContext));
// unsupported: template constraints.
/**
 * @template T
 */
var JSNativeModalContextBuilder = /** @class */ (function (_super) {
    __extends(JSNativeModalContextBuilder, _super);
    /**
     * @param {?=} defaultValues
     * @param {?=} initialSetters
     * @param {?=} baseType
     */
    function JSNativeModalContextBuilder(defaultValues, initialSetters, baseType) {
        if (defaultValues === void 0) { defaultValues = undefined; }
        if (initialSetters === void 0) { initialSetters = undefined; }
        if (baseType === void 0) { baseType = undefined; }
        return _super.call(this, defaultValues || /** @type {?} */ ({}), arrayUnion(DEFAULT_SETTERS, initialSetters || []), baseType || /** @type {?} */ (JSNativeModalContext)) || this;
    }
    return JSNativeModalContextBuilder;
}(ModalOpenContextBuilder));

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
var JSNativeModalRenderer = /** @class */ (function () {
    function JSNativeModalRenderer() {
    }
    /**
     * @param {?} dialog
     * @param {?} vcRef
     * @return {?}
     */
    JSNativeModalRenderer.prototype.render = function (dialog, vcRef) {
        var /** @type {?} */ result;
        switch (dialog.context.dialogType) {
            case DROP_IN_TYPE.alert:
                window.alert(dialog.context.message);
                result = true;
                break;
            case DROP_IN_TYPE.prompt:
                result = window.prompt(dialog.context.message, dialog.context.promptDefault);
                break;
            case DROP_IN_TYPE.confirm:
                result = window.confirm(dialog.context.message);
                break;
        }
        dialog.destroy = function () {
        };
        if (result === false) {
            dialog.dismiss();
        }
        else {
            dialog.close(result);
        }
        // we need to return ComponentRef<ModalOverlay> but a native dialog does'nt have that
        // so we resolve an empty promise, the user of this renderer should expect that.
        return /** @type {?} */ ({});
    };
    return JSNativeModalRenderer;
}());
JSNativeModalRenderer.decorators = [
    { type: Injectable },
];

var JSNativePresetBuilder = /** @class */ (function (_super) {
    __extends(JSNativePresetBuilder, _super);
    /**
     * @param {?} modal
     * @param {?} dialogType
     */
    function JSNativePresetBuilder(modal, dialogType) {
        return _super.call(this, /** @type {?} */ ({ modal: modal, dialogType: dialogType })) || this;
    }
    /**
     * Open a modal window based on the configuration of this config instance.
     * @param {?=} viewContainer If set opens the modal inside the supplied viewContainer
     * @return {?}
     */
    JSNativePresetBuilder.prototype.open = function (viewContainer) {
        var /** @type {?} */ context = this.toJSON();
        if (!(context.modal instanceof Modal$1)) {
            return /** @type {?} */ (Promise.reject(new Error('Configuration Error: modal service not set.')));
        }
        this.$$beforeOpen(context);
        var /** @type {?} */ overlayConfig = {
            context: context,
            renderer: new JSNativeModalRenderer(),
            viewContainer: viewContainer
        };
        return context.modal.open(context.component, overlayConfig);
    };
    return JSNativePresetBuilder;
}(JSNativeModalContextBuilder));

var Modal$1 = /** @class */ (function (_super) {
    __extends(Modal$$1, _super);
    /**
     * @param {?} overlay
     */
    function Modal$$1(overlay) {
        return _super.call(this, overlay) || this;
    }
    /**
     * @return {?}
     */
    Modal$$1.prototype.alert = function () {
        return new JSNativePresetBuilder(this, DROP_IN_TYPE.alert);
    };
    /**
     * @return {?}
     */
    Modal$$1.prototype.prompt = function () {
        return new JSNativePresetBuilder(this, DROP_IN_TYPE.prompt);
    };
    /**
     * @return {?}
     */
    Modal$$1.prototype.confirm = function () {
        return new JSNativePresetBuilder(this, DROP_IN_TYPE.confirm);
    };
    /**
     * @param {?} dialogRef
     * @param {?} type
     * @return {?}
     */
    Modal$$1.prototype.create = function (dialogRef, type) {
        return dialogRef;
    };
    return Modal$$1;
}(Modal));
Modal$1.decorators = [
    { type: Injectable },
];
/** @nocollapse */
Modal$1.ctorParameters = function () { return [
    { type: Overlay, },
]; };

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
var /** @type {?} */ providers = [
    { provide: Modal, useClass: Modal$1 },
    { provide: Modal$1, useClass: Modal$1 }
];
var JSNativeModalModule = /** @class */ (function () {
    function JSNativeModalModule() {
    }
    /**
     * @return {?}
     */
    JSNativeModalModule.getProviders = function () {
        return providers;
    };
    return JSNativeModalModule;
}());
JSNativeModalModule.decorators = [
    { type: NgModule, args: [{
                providers: providers
            },] },
];

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */

export { Modal$1 as Modal, JSNativeModalContext, JSNativeModalContextBuilder, JSNativeModalRenderer, JSNativePresetBuilder, JSNativeModalModule, providers };
//# sourceMappingURL=ngx-modialog-plugins-js-native.js.map
