(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('@angular/core'), require('ngx-modialog'), require('tslib'), require('rxjs'), require('@angular/common')) :
    typeof define === 'function' && define.amd ? define('ngxModialog.plugins.vex', ['exports', '@angular/core', 'ngx-modialog', 'tslib', 'rxjs', '@angular/common'], factory) :
    (factory((global.ngxModialog = global.ngxModialog || {}, global.ngxModialog.plugins = global.ngxModialog.plugins || {}, global.ngxModialog.plugins.vex = {}),global.ng.core,global.ngxModialog,global.tslib,global.rxjs,global.ng.common));
}(this, (function (exports,core,ngxModialog,tslib,rxjs,common) { 'use strict';

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    /**
     * A Dialog is a
     */
    var VEXDialogButtons = (function () {
        function VEXDialogButtons() {
            /**
             * Emitted when a button was clicked
             */
            this.onButtonClick = new core.EventEmitter();
        }
        /**
         * @param {?} btn
         * @param {?} $event
         * @return {?}
         */
        VEXDialogButtons.prototype.onClick = function (btn, $event) {
            $event.stopPropagation();
            this.onButtonClick.emit({ btn: btn, $event: $event });
        };
        return VEXDialogButtons;
    }());
    VEXDialogButtons.decorators = [
        { type: core.Component, args: [{
                    selector: 'vex-dialog-buttons',
                    encapsulation: core.ViewEncapsulation.None,
                    template: "<div class=\"vex-dialog-buttons\">\n    <button type=\"button\" \n         *ngFor=\"let btn of buttons;\"\n         [class]=\"btn.cssClass\"\n         (click)=\"onClick(btn, $event)\">{{btn.caption}}</button>\n</div>"
                },] },
    ];
    /** @nocollapse */
    VEXDialogButtons.propDecorators = {
        "buttons": [{ type: core.Input },],
        "onButtonClick": [{ type: core.Output },],
    };
    /**
     * A Dialog with customized buttons wrapped in a form.
     *
     */
    var DialogFormModal = (function () {
        /**
         * @param {?} dialog
         */
        function DialogFormModal(dialog) {
            this.dialog = dialog;
            this.context = dialog.context;
        }
        /**
         * @param {?} $event
         * @return {?}
         */
        DialogFormModal.prototype.onButtonClick = function ($event) {
            $event.btn.onClick(this, $event.$event);
        };
        return DialogFormModal;
    }());
    DialogFormModal.decorators = [
        { type: core.Component, args: [{
                    selector: 'modal-dialog',
                    encapsulation: core.ViewEncapsulation.None,
                    template: "<form class=\"vex-dialog-form\">\n    <ng-container *ngComponentOutlet=\"context.content\"></ng-container>\n    <vex-dialog-buttons [buttons]=\"context.buttons\"\n                        (onButtonClick)=\"onButtonClick($event)\"></vex-dialog-buttons>\n</form>"
                },] },
    ];
    /** @nocollapse */
    DialogFormModal.ctorParameters = function () {
        return [
            { type: ngxModialog.DialogRef, },
        ];
    };
    var FormDropIn = (function () {
        /**
         * @param {?} dialog
         */
        function FormDropIn(dialog) {
            this.dialog = dialog;
            this.context = dialog.context;
        }
        return FormDropIn;
    }());
    FormDropIn.decorators = [
        { type: core.Component, args: [{
                    selector: 'drop-in-dialog',
                    encapsulation: core.ViewEncapsulation.None,
                    template: "<div class=\"vex-dialog-message\">{{context.message}}</div>\n <div *ngIf=\"context.showInput\" class=\"vex-dialog-input\">\n   <input #input\n          autofocus\n          name=\"vex\" \n          type=\"text\" \n          class=\"vex-dialog-prompt-input\"\n           (change)=\"context.defaultResult = input.value\" \n          placeholder=\"{{context.placeholder}}\">\n </div>\n <div *ngIf=\"context.showCloseButton\" \n      [class]=\"context.closeClassName\"\n      (click)=\"dialog.dismiss()\"></div>"
                },] },
    ];
    /** @nocollapse */
    FormDropIn.ctorParameters = function () {
        return [
            { type: ngxModialog.DialogRef, },
        ];
    };
    var /** @type {?} */ DEFAULT_VALUES = {
        className: /** @type {?} */ ('default'),
        overlayClassName: 'vex-overlay',
        contentClassName: 'vex-content',
        closeClassName: 'vex-close'
    };
    var /** @type {?} */ DEFAULT_SETTERS = [
        'className',
        'overlayClassName',
        'contentClassName',
        'closeClassName',
        'showCloseButton'
    ];
    var VEXModalContext = (function (_super) {
        tslib.__extends(VEXModalContext, _super);
        function VEXModalContext() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        /**
         * @return {?}
         */
        VEXModalContext.prototype.normalize = function () {
            if (!this.className) {
                this.className = DEFAULT_VALUES.className;
            }
            if (!this.overlayClassName) {
                this.overlayClassName = DEFAULT_VALUES.overlayClassName;
            }
            if (!this.contentClassName) {
                this.contentClassName = DEFAULT_VALUES.contentClassName;
            }
            if (!this.closeClassName) {
                this.closeClassName = DEFAULT_VALUES.closeClassName;
            }
            _super.prototype.normalize.call(this);
        };
        return VEXModalContext;
    }(ngxModialog.ModalOpenContext));
    // unsupported: template constraints.
    /**
     * @template T
     */
    var VEXModalContextBuilder = (function (_super) {
        tslib.__extends(VEXModalContextBuilder, _super);
        /**
         * @param {?=} defaultValues
         * @param {?=} initialSetters
         * @param {?=} baseType
         */
        function VEXModalContextBuilder(defaultValues, initialSetters, baseType) {
            if (defaultValues === void 0) {
                defaultValues = undefined;
            }
            if (initialSetters === void 0) {
                initialSetters = undefined;
            }
            if (baseType === void 0) {
                baseType = undefined;
            }
            return _super.call(this, ngxModialog.extend(DEFAULT_VALUES, defaultValues || {}), ngxModialog.arrayUnion(DEFAULT_SETTERS, initialSetters || []), baseType || /** @type {?} */ (VEXModalContext // https://github.com/Microsoft/TypeScript/issues/7234
            ) // https://github.com/Microsoft/TypeScript/issues/7234
            ) || this;
        }
        /**
         *
         * \@aliasFor isBlocking
         * @param {?} value
         * @return {?}
         */
        VEXModalContextBuilder.prototype.overlayClosesOnClick = function (value) {
            this[ngxModialog.privateKey('isBlocking')] = !value;
            return this;
        };
        return VEXModalContextBuilder;
    }(ngxModialog.ModalOpenContextBuilder));
    var /** @type {?} */ DEFAULT_SETTERS$1 = [
        'content'
    ];
    /**
     * Data definition
     */
    var DialogPreset = (function (_super) {
        tslib.__extends(DialogPreset, _super);
        function DialogPreset() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return DialogPreset;
    }(VEXModalContext));
    // unsupported: template constraints.
    /**
     * A Preset representing the configuration needed to open MessageModal.
     * This is an abstract implementation with no concrete behaviour.
     * Use derived implementation.
     * @template T
     */
    var DialogPresetBuilder = (function (_super) {
        tslib.__extends(DialogPresetBuilder, _super);
        /**
         * @param {?} modal
         * @param {?=} defaultValues
         * @param {?=} initialSetters
         * @param {?=} baseType
         */
        function DialogPresetBuilder(modal, defaultValues, initialSetters, baseType) {
            if (defaultValues === void 0) {
                defaultValues = undefined;
            }
            if (initialSetters === void 0) {
                initialSetters = undefined;
            }
            if (baseType === void 0) {
                baseType = undefined;
            }
            return _super.call(this, ngxModialog.extend({ modal: modal, component: DialogFormModal, buttons: [], defaultResult: true }, defaultValues || {}), ngxModialog.arrayUnion(DEFAULT_SETTERS$1, initialSetters || []), baseType || /** @type {?} */ (DialogPreset // https://github.com/Microsoft/TypeScript/issues/7234
            ) // https://github.com/Microsoft/TypeScript/issues/7234
            ) || this;
        }
        /**
         * @param {?} css
         * @param {?} caption
         * @param {?} onClick
         * @return {?}
         */
        DialogPresetBuilder.prototype.addButton = function (css, caption, onClick) {
            var /** @type {?} */ btn = {
                cssClass: css,
                caption: caption,
                onClick: onClick
            };
            var /** @type {?} */ key = ngxModialog.privateKey('buttons');
            ((this[key])).push(btn);
            return this;
        };
        /**
         * @param {?=} text
         * @return {?}
         */
        DialogPresetBuilder.prototype.addOkButton = function (text) {
            if (text === void 0) {
                text = 'OK';
            }
            this.addButton('vex-dialog-button-primary vex-dialog-button vex-first', text, function (cmp, $event) { return cmp.dialog.close(cmp.dialog.context.defaultResult); });
            return this;
        };
        /**
         * @param {?=} text
         * @return {?}
         */
        DialogPresetBuilder.prototype.addCancelButton = function (text) {
            if (text === void 0) {
                text = 'CANCEL';
            }
            this.addButton('vex-dialog-button-secondary vex-dialog-button vex-last', text, function (cmp, $event) { return cmp.dialog.dismiss(); });
            return this;
        };
        return DialogPresetBuilder;
    }(VEXModalContextBuilder));
    var /** @type {?} */ DEFAULT_VALUES$1 = {
        component: DialogFormModal,
        content: FormDropIn,
        okBtn: 'OK',
        cancelBtn: 'Cancel'
    };
    var /** @type {?} */ DEFAULT_SETTERS$2 = [
        'okBtn',
        'cancelBtn',
        'placeholder'
    ];
    /**
     * Data definition
     */
    var DropInPreset = (function (_super) {
        tslib.__extends(DropInPreset, _super);
        function DropInPreset() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(DropInPreset.prototype, "showInput", {
            /**
             * @return {?}
             */
            get: function () {
                return this.dropInType === ngxModialog.DROP_IN_TYPE.prompt;
            },
            enumerable: true,
            configurable: true
        });
        return DropInPreset;
    }(DialogPreset));
    /**
     * A Preset representing all 3 drop ins (alert, prompt, confirm)
     */
    var DropInPresetBuilder = (function (_super) {
        tslib.__extends(DropInPresetBuilder, _super);
        /**
         * @param {?} modal
         * @param {?} dropInType
         * @param {?=} defaultValues
         */
        function DropInPresetBuilder(modal, dropInType, defaultValues) {
            if (defaultValues === void 0) {
                defaultValues = undefined;
            }
            return _super.call(this, modal, ngxModialog.extend(ngxModialog.extend({ modal: modal, dropInType: dropInType }, DEFAULT_VALUES$1), defaultValues || {}), DEFAULT_SETTERS$2, DropInPreset) || this;
        }
        /**
         * @param {?} config
         * @return {?}
         */
        DropInPresetBuilder.prototype.$$beforeOpen = function (config) {
            _super.prototype.$$beforeOpen.call(this, config);
            if (config.okBtn) {
                this.addOkButton(config.okBtn);
            }
            switch (config.dropInType) {
                case ngxModialog.DROP_IN_TYPE.prompt:
                    config.defaultResult = undefined;
                    break;
                case ngxModialog.DROP_IN_TYPE.confirm:
                    if (config.cancelBtn) {
                        this.addCancelButton(config.cancelBtn);
                    }
                    break;
            }
        };
        return DropInPresetBuilder;
    }(DialogPresetBuilder));
    /**
     * A component that acts as a top level container for an open modal window.
     */
    var VexCSSDialogContainer = (function (_super) {
        tslib.__extends(VexCSSDialogContainer, _super);
        function VexCSSDialogContainer() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        /**
         * @param {?} overlay
         * @return {?}
         */
        VexCSSDialogContainer.prototype.apply = function (overlay) {
            overlay.setClickBoundary(this.vexContentContainer.nativeElement);
            if (this.dialog.inElement) {
                this.setStyle('padding', '20px 0 0 0');
                if (this.dialog.context.className === 'bottom-right-corner') {
                    this.setStyle('overflow-y', 'hidden');
                    this.renderer.setStyle(this.vexContentContainer.nativeElement, 'position', 'absolute');
                }
            }
        };
        return VexCSSDialogContainer;
    }(ngxModialog.CSSDialogContainer));
    VexCSSDialogContainer.decorators = [
        { type: core.Component, args: [{
                    selector: 'css-dialog-container',
                    host: {
                        'tabindex': '-1',
                        'role': 'dialog'
                    },
                    encapsulation: core.ViewEncapsulation.None,
                    template: "<div #clickBoundary class=\"{{dialog.context.contentClassName}}\"><ng-content></ng-content></div>"
                },] },
    ];
    /** @nocollapse */
    VexCSSDialogContainer.propDecorators = {
        "vexContentContainer": [{ type: core.ViewChild, args: ['clickBoundary', { read: core.ElementRef },] },],
    };
    // TODO: use DI factory for this.
    // TODO: consolidate dup code
    var /** @type {?} */ isDoc = !(typeof document === 'undefined' || !document);
    var /** @type {?} */ vexV3 = false;
    /**
     * Execute this method to flag that you are working with VEX version 3.
     * @return {?}
     */
    function vexV3Mode() {
        vexV3 = true;
    }
    var Modal$1 = (function (_super) {
        tslib.__extends(Modal$$1, _super);
        /**
         * @param {?} overlay
         */
        function Modal$$1(overlay) {
            return _super.call(this, overlay) || this;
        }
        /**
         * @return {?}
         */
        Modal$$1.prototype.alert = function () {
            return new DropInPresetBuilder(this, ngxModialog.DROP_IN_TYPE.alert, /** @type {?} */ ({ isBlocking: false }));
        };
        /**
         * @return {?}
         */
        Modal$$1.prototype.prompt = function () {
            return new DropInPresetBuilder(this, ngxModialog.DROP_IN_TYPE.prompt, /** @type {?} */ ({
                isBlocking: true,
                keyboard: null
            }));
        };
        /**
         * @return {?}
         */
        Modal$$1.prototype.confirm = function () {
            return new DropInPresetBuilder(this, ngxModialog.DROP_IN_TYPE.confirm, /** @type {?} */ ({
                isBlocking: true,
                keyboard: null
            }));
        };
        /**
         * @param {?} dialogRef
         * @param {?} content
         * @return {?}
         */
        Modal$$1.prototype.create = function (dialogRef, content) {
            var _this = this;
            if (vexV3 === true) {
                return this.createV3(dialogRef, content);
            }
            var /** @type {?} */ backdropRef = this.createBackdrop(dialogRef, ngxModialog.CSSBackdrop);
            var /** @type {?} */ containerRef = this.createContainer(dialogRef, VexCSSDialogContainer, content);
            var /** @type {?} */ overlay = dialogRef.overlayRef.instance;
            var /** @type {?} */ backdrop = backdropRef.instance;
            var /** @type {?} */ container = containerRef.instance;
            if (dialogRef.inElement) {
                overlay.insideElement();
                overlay.setContainerStyle('position', 'relative')
                    .setContainerStyle('height', '100%')
                    .setContainerStyle('width', '100%');
                backdrop.setStyle('position', 'absolute')
                    .setStyle('display', 'block')
                    .setStyle('height', '100%')
                    .setStyle('width', '100%');
                container.setStyle('position', 'relative')
                    .setStyle('display', 'block')
                    .setStyle('height', '100%')
                    .setStyle('width', '100%');
            }
            else {
                overlay.fullscreen();
            }
            // add body class if this is the only dialog in the stack
            if (isDoc && !document.body.classList.contains('vex-open')) {
                document.body.classList.add('vex-open');
            }
            backdrop.addClass('vex-overlay');
            container.addClass("vex vex-theme-" + dialogRef.context.className);
            container.setStyle('display', 'block');
            if (containerRef.location.nativeElement) {
                containerRef.location.nativeElement.focus();
            }
            overlay.beforeDestroy(function () {
                backdrop.addClass('vex-closing');
                container.addClass('vex-closing');
                var /** @type {?} */ completer = new ngxModialog.PromiseCompleter();
                var /** @type {?} */ animationEnd$ = backdrop.myAnimationEnd$();
                // TODO: the child element inside the container (vex-content) is the one with animation
                // need to also wait for it to end, but this requires a reference to to it.
                // the container itself is its parent, won't do.
                // animationEnd$ = combineLatest.call(animationEnd$, container.myAnimationEnd$(), (s1, s2) => [s1,s2] );
                animationEnd$.subscribe(function (sources) {
                    isDoc && _this.overlay.groupStackLength(dialogRef) === 1 && document.body.classList.remove('vex-open');
                    completer.resolve();
                });
                return completer.promise;
            });
            container.apply(overlay);
            return dialogRef;
        };
        /**
         * @param {?} dialogRef
         * @param {?} content
         * @return {?}
         */
        Modal$$1.prototype.createV3 = function (dialogRef, content) {
            var _this = this;
            var /** @type {?} */ backdropRef = this.createBackdrop(dialogRef, ngxModialog.CSSBackdrop);
            var /** @type {?} */ containerRef = this.createContainer(dialogRef, ngxModialog.CSSDialogContainer, content);
            var /** @type {?} */ overlay = dialogRef.overlayRef.instance;
            var /** @type {?} */ backdrop = backdropRef.instance;
            var /** @type {?} */ container = containerRef.instance;
            dialogRef.inElement ? overlay.insideElement() : overlay.fullscreen();
            // add body class if this is the only dialog in the stack
            if (isDoc && !document.body.classList.contains('vex-open')) {
                document.body.classList.add('vex-open');
            }
            overlay.addClass("vex vex-theme-" + dialogRef.context.className);
            backdrop.addClass('vex-overlay');
            container.addClass(dialogRef.context.contentClassName);
            container.setStyle('display', 'block');
            if (dialogRef.inElement) {
                overlay.setStyle('padding', '0');
                container.setStyle('margin-top', '20px');
            }
            if (containerRef.location.nativeElement) {
                containerRef.location.nativeElement.focus();
            }
            if (dialogRef.context.className === 'bottom-right-corner') {
                overlay.setStyle('overflow-y', 'hidden');
                container.setStyle('position', 'absolute');
            }
            overlay.beforeDestroy(function () {
                overlay.addClass('vex-closing');
                var /** @type {?} */ completer = new ngxModialog.PromiseCompleter();
                var /** @type {?} */ animationEnd$ = container.myAnimationEnd$();
                if (dialogRef.context.className !== 'bottom-right-corner') {
                    animationEnd$ = rxjs.combineLatest.call(animationEnd$, backdrop.myAnimationEnd$(), function (s1, s2) { return [s1, s2]; });
                }
                animationEnd$.subscribe(function (sources) {
                    isDoc && _this.overlay.groupStackLength(dialogRef) === 1 && document.body.classList.remove('vex-open');
                    completer.resolve();
                });
                return completer.promise;
            });
            overlay.setClickBoundary(containerRef.location.nativeElement);
            return dialogRef;
        };
        return Modal$$1;
    }(ngxModialog.Modal));
    Modal$1.decorators = [
        { type: core.Injectable },
    ];
    /** @nocollapse */
    Modal$1.ctorParameters = function () {
        return [
            { type: ngxModialog.Overlay, },
        ];
    };
    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var /** @type {?} */ providers = [
        { provide: ngxModialog.Modal, useClass: Modal$1 },
        { provide: Modal$1, useClass: Modal$1 }
    ];
    var VexModalModule = (function () {
        function VexModalModule() {
        }
        /**
         * @return {?}
         */
        VexModalModule.getProviders = function () {
            return providers;
        };
        return VexModalModule;
    }());
    VexModalModule.decorators = [
        { type: core.NgModule, args: [{
                    imports: [ngxModialog.ModalModule, common.CommonModule],
                    declarations: [
                        VexCSSDialogContainer,
                        VEXDialogButtons,
                        FormDropIn,
                        DialogFormModal
                    ],
                    providers: providers,
                    entryComponents: [
                        VexCSSDialogContainer,
                        DialogFormModal,
                        FormDropIn
                    ]
                },] },
    ];

    exports.Modal = Modal$1;
    exports.vexV3Mode = vexV3Mode;
    exports.VEXModalContext = VEXModalContext;
    exports.VEXModalContextBuilder = VEXModalContextBuilder;
    exports.DropInPreset = DropInPreset;
    exports.DropInPresetBuilder = DropInPresetBuilder;
    exports.DialogFormModal = DialogFormModal;
    exports.FormDropIn = FormDropIn;
    exports.VEXDialogButtons = VEXDialogButtons;
    exports.DialogPreset = DialogPreset;
    exports.DialogPresetBuilder = DialogPresetBuilder;
    exports.VexModalModule = VexModalModule;
    exports.providers = providers;
    exports.ɵa = VexCSSDialogContainer;

    Object.defineProperty(exports, '__esModule', { value: true });

})));
//# sourceMappingURL=ngx-modialog-plugins-vex.umd.js.map
