/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
import { Component, ViewEncapsulation, Input, Output, EventEmitter } from '@angular/core';
import { DialogRef } from 'ngx-modialog';
/**
 * @record
 */
export function VEXButtonHandler() { }
function VEXButtonHandler_tsickle_Closure_declarations() {
    /* TODO: handle strange member:
    (cmp: ModalComponent<DialogPreset>, $event: MouseEvent): void;
    */
}
/**
 * Interface for button definition
 * @record
 */
export function VEXButtonConfig() { }
function VEXButtonConfig_tsickle_Closure_declarations() {
    /** @type {?} */
    VEXButtonConfig.prototype.cssClass;
    /** @type {?} */
    VEXButtonConfig.prototype.caption;
    /** @type {?} */
    VEXButtonConfig.prototype.onClick;
}
/**
 * @record
 */
export function VEXButtonClickEvent() { }
function VEXButtonClickEvent_tsickle_Closure_declarations() {
    /** @type {?} */
    VEXButtonClickEvent.prototype.btn;
    /** @type {?} */
    VEXButtonClickEvent.prototype.$event;
}
/**
 * A Dialog is a
 */
export class VEXDialogButtons {
    constructor() {
        /**
         * Emitted when a button was clicked
         */
        this.onButtonClick = new EventEmitter();
    }
    /**
     * @param {?} btn
     * @param {?} $event
     * @return {?}
     */
    onClick(btn, $event) {
        $event.stopPropagation();
        this.onButtonClick.emit({ btn, $event });
    }
}
VEXDialogButtons.decorators = [
    { type: Component, args: [{
                selector: 'vex-dialog-buttons',
                encapsulation: ViewEncapsulation.None,
                template: `<div class="vex-dialog-buttons">
    <button type="button" 
         *ngFor="let btn of buttons;"
         [class]="btn.cssClass"
         (click)="onClick(btn, $event)">{{btn.caption}}</button>
</div>`
            },] },
];
/** @nocollapse */
VEXDialogButtons.propDecorators = {
    "buttons": [{ type: Input },],
    "onButtonClick": [{ type: Output },],
};
function VEXDialogButtons_tsickle_Closure_declarations() {
    /** @type {!Array<{type: !Function, args: (undefined|!Array<?>)}>} */
    VEXDialogButtons.decorators;
    /**
     * @nocollapse
     * @type {function(): !Array<(null|{type: ?, decorators: (undefined|!Array<{type: !Function, args: (undefined|!Array<?>)}>)})>}
     */
    VEXDialogButtons.ctorParameters;
    /** @type {!Object<string,!Array<{type: !Function, args: (undefined|!Array<?>)}>>} */
    VEXDialogButtons.propDecorators;
    /**
     * A collection of button configurations, each configuration is a button to display.
     * @type {?}
     */
    VEXDialogButtons.prototype.buttons;
    /**
     * Emitted when a button was clicked
     * @type {?}
     */
    VEXDialogButtons.prototype.onButtonClick;
}
/**
 * A Dialog with customized buttons wrapped in a form.
 *
 */
export class DialogFormModal {
    /**
     * @param {?} dialog
     */
    constructor(dialog) {
        this.dialog = dialog;
        this.context = dialog.context;
    }
    /**
     * @param {?} $event
     * @return {?}
     */
    onButtonClick($event) {
        $event.btn.onClick(this, $event.$event);
    }
}
DialogFormModal.decorators = [
    { type: Component, args: [{
                selector: 'modal-dialog',
                encapsulation: ViewEncapsulation.None,
                template: `<form class="vex-dialog-form">
    <ng-container *ngComponentOutlet="context.content"></ng-container>
    <vex-dialog-buttons [buttons]="context.buttons"
                        (onButtonClick)="onButtonClick($event)"></vex-dialog-buttons>
</form>`
            },] },
];
/** @nocollapse */
DialogFormModal.ctorParameters = () => [
    { type: DialogRef, },
];
function DialogFormModal_tsickle_Closure_declarations() {
    /** @type {!Array<{type: !Function, args: (undefined|!Array<?>)}>} */
    DialogFormModal.decorators;
    /**
     * @nocollapse
     * @type {function(): !Array<(null|{type: ?, decorators: (undefined|!Array<{type: !Function, args: (undefined|!Array<?>)}>)})>}
     */
    DialogFormModal.ctorParameters;
    /** @type {?} */
    DialogFormModal.prototype.context;
    /** @type {?} */
    DialogFormModal.prototype.dialog;
}
export class FormDropIn {
    /**
     * @param {?} dialog
     */
    constructor(dialog) {
        this.dialog = dialog;
        this.context = dialog.context;
    }
}
FormDropIn.decorators = [
    { type: Component, args: [{
                selector: 'drop-in-dialog',
                encapsulation: ViewEncapsulation.None,
                template: `<div class="vex-dialog-message">{{context.message}}</div>
 <div *ngIf="context.showInput" class="vex-dialog-input">
   <input #input
          autofocus
          name="vex" 
          type="text" 
          class="vex-dialog-prompt-input"
           (change)="context.defaultResult = input.value" 
          placeholder="{{context.placeholder}}">
 </div>
 <div *ngIf="context.showCloseButton" 
      [class]="context.closeClassName"
      (click)="dialog.dismiss()"></div>`
            },] },
];
/** @nocollapse */
FormDropIn.ctorParameters = () => [
    { type: DialogRef, },
];
function FormDropIn_tsickle_Closure_declarations() {
    /** @type {!Array<{type: !Function, args: (undefined|!Array<?>)}>} */
    FormDropIn.decorators;
    /**
     * @nocollapse
     * @type {function(): !Array<(null|{type: ?, decorators: (undefined|!Array<{type: !Function, args: (undefined|!Array<?>)}>)})>}
     */
    FormDropIn.ctorParameters;
    /** @type {?} */
    FormDropIn.prototype.context;
    /** @type {?} */
    FormDropIn.prototype.dialog;
}
//# sourceMappingURL=dialog-form-modal.js.map
