/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
import { ModalOpenContext, ModalOpenContextBuilder, privateKey, extend, arrayUnion } from 'ngx-modialog';
const /** @type {?} */ DEFAULT_VALUES = {
    className: /** @type {?} */ ('default'),
    overlayClassName: 'vex-overlay',
    contentClassName: 'vex-content',
    closeClassName: 'vex-close'
};
const /** @type {?} */ DEFAULT_SETTERS = [
    'className',
    'overlayClassName',
    'contentClassName',
    'closeClassName',
    'showCloseButton'
];
export class VEXModalContext extends ModalOpenContext {
    /**
     * @return {?}
     */
    normalize() {
        if (!this.className) {
            this.className = DEFAULT_VALUES.className;
        }
        if (!this.overlayClassName) {
            this.overlayClassName = DEFAULT_VALUES.overlayClassName;
        }
        if (!this.contentClassName) {
            this.contentClassName = DEFAULT_VALUES.contentClassName;
        }
        if (!this.closeClassName) {
            this.closeClassName = DEFAULT_VALUES.closeClassName;
        }
        super.normalize();
    }
}
function VEXModalContext_tsickle_Closure_declarations() {
    /**
     * Set the built in schema to use.
     * @type {?}
     */
    VEXModalContext.prototype.className;
    /** @type {?} */
    VEXModalContext.prototype.overlayClassName;
    /** @type {?} */
    VEXModalContext.prototype.contentClassName;
    /** @type {?} */
    VEXModalContext.prototype.closeClassName;
    /** @type {?} */
    VEXModalContext.prototype.showCloseButton;
}
// unsupported: template constraints.
/**
 * @template T
 */
export class VEXModalContextBuilder extends ModalOpenContextBuilder {
    /**
     * @param {?=} defaultValues
     * @param {?=} initialSetters
     * @param {?=} baseType
     */
    constructor(defaultValues = undefined, initialSetters = undefined, baseType = undefined) {
        super(extend(DEFAULT_VALUES, defaultValues || {}), arrayUnion(DEFAULT_SETTERS, initialSetters || []), baseType || /** @type {?} */ (VEXModalContext // https://github.com/Microsoft/TypeScript/issues/7234
        ) // https://github.com/Microsoft/TypeScript/issues/7234
        );
    }
    /**
     *
     * \@aliasFor isBlocking
     * @param {?} value
     * @return {?}
     */
    overlayClosesOnClick(value) {
        this[privateKey('isBlocking')] = !value;
        return this;
    }
}
function VEXModalContextBuilder_tsickle_Closure_declarations() {
    /**
     * Set the built in schema to use.
     * @type {?}
     */
    VEXModalContextBuilder.prototype.className;
    /** @type {?} */
    VEXModalContextBuilder.prototype.overlayClassName;
    /** @type {?} */
    VEXModalContextBuilder.prototype.contentClassName;
    /** @type {?} */
    VEXModalContextBuilder.prototype.closeClassName;
    /** @type {?} */
    VEXModalContextBuilder.prototype.showCloseButton;
}
//# sourceMappingURL=modal-context.js.map
