/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
import { combineLatest } from 'rxjs';
import { Injectable } from '@angular/core';
import { Overlay, DROP_IN_TYPE, Modal as Modal_, CSSBackdrop, CSSDialogContainer, PromiseCompleter } from 'ngx-modialog';
import { DropInPresetBuilder } from './presets/dropin-preset';
import { VexCSSDialogContainer } from './vex-css-dialog-container';
// TODO: use DI factory for this.
// TODO: consolidate dup code
const /** @type {?} */ isDoc = !(typeof document === 'undefined' || !document);
let /** @type {?} */ vexV3 = false;
/**
 * Execute this method to flag that you are working with VEX version 3.
 * @return {?}
 */
export function vexV3Mode() {
    vexV3 = true;
}
export class Modal extends Modal_ {
    /**
     * @param {?} overlay
     */
    constructor(overlay) {
        super(overlay);
    }
    /**
     * @return {?}
     */
    alert() {
        return new DropInPresetBuilder(this, DROP_IN_TYPE.alert, /** @type {?} */ ({ isBlocking: false }));
    }
    /**
     * @return {?}
     */
    prompt() {
        return new DropInPresetBuilder(this, DROP_IN_TYPE.prompt, /** @type {?} */ ({
            isBlocking: true,
            keyboard: null
        }));
    }
    /**
     * @return {?}
     */
    confirm() {
        return new DropInPresetBuilder(this, DROP_IN_TYPE.confirm, /** @type {?} */ ({
            isBlocking: true,
            keyboard: null
        }));
    }
    /**
     * @param {?} dialogRef
     * @param {?} content
     * @return {?}
     */
    create(dialogRef, content) {
        if (vexV3 === true) {
            return this.createV3(dialogRef, content);
        }
        const /** @type {?} */ backdropRef = this.createBackdrop(dialogRef, CSSBackdrop);
        const /** @type {?} */ containerRef = this.createContainer(dialogRef, VexCSSDialogContainer, content);
        let /** @type {?} */ overlay = dialogRef.overlayRef.instance;
        let /** @type {?} */ backdrop = backdropRef.instance;
        let /** @type {?} */ container = containerRef.instance;
        if (dialogRef.inElement) {
            overlay.insideElement();
            overlay.setContainerStyle('position', 'relative')
                .setContainerStyle('height', '100%')
                .setContainerStyle('width', '100%');
            backdrop.setStyle('position', 'absolute')
                .setStyle('display', 'block')
                .setStyle('height', '100%')
                .setStyle('width', '100%');
            container.setStyle('position', 'relative')
                .setStyle('display', 'block')
                .setStyle('height', '100%')
                .setStyle('width', '100%');
        }
        else {
            overlay.fullscreen();
        }
        // add body class if this is the only dialog in the stack
        if (isDoc && !document.body.classList.contains('vex-open')) {
            document.body.classList.add('vex-open');
        }
        backdrop.addClass('vex-overlay');
        container.addClass(`vex vex-theme-${dialogRef.context.className}`);
        container.setStyle('display', 'block');
        if (containerRef.location.nativeElement) {
            containerRef.location.nativeElement.focus();
        }
        overlay.beforeDestroy(() => {
            backdrop.addClass('vex-closing');
            container.addClass('vex-closing');
            const /** @type {?} */ completer = new PromiseCompleter();
            let /** @type {?} */ animationEnd$ = backdrop.myAnimationEnd$();
            // TODO: the child element inside the container (vex-content) is the one with animation
            // need to also wait for it to end, but this requires a reference to to it.
            // the container itself is its parent, won't do.
            // animationEnd$ = combineLatest.call(animationEnd$, container.myAnimationEnd$(), (s1, s2) => [s1,s2] );
            animationEnd$.subscribe(sources => {
                isDoc && this.overlay.groupStackLength(dialogRef) === 1 && document.body.classList.remove('vex-open');
                completer.resolve();
            });
            return completer.promise;
        });
        container.apply(overlay);
        return dialogRef;
    }
    /**
     * @param {?} dialogRef
     * @param {?} content
     * @return {?}
     */
    createV3(dialogRef, content) {
        const /** @type {?} */ backdropRef = this.createBackdrop(dialogRef, CSSBackdrop);
        const /** @type {?} */ containerRef = this.createContainer(dialogRef, CSSDialogContainer, content);
        let /** @type {?} */ overlay = dialogRef.overlayRef.instance;
        let /** @type {?} */ backdrop = backdropRef.instance;
        let /** @type {?} */ container = containerRef.instance;
        dialogRef.inElement ? overlay.insideElement() : overlay.fullscreen();
        // add body class if this is the only dialog in the stack
        if (isDoc && !document.body.classList.contains('vex-open')) {
            document.body.classList.add('vex-open');
        }
        overlay.addClass(`vex vex-theme-${dialogRef.context.className}`);
        backdrop.addClass('vex-overlay');
        container.addClass(dialogRef.context.contentClassName);
        container.setStyle('display', 'block');
        if (dialogRef.inElement) {
            overlay.setStyle('padding', '0');
            container.setStyle('margin-top', '20px');
        }
        if (containerRef.location.nativeElement) {
            containerRef.location.nativeElement.focus();
        }
        if (dialogRef.context.className === 'bottom-right-corner') {
            overlay.setStyle('overflow-y', 'hidden');
            container.setStyle('position', 'absolute');
        }
        overlay.beforeDestroy(() => {
            overlay.addClass('vex-closing');
            const /** @type {?} */ completer = new PromiseCompleter();
            let /** @type {?} */ animationEnd$ = container.myAnimationEnd$();
            if (dialogRef.context.className !== 'bottom-right-corner') {
                animationEnd$ = combineLatest.call(animationEnd$, backdrop.myAnimationEnd$(), (s1, s2) => [s1, s2]);
            }
            animationEnd$.subscribe(sources => {
                isDoc && this.overlay.groupStackLength(dialogRef) === 1 && document.body.classList.remove('vex-open');
                completer.resolve();
            });
            return completer.promise;
        });
        overlay.setClickBoundary(containerRef.location.nativeElement);
        return dialogRef;
    }
}
Modal.decorators = [
    { type: Injectable },
];
/** @nocollapse */
Modal.ctorParameters = () => [
    { type: Overlay, },
];
function Modal_tsickle_Closure_declarations() {
    /** @type {!Array<{type: !Function, args: (undefined|!Array<?>)}>} */
    Modal.decorators;
    /**
     * @nocollapse
     * @type {function(): !Array<(null|{type: ?, decorators: (undefined|!Array<{type: !Function, args: (undefined|!Array<?>)}>)})>}
     */
    Modal.ctorParameters;
}
//# sourceMappingURL=modal.js.map
