/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
import { DROP_IN_TYPE, extend } from 'ngx-modialog';
import { DialogFormModal as component, FormDropIn as content } from '../dialog-form-modal';
import { DialogPreset, DialogPresetBuilder } from './dialog-preset';
const /** @type {?} */ DEFAULT_VALUES = {
    component,
    content,
    okBtn: 'OK',
    cancelBtn: 'Cancel'
};
const /** @type {?} */ DEFAULT_SETTERS = [
    'okBtn',
    'cancelBtn',
    'placeholder'
];
/**
 * Data definition
 */
export class DropInPreset extends DialogPreset {
    /**
     * @return {?}
     */
    get showInput() {
        return this.dropInType === DROP_IN_TYPE.prompt;
    }
}
function DropInPreset_tsickle_Closure_declarations() {
    /**
     * the message to display on the modal.
     * @type {?}
     */
    DropInPreset.prototype.message;
    /**
     * OK button caption.
     * Default: OK
     * Set to false ('', undefined, null, false) to remove button.
     * @type {?}
     */
    DropInPreset.prototype.okBtn;
    /**
     * Cancel button caption.
     * Default: Cancel
     * Set to false ('', undefined, null, false) to remove button.
     * @type {?}
     */
    DropInPreset.prototype.cancelBtn;
    /**
     * A placeholder for the input element.
     * Valid only for prompt modal.
     * @type {?}
     */
    DropInPreset.prototype.placeholder;
    /** @type {?} */
    DropInPreset.prototype.dropInType;
}
/**
 * A Preset representing all 3 drop ins (alert, prompt, confirm)
 */
export class DropInPresetBuilder extends DialogPresetBuilder {
    /**
     * @param {?} modal
     * @param {?} dropInType
     * @param {?=} defaultValues
     */
    constructor(modal, dropInType, defaultValues = undefined) {
        super(modal, extend(extend({ modal, dropInType }, DEFAULT_VALUES), defaultValues || {}), DEFAULT_SETTERS, DropInPreset);
    }
    /**
     * @param {?} config
     * @return {?}
     */
    $$beforeOpen(config) {
        super.$$beforeOpen(config);
        if (config.okBtn) {
            this.addOkButton(config.okBtn);
        }
        switch (config.dropInType) {
            case DROP_IN_TYPE.prompt:
                config.defaultResult = undefined;
                break;
            case DROP_IN_TYPE.confirm:
                if (config.cancelBtn) {
                    this.addCancelButton(config.cancelBtn);
                }
                break;
        }
    }
}
function DropInPresetBuilder_tsickle_Closure_declarations() {
    /**
     * the message to display on the modal.
     * @type {?}
     */
    DropInPresetBuilder.prototype.message;
    /**
     * The default Ok button caption.
     * @type {?}
     */
    DropInPresetBuilder.prototype.okBtn;
    /**
     * The default Cancel button caption.
     * @type {?}
     */
    DropInPresetBuilder.prototype.cancelBtn;
    /**
     * A placeholder for the input element.
     * Valid only for prompt modal.
     * @type {?}
     */
    DropInPresetBuilder.prototype.placeholder;
}
//# sourceMappingURL=dropin-preset.js.map
