import * as tslib_1 from "tslib";
/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
import { Component, ElementRef, ViewChild, ViewEncapsulation } from '@angular/core';
import { CSSDialogContainer } from 'ngx-modialog';
/**
 * A component that acts as a top level container for an open modal window.
 */
var VexCSSDialogContainer = /** @class */ (function (_super) {
    tslib_1.__extends(VexCSSDialogContainer, _super);
    function VexCSSDialogContainer() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * @param {?} overlay
     * @return {?}
     */
    VexCSSDialogContainer.prototype.apply = function (overlay) {
        overlay.setClickBoundary(this.vexContentContainer.nativeElement);
        if (this.dialog.inElement) {
            this.setStyle('padding', '20px 0 0 0');
            if (this.dialog.context.className === 'bottom-right-corner') {
                this.setStyle('overflow-y', 'hidden');
                this.renderer.setStyle(this.vexContentContainer.nativeElement, 'position', 'absolute');
            }
        }
    };
    return VexCSSDialogContainer;
}(CSSDialogContainer));
export { VexCSSDialogContainer };
VexCSSDialogContainer.decorators = [
    { type: Component, args: [{
                selector: 'css-dialog-container',
                host: {
                    'tabindex': '-1',
                    'role': 'dialog'
                },
                encapsulation: ViewEncapsulation.None,
                template: "<div #clickBoundary class=\"{{dialog.context.contentClassName}}\"><ng-content></ng-content></div>"
            },] },
];
/** @nocollapse */
VexCSSDialogContainer.propDecorators = {
    "vexContentContainer": [{ type: ViewChild, args: ['clickBoundary', { read: ElementRef },] },],
};
function VexCSSDialogContainer_tsickle_Closure_declarations() {
    /** @type {!Array<{type: !Function, args: (undefined|!Array<?>)}>} */
    VexCSSDialogContainer.decorators;
    /**
     * @nocollapse
     * @type {function(): !Array<(null|{type: ?, decorators: (undefined|!Array<{type: !Function, args: (undefined|!Array<?>)}>)})>}
     */
    VexCSSDialogContainer.ctorParameters;
    /** @type {!Object<string,!Array<{type: !Function, args: (undefined|!Array<?>)}>>} */
    VexCSSDialogContainer.propDecorators;
    /**
     * The div that wraps the content of the modal, by default use the class `vex-content`
     * @type {?}
     */
    VexCSSDialogContainer.prototype.vexContentContainer;
}
//# sourceMappingURL=vex-css-dialog-container.js.map
