(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('@angular/core'), require('diff-match-patch'), require('rxjs'), require('@angular/cdk/scrolling'), require('@angular/common'), require('@angular/forms')) :
    typeof define === 'function' && define.amd ? define('ngx-text-diff', ['exports', '@angular/core', 'diff-match-patch', 'rxjs', '@angular/cdk/scrolling', '@angular/common', '@angular/forms'], factory) :
    (global = global || self, factory(global['ngx-text-diff'] = {}, global.ng.core, global.diffMatchPatch, global.rxjs, global.ng.cdk.scrolling, global.ng.common, global.ng.forms));
}(this, (function (exports, core, diffMatchPatch, rxjs, scrolling, common, forms) { 'use strict';

    /*! *****************************************************************************
    Copyright (c) Microsoft Corporation. All rights reserved.
    Licensed under the Apache License, Version 2.0 (the "License"); you may not use
    this file except in compliance with the License. You may obtain a copy of the
    License at http://www.apache.org/licenses/LICENSE-2.0

    THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED
    WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
    MERCHANTABLITY OR NON-INFRINGEMENT.

    See the Apache Version 2.0 License for specific language governing permissions
    and limitations under the License.
    ***************************************************************************** */
    /* global Reflect, Promise */

    var extendStatics = function(d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };

    function __extends(d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    }

    var __assign = function() {
        __assign = Object.assign || function __assign(t) {
            for (var s, i = 1, n = arguments.length; i < n; i++) {
                s = arguments[i];
                for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
            }
            return t;
        };
        return __assign.apply(this, arguments);
    };

    function __rest(s, e) {
        var t = {};
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
            t[p] = s[p];
        if (s != null && typeof Object.getOwnPropertySymbols === "function")
            for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
                if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                    t[p[i]] = s[p[i]];
            }
        return t;
    }

    function __decorate(decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
        else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return c > 3 && r && Object.defineProperty(target, key, r), r;
    }

    function __param(paramIndex, decorator) {
        return function (target, key) { decorator(target, key, paramIndex); }
    }

    function __metadata(metadataKey, metadataValue) {
        if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(metadataKey, metadataValue);
    }

    function __awaiter(thisArg, _arguments, P, generator) {
        function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
        return new (P || (P = Promise))(function (resolve, reject) {
            function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
            function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
            function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
            step((generator = generator.apply(thisArg, _arguments || [])).next());
        });
    }

    function __generator(thisArg, body) {
        var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
        return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
        function verb(n) { return function (v) { return step([n, v]); }; }
        function step(op) {
            if (f) throw new TypeError("Generator is already executing.");
            while (_) try {
                if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
                if (y = 0, t) op = [op[0] & 2, t.value];
                switch (op[0]) {
                    case 0: case 1: t = op; break;
                    case 4: _.label++; return { value: op[1], done: false };
                    case 5: _.label++; y = op[1]; op = [0]; continue;
                    case 7: op = _.ops.pop(); _.trys.pop(); continue;
                    default:
                        if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                        if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                        if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                        if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                        if (t[2]) _.ops.pop();
                        _.trys.pop(); continue;
                }
                op = body.call(thisArg, _);
            } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
            if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
        }
    }

    function __exportStar(m, exports) {
        for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
    }

    function __values(o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m) return m.call(o);
        if (o && typeof o.length === "number") return {
            next: function () {
                if (o && i >= o.length) o = void 0;
                return { value: o && o[i++], done: !o };
            }
        };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    }

    function __read(o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m) return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
        }
        catch (error) { e = { error: error }; }
        finally {
            try {
                if (r && !r.done && (m = i["return"])) m.call(i);
            }
            finally { if (e) throw e.error; }
        }
        return ar;
    }

    function __spread() {
        for (var ar = [], i = 0; i < arguments.length; i++)
            ar = ar.concat(__read(arguments[i]));
        return ar;
    }

    function __spreadArrays() {
        for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
        for (var r = Array(s), k = 0, i = 0; i < il; i++)
            for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
                r[k] = a[j];
        return r;
    };

    function __await(v) {
        return this instanceof __await ? (this.v = v, this) : new __await(v);
    }

    function __asyncGenerator(thisArg, _arguments, generator) {
        if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
        var g = generator.apply(thisArg, _arguments || []), i, q = [];
        return i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i;
        function verb(n) { if (g[n]) i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; }
        function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(q[0][3], e); } }
        function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
        function fulfill(value) { resume("next", value); }
        function reject(value) { resume("throw", value); }
        function settle(f, v) { if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]); }
    }

    function __asyncDelegator(o) {
        var i, p;
        return i = {}, verb("next"), verb("throw", function (e) { throw e; }), verb("return"), i[Symbol.iterator] = function () { return this; }, i;
        function verb(n, f) { i[n] = o[n] ? function (v) { return (p = !p) ? { value: __await(o[n](v)), done: n === "return" } : f ? f(v) : v; } : f; }
    }

    function __asyncValues(o) {
        if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
        var m = o[Symbol.asyncIterator], i;
        return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
        function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
        function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
    }

    function __makeTemplateObject(cooked, raw) {
        if (Object.defineProperty) { Object.defineProperty(cooked, "raw", { value: raw }); } else { cooked.raw = raw; }
        return cooked;
    };

    function __importStar(mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
        result.default = mod;
        return result;
    }

    function __importDefault(mod) {
        return (mod && mod.__esModule) ? mod : { default: mod };
    }

    function __classPrivateFieldGet(receiver, privateMap) {
        if (!privateMap.has(receiver)) {
            throw new TypeError("attempted to get private field on non-instance");
        }
        return privateMap.get(receiver);
    }

    function __classPrivateFieldSet(receiver, privateMap, value) {
        if (!privateMap.has(receiver)) {
            throw new TypeError("attempted to set private field on non-instance");
        }
        privateMap.set(receiver, value);
        return value;
    }

    var isNil = function (val) { return val === undefined || val === null; };
    var isEmpty = function (val) { return val == null || !(Object.keys(val) || val).length || (Object.keys(val) || val).length === 0; };

    var NgxTextDiffService = /** @class */ (function () {
        function NgxTextDiffService() {
            this.initParser();
        }
        NgxTextDiffService.prototype.initParser = function () {
            this.diffParser = new diffMatchPatch.diff_match_patch();
        };
        NgxTextDiffService.prototype.getDiffsByLines = function (left, right) {
            var _this = this;
            return new Promise(function (resolve, reject) {
                var a = _this.diffParser.diff_linesToChars_(left, right);
                var lineText1 = a.chars1;
                var lineText2 = a.chars2;
                var linesArray = a.lineArray;
                var diffs = _this.diffParser.diff_main(lineText1, lineText2, true);
                _this.diffParser.diff_charsToLines_(diffs, linesArray);
                var rows = _this.formatOutput(diffs);
                if (!rows) {
                    reject('Error');
                }
                resolve(rows);
            });
        };
        NgxTextDiffService.prototype.formatOutput = function (diffs) {
            var _this = this;
            var lineLeft = 1;
            var lineRight = 1;
            return diffs.reduce(function (rows, diff) {
                if (!rows) {
                    rows = [];
                }
                var diffType = diff[0];
                var diffValue = diff[1];
                var leftDiffRow = null;
                var rightDiffRow = null;
                var leftContent = null;
                var rightContent = null;
                var rowTemp = null;
                switch (diffType) {
                    case diffMatchPatch.DIFF_EQUAL: // 0
                        diffValue
                            .split('\n')
                            .filter(function (value, index, array) {
                            if (index === array.length - 1) {
                                return !isEmpty(value);
                            }
                            return true;
                        })
                            .forEach(function (line) {
                            leftContent = {
                                lineNumber: lineLeft,
                                lineContent: line,
                                lineDiffs: [],
                                prefix: ''
                            };
                            rightContent = {
                                lineNumber: lineRight,
                                lineContent: line,
                                lineDiffs: [],
                                prefix: ''
                            };
                            rowTemp = {
                                leftContent: leftContent,
                                rightContent: rightContent,
                                belongTo: 'both',
                                hasDiffs: false,
                                numDiffs: 0,
                            };
                            rows.push(rowTemp);
                            lineRight = lineRight + 1;
                            lineLeft = lineLeft + 1;
                        });
                        break;
                    case diffMatchPatch.DIFF_DELETE: // -1
                        diffValue
                            .split('\n')
                            .filter(function (value, index, array) {
                            if (index === array.length - 1) {
                                return !isEmpty(value);
                            }
                            return true;
                        })
                            .forEach(function (line) {
                            rightDiffRow = rows.find(function (row) { return !row.leftContent && row.rightContent && row.rightContent.lineNumber === lineLeft && row.rightContent.prefix !== ''; });
                            leftContent = {
                                lineNumber: lineLeft,
                                lineContent: line,
                                lineDiffs: [{ content: line, isDiff: true }],
                                prefix: '-'
                            };
                            if (rightDiffRow) {
                                rightDiffRow.leftContent = leftContent;
                                rightDiffRow.leftContent.lineDiffs = _this.getDiffParts(rightDiffRow.leftContent.lineContent, rightDiffRow.rightContent.lineContent);
                                rightDiffRow.rightContent.lineDiffs = _this.getDiffParts(rightDiffRow.rightContent.lineContent, rightDiffRow.leftContent.lineContent);
                                rightDiffRow.belongTo = 'both';
                                rightDiffRow.numDiffs = _this.countDiffs(rightDiffRow);
                            }
                            else {
                                rows.push({
                                    leftContent: leftContent,
                                    rightContent: null,
                                    hasDiffs: true,
                                    belongTo: 'left',
                                    numDiffs: 1,
                                });
                            }
                            lineLeft = lineLeft + 1;
                        });
                        break;
                    case diffMatchPatch.DIFF_INSERT: // 1
                        diffValue
                            .split('\n')
                            .filter(function (value, index, array) {
                            if (index === array.length - 1) {
                                return !isEmpty(value);
                            }
                            return true;
                        })
                            .forEach(function (line) {
                            leftDiffRow = rows.find(function (row) { return row.leftContent && !row.rightContent && row.leftContent.lineNumber === lineRight && row.leftContent.prefix !== ''; });
                            rightContent = {
                                lineNumber: lineRight,
                                lineContent: line,
                                lineDiffs: [{ content: line, isDiff: true }],
                                prefix: '+'
                            };
                            if (leftDiffRow) {
                                leftDiffRow.rightContent = rightContent;
                                leftDiffRow.leftContent.lineDiffs = _this.getDiffParts(leftDiffRow.leftContent.lineContent, leftDiffRow.rightContent.lineContent);
                                leftDiffRow.rightContent.lineDiffs = _this.getDiffParts(leftDiffRow.rightContent.lineContent, leftDiffRow.leftContent.lineContent);
                                leftDiffRow.belongTo = 'both';
                                leftDiffRow.numDiffs = _this.countDiffs(leftDiffRow);
                            }
                            else {
                                rows.push({
                                    leftContent: null,
                                    rightContent: rightContent,
                                    hasDiffs: true,
                                    belongTo: 'right',
                                    numDiffs: 1,
                                });
                            }
                            lineRight = lineRight + 1;
                        });
                        break;
                }
                return rows;
            }, []);
        };
        NgxTextDiffService.prototype.countDiffs = function (result) {
            var diffCount = 0;
            if (result.leftContent) {
                diffCount += result.leftContent.lineDiffs.filter(function (diff) { return diff.isDiff; }).length;
            }
            if (result.leftContent) {
                diffCount += result.rightContent.lineDiffs.filter(function (diff) { return diff.isDiff; }).length;
            }
            return diffCount;
        };
        NgxTextDiffService.prototype.getDiffParts = function (value, compareValue) {
            var diffParts = [];
            var i = 0;
            var j = 0;
            var shared = '';
            var diff = '';
            while (i < value.length) {
                if (value[i] === compareValue[j] && j < compareValue.length) {
                    if (diff !== '') {
                        diffParts.push({ content: diff, isDiff: true });
                        diff = '';
                    }
                    shared += value[i];
                }
                else {
                    if (shared !== '') {
                        diffParts.push({ content: shared, isDiff: false });
                        shared = '';
                    }
                    diff += value[i];
                }
                i++;
                j++;
            }
            if (diff !== '') {
                diffParts.push({ content: diff, isDiff: true });
            }
            else if (shared !== '') {
                diffParts.push({ content: shared, isDiff: false });
            }
            return diffParts;
        };
        NgxTextDiffService.ɵprov = core["ɵɵdefineInjectable"]({ factory: function NgxTextDiffService_Factory() { return new NgxTextDiffService(); }, token: NgxTextDiffService, providedIn: "root" });
        NgxTextDiffService = __decorate([
            core.Injectable({
                providedIn: 'root'
            }),
            __metadata("design:paramtypes", [])
        ], NgxTextDiffService);
        return NgxTextDiffService;
    }());

    var ContainerDirective = /** @class */ (function () {
        function ContainerDirective(_el) {
            this._el = _el;
            this.element = _el.nativeElement;
        }
        ContainerDirective.ctorParameters = function () { return [
            { type: core.ElementRef }
        ]; };
        __decorate([
            core.Input(),
            __metadata("design:type", String)
        ], ContainerDirective.prototype, "id", void 0);
        ContainerDirective = __decorate([
            core.Directive({
                selector: '[tdContainer]',
            }),
            __metadata("design:paramtypes", [core.ElementRef])
        ], ContainerDirective);
        return ContainerDirective;
    }());

    var NgxTextDiffComponent = /** @class */ (function () {
        function NgxTextDiffComponent(scrollService, diff, cd) {
            this.scrollService = scrollService;
            this.diff = diff;
            this.cd = cd;
            this._hideMatchingLines = false;
            this.format = 'SideBySide';
            this.left = '';
            this.right = '';
            this.loading = false;
            this.showToolbar = true;
            this.showBtnToolbar = true;
            this.synchronizeScrolling = true;
            this.compareResults = new core.EventEmitter();
            this.subscriptions = [];
            this.tableRows = [];
            this.filteredTableRows = [];
            this.tableRowsLineByLine = [];
            this.filteredTableRowsLineByLine = [];
            this.diffsCount = 0;
            this.formatOptions = [
                {
                    id: 'side-by-side',
                    name: 'side-by-side',
                    label: 'Side by Side',
                    value: 'SideBySide',
                    icon: 'la-code',
                },
                {
                    id: 'line-by-line',
                    name: 'line-by-line',
                    label: 'Line by Line',
                    value: 'LineByLine',
                    icon: 'la-file-text',
                },
            ];
        }
        Object.defineProperty(NgxTextDiffComponent.prototype, "hideMatchingLines", {
            get: function () {
                return this._hideMatchingLines;
            },
            set: function (hide) {
                this.hideMatchingLinesChanged(hide);
            },
            enumerable: true,
            configurable: true
        });
        NgxTextDiffComponent.prototype.ngOnInit = function () {
            var _this = this;
            this.loading = true;
            if (this.diffContent) {
                this.subscriptions.push(this.diffContent.subscribe(function (content) {
                    _this.loading = true;
                    _this.left = content.leftContent;
                    _this.right = content.rightContent;
                    _this.renderDiffs()
                        .then(function () {
                        _this.cd.detectChanges();
                        _this.loading = false;
                    })
                        .catch(function () { return (_this.loading = false); });
                }));
            }
            this.renderDiffs()
                .then(function () { return (_this.loading = false); })
                .catch(function (e) { return (_this.loading = false); });
        };
        NgxTextDiffComponent.prototype.ngAfterViewInit = function () {
            this.initScrollListener();
        };
        NgxTextDiffComponent.prototype.ngOnDestroy = function () {
            if (this.subscriptions) {
                this.subscriptions.forEach(function (subscription) { return subscription.unsubscribe(); });
            }
        };
        NgxTextDiffComponent.prototype.hideMatchingLinesChanged = function (value) {
            this._hideMatchingLines = value;
            if (this.hideMatchingLines) {
                this.filteredTableRows = this.tableRows.filter(function (row) { return (row.leftContent && row.leftContent.prefix === '-') || (row.rightContent && row.rightContent.prefix === '+'); });
                this.filteredTableRowsLineByLine = this.tableRowsLineByLine.filter(function (row) { return (row.leftContent && row.leftContent.prefix === '-') || (row.rightContent && row.rightContent.prefix === '+'); });
            }
            else {
                this.filteredTableRows = this.tableRows;
                this.filteredTableRowsLineByLine = this.tableRowsLineByLine;
            }
        };
        NgxTextDiffComponent.prototype.setDiffTableFormat = function (format) {
            this.format = format;
        };
        NgxTextDiffComponent.prototype.renderDiffs = function () {
            return __awaiter(this, void 0, void 0, function () {
                var _a, e_1;
                return __generator(this, function (_b) {
                    switch (_b.label) {
                        case 0:
                            _b.trys.push([0, 2, , 3]);
                            this.diffsCount = 0;
                            _a = this;
                            return [4 /*yield*/, this.diff.getDiffsByLines(this.left, this.right)];
                        case 1:
                            _a.tableRows = _b.sent();
                            this.tableRowsLineByLine = this.tableRows.reduce(function (tableLineByLine, row) {
                                if (!tableLineByLine) {
                                    tableLineByLine = [];
                                }
                                if (row.hasDiffs) {
                                    if (row.leftContent) {
                                        tableLineByLine.push({
                                            leftContent: row.leftContent,
                                            rightContent: null,
                                            belongTo: row.belongTo,
                                            hasDiffs: true,
                                            numDiffs: row.numDiffs,
                                        });
                                    }
                                    if (row.rightContent) {
                                        tableLineByLine.push({
                                            leftContent: null,
                                            rightContent: row.rightContent,
                                            belongTo: row.belongTo,
                                            hasDiffs: true,
                                            numDiffs: row.numDiffs,
                                        });
                                    }
                                }
                                else {
                                    tableLineByLine.push(row);
                                }
                                return tableLineByLine;
                            }, []);
                            this.diffsCount = this.tableRows.filter(function (row) { return row.hasDiffs; }).length;
                            this.filteredTableRows = this.tableRows;
                            this.filteredTableRowsLineByLine = this.tableRowsLineByLine;
                            this.emitCompareResultsEvent();
                            return [3 /*break*/, 3];
                        case 2:
                            e_1 = _b.sent();
                            throw e_1;
                        case 3: return [2 /*return*/];
                    }
                });
            });
        };
        NgxTextDiffComponent.prototype.emitCompareResultsEvent = function () {
            var diffResults = {
                hasDiff: this.diffsCount > 0,
                diffsCount: this.diffsCount,
                rowsWithDiff: this.tableRows
                    .filter(function (row) { return row.hasDiffs; })
                    .map(function (row) { return ({
                    leftLineNumber: row.leftContent ? row.leftContent.lineNumber : null,
                    rightLineNumber: row.rightContent ? row.rightContent.lineNumber : null,
                    numDiffs: row.numDiffs,
                }); }),
            };
            this.compareResults.next(diffResults);
        };
        NgxTextDiffComponent.prototype.trackTableRows = function (index, row) {
            return row && row.leftContent ? row.leftContent.lineContent : row && row.rightContent ? row.rightContent.lineContent : undefined;
        };
        NgxTextDiffComponent.prototype.trackDiffs = function (index, diff) {
            return diff && diff.content ? diff.content : undefined;
        };
        NgxTextDiffComponent.prototype.initScrollListener = function () {
            var _this = this;
            this.subscriptions.push(this.scrollService.scrolled().subscribe(function (scrollableEv) {
                if (scrollableEv && _this.synchronizeScrolling) {
                    var scrollableId_1 = scrollableEv.getElementRef().nativeElement.id;
                    var nonScrolledContainer = _this.containers.find(function (container) { return container.id !== scrollableId_1; });
                    if (nonScrolledContainer) {
                        nonScrolledContainer.element.scrollTo({
                            top: scrollableEv.measureScrollOffset('top'),
                            left: scrollableEv.measureScrollOffset('left'),
                        });
                    }
                }
            }));
        };
        NgxTextDiffComponent.ctorParameters = function () { return [
            { type: scrolling.ScrollDispatcher },
            { type: NgxTextDiffService },
            { type: core.ChangeDetectorRef }
        ]; };
        __decorate([
            core.ViewChildren(ContainerDirective),
            __metadata("design:type", core.QueryList)
        ], NgxTextDiffComponent.prototype, "containers", void 0);
        __decorate([
            core.Input(),
            __metadata("design:type", String)
        ], NgxTextDiffComponent.prototype, "format", void 0);
        __decorate([
            core.Input(),
            __metadata("design:type", Object)
        ], NgxTextDiffComponent.prototype, "left", void 0);
        __decorate([
            core.Input(),
            __metadata("design:type", Object)
        ], NgxTextDiffComponent.prototype, "right", void 0);
        __decorate([
            core.Input(),
            __metadata("design:type", rxjs.Observable)
        ], NgxTextDiffComponent.prototype, "diffContent", void 0);
        __decorate([
            core.Input(),
            __metadata("design:type", Object)
        ], NgxTextDiffComponent.prototype, "loading", void 0);
        __decorate([
            core.Input(),
            __metadata("design:type", Object)
        ], NgxTextDiffComponent.prototype, "showToolbar", void 0);
        __decorate([
            core.Input(),
            __metadata("design:type", Object)
        ], NgxTextDiffComponent.prototype, "showBtnToolbar", void 0);
        __decorate([
            core.Input(),
            __metadata("design:type", Boolean),
            __metadata("design:paramtypes", [Boolean])
        ], NgxTextDiffComponent.prototype, "hideMatchingLines", null);
        __decorate([
            core.Input(),
            __metadata("design:type", String)
        ], NgxTextDiffComponent.prototype, "outerContainerClass", void 0);
        __decorate([
            core.Input(),
            __metadata("design:type", Object)
        ], NgxTextDiffComponent.prototype, "outerContainerStyle", void 0);
        __decorate([
            core.Input(),
            __metadata("design:type", String)
        ], NgxTextDiffComponent.prototype, "toolbarClass", void 0);
        __decorate([
            core.Input(),
            __metadata("design:type", Object)
        ], NgxTextDiffComponent.prototype, "toolbarStyle", void 0);
        __decorate([
            core.Input(),
            __metadata("design:type", String)
        ], NgxTextDiffComponent.prototype, "compareRowsClass", void 0);
        __decorate([
            core.Input(),
            __metadata("design:type", Object)
        ], NgxTextDiffComponent.prototype, "compareRowsStyle", void 0);
        __decorate([
            core.Input(),
            __metadata("design:type", Object)
        ], NgxTextDiffComponent.prototype, "synchronizeScrolling", void 0);
        __decorate([
            core.Output(),
            __metadata("design:type", Object)
        ], NgxTextDiffComponent.prototype, "compareResults", void 0);
        NgxTextDiffComponent = __decorate([
            core.Component({
                selector: 'td-ngx-text-diff',
                template: "<td-loader-spinner [active]=\"loading\"></td-loader-spinner>\r\n<div class=\"td-wrapper\" [ngClass]=\"outerContainerClass\" [ngStyle]=\"outerContainerStyle\" *ngIf=\"!loading\">\r\n\r\n  <div [ngClass]=\"toolbarClass\" [ngStyle]=\"toolbarStyle\" *ngIf=\"showToolbar\">\r\n    <div class=\"td-toolbar-show-diff\">\r\n      <label class=\"td-checkbox-container\">\r\n        Only Show Lines with Differences ({{ diffsCount }})\r\n        <input type=\"checkbox\" id=\"showDiffs\" [ngModel]=\"hideMatchingLines\" (ngModelChange)=\"hideMatchingLinesChanged($event)\" />\r\n        <span class=\"checkmark\"></span>\r\n      </label>\r\n    </div>\r\n  </div>\r\n\r\n  <div class=\"td-toolbar-select-format\" *ngIf=\"showToolbar && showBtnToolbar\">\r\n    <div class=\"td-btn-group td-btn-group-toggle\" data-toggle=\"buttons\">\r\n      <button\r\n        *ngFor=\"let option of formatOptions\"\r\n        [ngClass]=\"{ active: format === option.value, disabled: !!option.disabled }\"\r\n        [name]=\"option.name\"\r\n        [id]=\"option.id\"\r\n        [disabled]=\"!!option.disabled\"\r\n        (click)=\"setDiffTableFormat(option.value)\"\r\n      >\r\n        {{ option.label }}\r\n      </button>\r\n    </div>\r\n  </div>\r\n\r\n  <div class=\"td-table-wrapper\" [ngClass]=\"compareRowsClass\" [ngStyle]=\"compareRowsStyle\">\r\n    <!-- Right side-by-side -->\r\n    <div class=\"td-table-container side-by-side\" *ngIf=\"format === 'SideBySide'\" id=\"td-left-compare-container\" tdContainer cdkScrollable>\r\n      <table class=\"td-table\">\r\n        <tbody>\r\n          <tr *ngFor=\"let row of filteredTableRows; trackBy: trackTableRows\">\r\n            <td\r\n              scope=\"row\"\r\n              class=\"fit-column line-number-col\"\r\n              [ngClass]=\"{ 'delete-row': row.leftContent?.prefix === '-', 'empty-row': !row.leftContent?.lineContent }\"\r\n            >\r\n              {{ row.leftContent?.lineNumber !== -1 ? row.leftContent?.lineNumber : ' ' }}\r\n            </td>\r\n            <td\r\n              class=\"fit-column prefix-col\"\r\n              [ngClass]=\"{ 'delete-row': row.leftContent?.prefix === '-', 'empty-row': !row.leftContent?.lineContent }\"\r\n            >\r\n              <span>{{ row.leftContent?.prefix || ' ' }}</span>\r\n            </td>\r\n            <td\r\n              class=\"content-col\"\r\n              [ngClass]=\"{ 'delete-row': row.leftContent?.prefix === '-', 'empty-row': !row.leftContent?.lineContent }\"\r\n              *ngIf=\"!row.hasDiffs\"\r\n            >\r\n              <span [innerHTML]=\"row.leftContent?.lineContent | formatLine\"></span>\r\n            </td>\r\n            <td\r\n              class=\"content-col\"\r\n              [ngClass]=\"{ 'delete-row': row.leftContent?.prefix === '-', 'empty-row': !row.leftContent?.lineContent }\"\r\n              *ngIf=\"row.hasDiffs\"\r\n            >\r\n              <span\r\n                [innerHTML]=\"diff.content | formatLine\"\r\n                [ngClass]=\"{ highlight: diff.isDiff }\"\r\n                *ngFor=\"let diff of row.leftContent?.lineDiffs; trackBy: trackDiffs\"\r\n              ></span>\r\n            </td>\r\n          </tr>\r\n        </tbody>\r\n      </table>\r\n    </div>\r\n    <!-- Left side-by-side -->\r\n    <div class=\"td-table-container side-by-side\" *ngIf=\"format === 'SideBySide'\" id=\"td-right-compare-container\" tdContainer cdkScrollable>\r\n      <table class=\"td-table\">\r\n        <tbody>\r\n          <tr *ngFor=\"let row of filteredTableRows; trackBy: trackTableRows\">\r\n            <td\r\n              scope=\"row\"\r\n              class=\"fit-column line-number-col\"\r\n              [ngClass]=\"{ 'insert-row': row.rightContent?.prefix === '+', 'empty-row': !row.rightContent?.lineContent }\"\r\n            >\r\n              {{ row.rightContent?.lineNumber !== -1 ? row.rightContent?.lineNumber : ' ' }}\r\n            </td>\r\n            <td\r\n              class=\"fit-column prefix-col\"\r\n              [ngClass]=\"{ 'insert-row': row.rightContent?.prefix === '+', 'empty-row': !row.rightContent?.lineContent }\"\r\n            >\r\n              <span>{{ row.rightContent?.prefix || ' ' }}</span>\r\n            </td>\r\n            <td\r\n              class=\"content-col\"\r\n              [ngClass]=\"{ 'insert-row': row.rightContent?.prefix === '+', 'empty-row': !row.rightContent?.lineContent }\"\r\n              *ngIf=\"!row.hasDiffs\"\r\n            >\r\n              <span [innerHTML]=\"row.rightContent?.lineContent | formatLine\"></span>\r\n            </td>\r\n            <td\r\n              class=\"content-col\"\r\n              [ngClass]=\"{ 'insert-row': row.rightContent?.prefix === '+', 'empty-row': !row.rightContent?.lineContent }\"\r\n              *ngIf=\"row.hasDiffs\"\r\n            >\r\n              <span\r\n                [innerHTML]=\"diff.content | formatLine\"\r\n                [ngClass]=\"{ highlight: diff.isDiff }\"\r\n                *ngFor=\"let diff of row.rightContent?.lineDiffs; trackBy: trackDiffs\"\r\n              ></span>\r\n            </td>\r\n          </tr>\r\n        </tbody>\r\n      </table>\r\n    </div>\r\n    <!-- Line By Line - combined table -->\r\n    <div class=\"td-table-container line-by-line\" *ngIf=\"format === 'LineByLine'\">\r\n      <table class=\"td-table\">\r\n        <tbody>\r\n          <tr *ngFor=\"let row of filteredTableRowsLineByLine; trackBy: trackTableRows\">\r\n            <td scope=\"row\" class=\"fit-column line-number-col-left\">{{ row.leftContent?.lineNumber }}</td>\r\n            <td scope=\"row\" class=\"fit-column line-number-col\">{{ row.rightContent?.lineNumber }}</td>\r\n            <td\r\n              class=\"fit-column prefix-col\"\r\n              [ngClass]=\"{ 'delete-row': row.leftContent?.prefix === '-', 'insert-row': row.rightContent?.prefix === '+' }\"\r\n            >\r\n              <span>{{ row.leftContent?.prefix || row.rightContent?.prefix || ' ' }}</span>\r\n            </td>\r\n            <td\r\n              class=\"content-col\"\r\n              [ngClass]=\"{ 'delete-row': row.leftContent?.prefix === '-', 'insert-row': row.rightContent?.prefix === '+' }\"\r\n              *ngIf=\"!row.hasDiffs\"\r\n            >\r\n              <span [innerHTML]=\"row.leftContent?.lineContent | formatLine\"></span>\r\n            </td>\r\n            <td\r\n              class=\"content-col\"\r\n              [ngClass]=\"{ 'delete-row': row.leftContent?.prefix === '-', 'insert-row': row.rightContent?.prefix === '+' }\"\r\n              *ngIf=\"row.hasDiffs && row.leftContent && row.leftContent?.lineDiffs.length !== 0\"\r\n            >\r\n              <span\r\n                [innerHTML]=\"diff.content | formatLine\"\r\n                [ngClass]=\"{ highlight: diff.isDiff }\"\r\n                *ngFor=\"let diff of row.leftContent?.lineDiffs; trackBy: trackDiffs\"\r\n              ></span>\r\n            </td>\r\n            <td\r\n              class=\"content-col\"\r\n              [ngClass]=\"{ 'delete-row': row.leftContent?.prefix === '-', 'insert-row': row.rightContent?.prefix === '+' }\"\r\n              *ngIf=\"row.hasDiffs && row.rightContent && row.rightContent?.lineDiffs.length !== 0\"\r\n            >\r\n              <span\r\n                [innerHTML]=\"diff.content | formatLine\"\r\n                [ngClass]=\"{ highlight: diff.isDiff }\"\r\n                *ngFor=\"let diff of row.rightContent?.lineDiffs; trackBy: trackDiffs\"\r\n              ></span>\r\n            </td>\r\n          </tr>\r\n        </tbody>\r\n      </table>\r\n    </div>\r\n  </div>\r\n</div>\r\n",
                styles: [".td-wrapper{display:grid;width:100%;grid-row-gap:10px;grid-template-columns:repeat(2,[col] 50%);grid-template-rows:repeat(2,[row] auto);background-color:#fff;color:#444}.td-toolbar-show-diff{grid-column:1;grid-row:1}.td-toolbar-select-format{margin-left:auto;grid-column:2;grid-row:1}.td-table-container{grid-column:1/2;grid-row:2;width:100%;max-width:100%;overflow-x:auto}.td-table-wrapper{display:flex;width:200%}.td-table{border:1px solid #a9a9a9;max-height:50vh;width:100%;max-width:100%}.fit-column{width:1px;white-space:nowrap}.line-number-col{position:relative;position:-webkit-sticky;position:sticky;left:0;top:auto;border-right:1px solid #ddd;color:#999;text-align:right;background-color:#f7f7f7;padding-left:10px;padding-right:10px;font-size:87.5%}.line-number-col-left{color:#999;padding-left:10px;padding-right:10px;text-align:right;background-color:#f7f7f7;font-size:87.5%}.insert-row,.insert-row>.line-number-col{background-color:#dfd;border-color:#b4e2b4}.delete-row,.delete-row>.line-number-col{background-color:#fee8e9;border-color:#e9aeae}.empty-row{background-color:#f7f7f7;height:24px}.td-table td{border-top:0;padding-top:0;padding-bottom:0;white-space:nowrap;max-width:50%}pre{margin-bottom:0}td.content-col{padding:0;margin:0;line-height:24px}td.prefix-col{padding-left:10px;padding-right:10px;line-height:24px}.td-btn-group{border-radius:4px}.td-btn-group button{background-color:rgba(23,162,184,.7);border:1px solid #17a2b8;color:#fff;cursor:pointer;float:left}.td-btn-group button:not(:last-child){border-right:none}.td-btn-group button:first-child{-webkit-border-top-left-radius:4px;-webkit-border-bottom-left-radius:4px;-moz-border-radius-topleft:4px;-moz-border-radius-bottomleft:4px;border-top-left-radius:4px;border-bottom-left-radius:4px}.td-btn-group button:last-child{-webkit-border-top-right-radius:4px;-webkit-border-bottom-right-radius:4px;-moz-border-radius-topright:4px;-moz-border-radius-bottomright:4px;border-top-right-radius:4px;border-bottom-right-radius:4px}.td-btn-group:after{content:'';clear:both;display:table}.td-btn-group button.active,.td-btn-group button:hover{background-color:#17a2b8}.td-checkbox-container{display:block;position:relative;padding-left:21px;margin-bottom:0;cursor:pointer;font-size:16px;line-height:28px;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none}.td-checkbox-container input{position:absolute;opacity:0;cursor:pointer;height:0;width:0}.checkmark{position:absolute;top:7px;left:0;height:16px;width:16px;background-color:#eee}.td-checkbox-container:hover input~.checkmark{background-color:#ccc}.td-checkbox-container input:checked~.checkmark{background-color:#17a2b8}.checkmark:after{content:\"\";position:absolute;display:none}.td-checkbox-container input:checked~.checkmark:after{display:block}.td-checkbox-container .checkmark:after{left:5px;top:3px;width:5px;height:10px;border:solid #fff;border-width:0 3px 3px 0;transform:rotate(45deg)}.insert-row>.highlight{background-color:#acf2bd!important}.delete-row>.highlight{background-color:#fdb8c0!important}"]
            }),
            __metadata("design:paramtypes", [scrolling.ScrollDispatcher, NgxTextDiffService, core.ChangeDetectorRef])
        ], NgxTextDiffComponent);
        return NgxTextDiffComponent;
    }());

    var LoaderSpinnerComponent = /** @class */ (function () {
        function LoaderSpinnerComponent() {
            this.active = false;
        }
        LoaderSpinnerComponent.prototype.ngOnInit = function () { };
        __decorate([
            core.Input(),
            __metadata("design:type", Object)
        ], LoaderSpinnerComponent.prototype, "active", void 0);
        LoaderSpinnerComponent = __decorate([
            core.Component({
                selector: 'td-loader-spinner',
                template: "<div class=\"td-loading-roller\" *ngIf=\"active\">\r\n  <div></div>\r\n  <div></div>\r\n  <div></div>\r\n  <div></div>\r\n  <div></div>\r\n  <div></div>\r\n  <div></div>\r\n  <div></div>\r\n</div>\r\n",
                styles: [".td-loading-roller{display:inline-block;position:relative;width:64px;height:64px}.td-loading-roller div{-webkit-animation:1.2s cubic-bezier(.5,0,.5,1) infinite lds-roller;animation:1.2s cubic-bezier(.5,0,.5,1) infinite lds-roller;transform-origin:32px 32px}.td-loading-roller div:after{content:\" \";display:block;position:absolute;width:6px;height:6px;border-radius:50%;background:#000;margin:-3px 0 0 -3px}.td-loading-roller div:nth-child(1){-webkit-animation-delay:-36ms;animation-delay:-36ms}.td-loading-roller div:nth-child(1):after{top:50px;left:50px}.td-loading-roller div:nth-child(2){-webkit-animation-delay:-72ms;animation-delay:-72ms}.td-loading-roller div:nth-child(2):after{top:54px;left:45px}.td-loading-roller div:nth-child(3){-webkit-animation-delay:-108ms;animation-delay:-108ms}.td-loading-roller div:nth-child(3):after{top:57px;left:39px}.td-loading-roller div:nth-child(4){-webkit-animation-delay:-144ms;animation-delay:-144ms}.td-loading-roller div:nth-child(4):after{top:58px;left:32px}.td-loading-roller div:nth-child(5){-webkit-animation-delay:-.18s;animation-delay:-.18s}.td-loading-roller div:nth-child(5):after{top:57px;left:25px}.td-loading-roller div:nth-child(6){-webkit-animation-delay:-216ms;animation-delay:-216ms}.td-loading-roller div:nth-child(6):after{top:54px;left:19px}.td-loading-roller div:nth-child(7){-webkit-animation-delay:-252ms;animation-delay:-252ms}.td-loading-roller div:nth-child(7):after{top:50px;left:14px}.td-loading-roller div:nth-child(8){-webkit-animation-delay:-288ms;animation-delay:-288ms}.td-loading-roller div:nth-child(8):after{top:45px;left:10px}@-webkit-keyframes lds-roller{0%{transform:rotate(0)}100%{transform:rotate(360deg)}}@keyframes lds-roller{0%{transform:rotate(0)}100%{transform:rotate(360deg)}}"]
            }),
            __metadata("design:paramtypes", [])
        ], LoaderSpinnerComponent);
        return LoaderSpinnerComponent;
    }());

    var FormatLinePipe = /** @class */ (function () {
        function FormatLinePipe() {
        }
        FormatLinePipe.prototype.transform = function (line, diffs) {
            if (!line) {
                return ' ';
            }
            if (!!diffs && diffs.length > 0) {
                /*diffs.forEach(diff => {
                  line = line.replace(diff, `<span class="highli">${diff}</span>`);
                });*/
            }
            return line
                .replace(/&/g, '&amp;')
                .replace(/</g, '&lt;')
                .replace(/>/g, '&gt;')
                .replace(/"/g, '&quot;')
                .replace(/ /g, '&nbsp;');
        };
        FormatLinePipe = __decorate([
            core.Pipe({
                name: 'formatLine'
            })
        ], FormatLinePipe);
        return FormatLinePipe;
    }());

    var NgxTextDiffModule = /** @class */ (function () {
        function NgxTextDiffModule() {
        }
        NgxTextDiffModule = __decorate([
            core.NgModule({
                imports: [common.CommonModule, forms.FormsModule, scrolling.ScrollingModule],
                declarations: [NgxTextDiffComponent, LoaderSpinnerComponent, FormatLinePipe, ContainerDirective],
                exports: [NgxTextDiffComponent],
            })
        ], NgxTextDiffModule);
        return NgxTextDiffModule;
    }());

    exports.NgxTextDiffComponent = NgxTextDiffComponent;
    exports.NgxTextDiffModule = NgxTextDiffModule;
    exports.NgxTextDiffService = NgxTextDiffService;
    exports.ɵa = ContainerDirective;
    exports.ɵb = LoaderSpinnerComponent;
    exports.ɵc = FormatLinePipe;

    Object.defineProperty(exports, '__esModule', { value: true });

})));
//# sourceMappingURL=ngx-text-diff.umd.js.map
