import { __decorate, __metadata } from "tslib";
import { Injectable } from '@angular/core';
import { DIFF_DELETE, DIFF_EQUAL, DIFF_INSERT, diff_match_patch } from 'diff-match-patch';
import { isEmpty } from './ngx-text-diff.utils';
import * as i0 from "@angular/core";
let NgxTextDiffService = class NgxTextDiffService {
    constructor() {
        this.initParser();
    }
    initParser() {
        this.diffParser = new diff_match_patch();
    }
    getDiffsByLines(left, right) {
        return new Promise((resolve, reject) => {
            const a = this.diffParser.diff_linesToChars_(left, right);
            const lineText1 = a.chars1;
            const lineText2 = a.chars2;
            const linesArray = a.lineArray;
            const diffs = this.diffParser.diff_main(lineText1, lineText2, true);
            this.diffParser.diff_charsToLines_(diffs, linesArray);
            const rows = this.formatOutput(diffs);
            if (!rows) {
                reject('Error');
            }
            resolve(rows);
        });
    }
    formatOutput(diffs) {
        let lineLeft = 1;
        let lineRight = 1;
        return diffs.reduce((rows, diff) => {
            if (!rows) {
                rows = [];
            }
            const diffType = diff[0];
            const diffValue = diff[1];
            let leftDiffRow = null;
            let rightDiffRow = null;
            let leftContent = null;
            let rightContent = null;
            let rowTemp = null;
            switch (diffType) {
                case DIFF_EQUAL: // 0
                    diffValue
                        .split('\n')
                        .filter((value, index, array) => {
                        if (index === array.length - 1) {
                            return !isEmpty(value);
                        }
                        return true;
                    })
                        .forEach(line => {
                        leftContent = {
                            lineNumber: lineLeft,
                            lineContent: line,
                            lineDiffs: [],
                            prefix: ''
                        };
                        rightContent = {
                            lineNumber: lineRight,
                            lineContent: line,
                            lineDiffs: [],
                            prefix: ''
                        };
                        rowTemp = {
                            leftContent,
                            rightContent,
                            belongTo: 'both',
                            hasDiffs: false,
                            numDiffs: 0,
                        };
                        rows.push(rowTemp);
                        lineRight = lineRight + 1;
                        lineLeft = lineLeft + 1;
                    });
                    break;
                case DIFF_DELETE: // -1
                    diffValue
                        .split('\n')
                        .filter((value, index, array) => {
                        if (index === array.length - 1) {
                            return !isEmpty(value);
                        }
                        return true;
                    })
                        .forEach(line => {
                        rightDiffRow = rows.find(row => !row.leftContent && row.rightContent && row.rightContent.lineNumber === lineLeft && row.rightContent.prefix !== '');
                        leftContent = {
                            lineNumber: lineLeft,
                            lineContent: line,
                            lineDiffs: [{ content: line, isDiff: true }],
                            prefix: '-'
                        };
                        if (rightDiffRow) {
                            rightDiffRow.leftContent = leftContent;
                            rightDiffRow.leftContent.lineDiffs = this.getDiffParts(rightDiffRow.leftContent.lineContent, rightDiffRow.rightContent.lineContent);
                            rightDiffRow.rightContent.lineDiffs = this.getDiffParts(rightDiffRow.rightContent.lineContent, rightDiffRow.leftContent.lineContent);
                            rightDiffRow.belongTo = 'both';
                            rightDiffRow.numDiffs = this.countDiffs(rightDiffRow);
                        }
                        else {
                            rows.push({
                                leftContent,
                                rightContent: null,
                                hasDiffs: true,
                                belongTo: 'left',
                                numDiffs: 1,
                            });
                        }
                        lineLeft = lineLeft + 1;
                    });
                    break;
                case DIFF_INSERT: // 1
                    diffValue
                        .split('\n')
                        .filter((value, index, array) => {
                        if (index === array.length - 1) {
                            return !isEmpty(value);
                        }
                        return true;
                    })
                        .forEach(line => {
                        leftDiffRow = rows.find(row => row.leftContent && !row.rightContent && row.leftContent.lineNumber === lineRight && row.leftContent.prefix !== '');
                        rightContent = {
                            lineNumber: lineRight,
                            lineContent: line,
                            lineDiffs: [{ content: line, isDiff: true }],
                            prefix: '+'
                        };
                        if (leftDiffRow) {
                            leftDiffRow.rightContent = rightContent;
                            leftDiffRow.leftContent.lineDiffs = this.getDiffParts(leftDiffRow.leftContent.lineContent, leftDiffRow.rightContent.lineContent);
                            leftDiffRow.rightContent.lineDiffs = this.getDiffParts(leftDiffRow.rightContent.lineContent, leftDiffRow.leftContent.lineContent);
                            leftDiffRow.belongTo = 'both';
                            leftDiffRow.numDiffs = this.countDiffs(leftDiffRow);
                        }
                        else {
                            rows.push({
                                leftContent: null,
                                rightContent,
                                hasDiffs: true,
                                belongTo: 'right',
                                numDiffs: 1,
                            });
                        }
                        lineRight = lineRight + 1;
                    });
                    break;
            }
            return rows;
        }, []);
    }
    countDiffs(result) {
        let diffCount = 0;
        if (result.leftContent) {
            diffCount += result.leftContent.lineDiffs.filter(diff => diff.isDiff).length;
        }
        if (result.leftContent) {
            diffCount += result.rightContent.lineDiffs.filter(diff => diff.isDiff).length;
        }
        return diffCount;
    }
    getDiffParts(value, compareValue) {
        const diffParts = [];
        let i = 0;
        let j = 0;
        let shared = '';
        let diff = '';
        while (i < value.length) {
            if (value[i] === compareValue[j] && j < compareValue.length) {
                if (diff !== '') {
                    diffParts.push({ content: diff, isDiff: true });
                    diff = '';
                }
                shared += value[i];
            }
            else {
                if (shared !== '') {
                    diffParts.push({ content: shared, isDiff: false });
                    shared = '';
                }
                diff += value[i];
            }
            i++;
            j++;
        }
        if (diff !== '') {
            diffParts.push({ content: diff, isDiff: true });
        }
        else if (shared !== '') {
            diffParts.push({ content: shared, isDiff: false });
        }
        return diffParts;
    }
};
NgxTextDiffService.ɵprov = i0.ɵɵdefineInjectable({ factory: function NgxTextDiffService_Factory() { return new NgxTextDiffService(); }, token: NgxTextDiffService, providedIn: "root" });
NgxTextDiffService = __decorate([
    Injectable({
        providedIn: 'root'
    }),
    __metadata("design:paramtypes", [])
], NgxTextDiffService);
export { NgxTextDiffService };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibmd4LXRleHQtZGlmZi5zZXJ2aWNlLmpzIiwic291cmNlUm9vdCI6Im5nOi8vbmd4LXRleHQtZGlmZi8iLCJzb3VyY2VzIjpbImxpYi9uZ3gtdGV4dC1kaWZmLnNlcnZpY2UudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUFBLE9BQU8sRUFBRSxVQUFVLEVBQUUsTUFBTSxlQUFlLENBQUM7QUFDM0MsT0FBTyxFQUFRLFdBQVcsRUFBRSxVQUFVLEVBQUUsV0FBVyxFQUFFLGdCQUFnQixFQUFFLE1BQU0sa0JBQWtCLENBQUM7QUFFaEcsT0FBTyxFQUFFLE9BQU8sRUFBUyxNQUFNLHVCQUF1QixDQUFDOztBQUt2RCxJQUFhLGtCQUFrQixHQUEvQixNQUFhLGtCQUFrQjtJQUc3QjtRQUNFLElBQUksQ0FBQyxVQUFVLEVBQUUsQ0FBQztJQUNwQixDQUFDO0lBRU8sVUFBVTtRQUNoQixJQUFJLENBQUMsVUFBVSxHQUFHLElBQUksZ0JBQWdCLEVBQUUsQ0FBQztJQUMzQyxDQUFDO0lBRUQsZUFBZSxDQUFDLElBQVksRUFBRSxLQUFhO1FBQ3pDLE9BQU8sSUFBSSxPQUFPLENBQXVCLENBQUMsT0FBTyxFQUFFLE1BQU0sRUFBRSxFQUFFO1lBQzNELE1BQU0sQ0FBQyxHQUFHLElBQUksQ0FBQyxVQUFVLENBQUMsa0JBQWtCLENBQUMsSUFBSSxFQUFFLEtBQUssQ0FBQyxDQUFDO1lBQzFELE1BQU0sU0FBUyxHQUFHLENBQUMsQ0FBQyxNQUFNLENBQUM7WUFDM0IsTUFBTSxTQUFTLEdBQUcsQ0FBQyxDQUFDLE1BQU0sQ0FBQztZQUMzQixNQUFNLFVBQVUsR0FBRyxDQUFDLENBQUMsU0FBUyxDQUFDO1lBQy9CLE1BQU0sS0FBSyxHQUFXLElBQUksQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDLFNBQVMsRUFBRSxTQUFTLEVBQUUsSUFBSSxDQUFDLENBQUM7WUFDNUUsSUFBSSxDQUFDLFVBQVUsQ0FBQyxrQkFBa0IsQ0FBQyxLQUFLLEVBQUUsVUFBVSxDQUFDLENBQUM7WUFDdEQsTUFBTSxJQUFJLEdBQXlCLElBQUksQ0FBQyxZQUFZLENBQUMsS0FBSyxDQUFDLENBQUM7WUFDNUQsSUFBSSxDQUFDLElBQUksRUFBRTtnQkFDVCxNQUFNLENBQUMsT0FBTyxDQUFDLENBQUM7YUFDakI7WUFFRCxPQUFPLENBQUMsSUFBSSxDQUFDLENBQUM7UUFDaEIsQ0FBQyxDQUFDLENBQUM7SUFDTCxDQUFDO0lBRU8sWUFBWSxDQUFDLEtBQWE7UUFDaEMsSUFBSSxRQUFRLEdBQUcsQ0FBQyxDQUFDO1FBQ2pCLElBQUksU0FBUyxHQUFHLENBQUMsQ0FBQztRQUNsQixPQUFPLEtBQUssQ0FBQyxNQUFNLENBQUMsQ0FBQyxJQUEwQixFQUFFLElBQVUsRUFBRSxFQUFFO1lBQzdELElBQUksQ0FBQyxJQUFJLEVBQUU7Z0JBQ1QsSUFBSSxHQUFHLEVBQUUsQ0FBQzthQUNYO1lBQ0QsTUFBTSxRQUFRLEdBQVcsSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFDO1lBQ2pDLE1BQU0sU0FBUyxHQUFXLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQztZQUNsQyxJQUFJLFdBQVcsR0FBdUIsSUFBSSxDQUFDO1lBQzNDLElBQUksWUFBWSxHQUF1QixJQUFJLENBQUM7WUFDNUMsSUFBSSxXQUFXLEdBQW1CLElBQUksQ0FBQztZQUN2QyxJQUFJLFlBQVksR0FBbUIsSUFBSSxDQUFDO1lBQ3hDLElBQUksT0FBTyxHQUF1QixJQUFJLENBQUM7WUFDdkMsUUFBUSxRQUFRLEVBQUU7Z0JBQ2hCLEtBQUssVUFBVSxFQUFFLElBQUk7b0JBQ25CLFNBQVM7eUJBQ04sS0FBSyxDQUFDLElBQUksQ0FBQzt5QkFDWCxNQUFNLENBQUMsQ0FBQyxLQUFLLEVBQUUsS0FBSyxFQUFFLEtBQUssRUFBRSxFQUFFO3dCQUM5QixJQUFJLEtBQUssS0FBSyxLQUFLLENBQUMsTUFBTSxHQUFHLENBQUMsRUFBRTs0QkFDOUIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxLQUFLLENBQUMsQ0FBQzt5QkFDeEI7d0JBQ0QsT0FBTyxJQUFJLENBQUM7b0JBQ2QsQ0FBQyxDQUFDO3lCQUNELE9BQU8sQ0FBQyxJQUFJLENBQUMsRUFBRTt3QkFDZCxXQUFXLEdBQUc7NEJBQ1osVUFBVSxFQUFFLFFBQVE7NEJBQ3BCLFdBQVcsRUFBRSxJQUFJOzRCQUNqQixTQUFTLEVBQUUsRUFBRTs0QkFDYixNQUFNLEVBQUUsRUFBRTt5QkFDWCxDQUFDO3dCQUNGLFlBQVksR0FBRzs0QkFDYixVQUFVLEVBQUUsU0FBUzs0QkFDckIsV0FBVyxFQUFFLElBQUk7NEJBQ2pCLFNBQVMsRUFBRSxFQUFFOzRCQUNiLE1BQU0sRUFBRSxFQUFFO3lCQUNYLENBQUM7d0JBQ0YsT0FBTyxHQUFHOzRCQUNSLFdBQVc7NEJBQ1gsWUFBWTs0QkFDWixRQUFRLEVBQUUsTUFBTTs0QkFDaEIsUUFBUSxFQUFFLEtBQUs7NEJBQ2YsUUFBUSxFQUFFLENBQUM7eUJBQ1osQ0FBQzt3QkFDRixJQUFJLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxDQUFDO3dCQUNuQixTQUFTLEdBQUcsU0FBUyxHQUFHLENBQUMsQ0FBQzt3QkFDMUIsUUFBUSxHQUFHLFFBQVEsR0FBRyxDQUFDLENBQUM7b0JBQzFCLENBQUMsQ0FBQyxDQUFDO29CQUNMLE1BQU07Z0JBQ1IsS0FBSyxXQUFXLEVBQUUsS0FBSztvQkFDckIsU0FBUzt5QkFDTixLQUFLLENBQUMsSUFBSSxDQUFDO3lCQUNYLE1BQU0sQ0FBQyxDQUFDLEtBQUssRUFBRSxLQUFLLEVBQUUsS0FBSyxFQUFFLEVBQUU7d0JBQzlCLElBQUksS0FBSyxLQUFLLEtBQUssQ0FBQyxNQUFNLEdBQUcsQ0FBQyxFQUFFOzRCQUM5QixPQUFPLENBQUMsT0FBTyxDQUFDLEtBQUssQ0FBQyxDQUFDO3lCQUN4Qjt3QkFDRCxPQUFPLElBQUksQ0FBQztvQkFDZCxDQUFDLENBQUM7eUJBQ0QsT0FBTyxDQUFDLElBQUksQ0FBQyxFQUFFO3dCQUNkLFlBQVksR0FBRyxJQUFJLENBQUMsSUFBSSxDQUN0QixHQUFHLENBQUMsRUFBRSxDQUFDLENBQUMsR0FBRyxDQUFDLFdBQVcsSUFBSSxHQUFHLENBQUMsWUFBWSxJQUFJLEdBQUcsQ0FBQyxZQUFZLENBQUMsVUFBVSxLQUFLLFFBQVEsSUFBSSxHQUFHLENBQUMsWUFBWSxDQUFDLE1BQU0sS0FBSyxFQUFFLENBQzFILENBQUM7d0JBQ0YsV0FBVyxHQUFHOzRCQUNaLFVBQVUsRUFBRSxRQUFROzRCQUNwQixXQUFXLEVBQUUsSUFBSTs0QkFDakIsU0FBUyxFQUFFLENBQUMsRUFBRSxPQUFPLEVBQUUsSUFBSSxFQUFFLE1BQU0sRUFBRSxJQUFJLEVBQUUsQ0FBQzs0QkFDNUMsTUFBTSxFQUFFLEdBQUc7eUJBQ1osQ0FBQzt3QkFDRixJQUFJLFlBQVksRUFBRTs0QkFDaEIsWUFBWSxDQUFDLFdBQVcsR0FBRyxXQUFXLENBQUM7NEJBQ3ZDLFlBQVksQ0FBQyxXQUFXLENBQUMsU0FBUyxHQUFHLElBQUksQ0FBQyxZQUFZLENBQ3BELFlBQVksQ0FBQyxXQUFXLENBQUMsV0FBVyxFQUNwQyxZQUFZLENBQUMsWUFBWSxDQUFDLFdBQVcsQ0FDdEMsQ0FBQzs0QkFDRixZQUFZLENBQUMsWUFBWSxDQUFDLFNBQVMsR0FBRyxJQUFJLENBQUMsWUFBWSxDQUNyRCxZQUFZLENBQUMsWUFBWSxDQUFDLFdBQVcsRUFDckMsWUFBWSxDQUFDLFdBQVcsQ0FBQyxXQUFXLENBQ3JDLENBQUM7NEJBQ0YsWUFBWSxDQUFDLFFBQVEsR0FBRyxNQUFNLENBQUM7NEJBQy9CLFlBQVksQ0FBQyxRQUFRLEdBQUcsSUFBSSxDQUFDLFVBQVUsQ0FBQyxZQUFZLENBQUMsQ0FBQzt5QkFDdkQ7NkJBQU07NEJBQ0wsSUFBSSxDQUFDLElBQUksQ0FBQztnQ0FDUixXQUFXO2dDQUNYLFlBQVksRUFBRSxJQUFJO2dDQUNsQixRQUFRLEVBQUUsSUFBSTtnQ0FDZCxRQUFRLEVBQUUsTUFBTTtnQ0FDaEIsUUFBUSxFQUFFLENBQUM7NkJBQ1osQ0FBQyxDQUFDO3lCQUNKO3dCQUNELFFBQVEsR0FBRyxRQUFRLEdBQUcsQ0FBQyxDQUFDO29CQUMxQixDQUFDLENBQUMsQ0FBQztvQkFDTCxNQUFNO2dCQUNSLEtBQUssV0FBVyxFQUFFLElBQUk7b0JBQ3BCLFNBQVM7eUJBQ04sS0FBSyxDQUFDLElBQUksQ0FBQzt5QkFDWCxNQUFNLENBQUMsQ0FBQyxLQUFLLEVBQUUsS0FBSyxFQUFFLEtBQUssRUFBRSxFQUFFO3dCQUM5QixJQUFJLEtBQUssS0FBSyxLQUFLLENBQUMsTUFBTSxHQUFHLENBQUMsRUFBRTs0QkFDOUIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxLQUFLLENBQUMsQ0FBQzt5QkFDeEI7d0JBQ0QsT0FBTyxJQUFJLENBQUM7b0JBQ2QsQ0FBQyxDQUFDO3lCQUNELE9BQU8sQ0FBQyxJQUFJLENBQUMsRUFBRTt3QkFDZCxXQUFXLEdBQUcsSUFBSSxDQUFDLElBQUksQ0FDckIsR0FBRyxDQUFDLEVBQUUsQ0FBQyxHQUFHLENBQUMsV0FBVyxJQUFJLENBQUMsR0FBRyxDQUFDLFlBQVksSUFBSSxHQUFHLENBQUMsV0FBVyxDQUFDLFVBQVUsS0FBSyxTQUFTLElBQUksR0FBRyxDQUFDLFdBQVcsQ0FBQyxNQUFNLEtBQUssRUFBRSxDQUN6SCxDQUFDO3dCQUNGLFlBQVksR0FBRzs0QkFDYixVQUFVLEVBQUUsU0FBUzs0QkFDckIsV0FBVyxFQUFFLElBQUk7NEJBQ2pCLFNBQVMsRUFBRSxDQUFDLEVBQUUsT0FBTyxFQUFFLElBQUksRUFBRSxNQUFNLEVBQUUsSUFBSSxFQUFFLENBQUM7NEJBQzVDLE1BQU0sRUFBRSxHQUFHO3lCQUNaLENBQUM7d0JBQ0YsSUFBSSxXQUFXLEVBQUU7NEJBQ2YsV0FBVyxDQUFDLFlBQVksR0FBRyxZQUFZLENBQUM7NEJBQ3hDLFdBQVcsQ0FBQyxXQUFXLENBQUMsU0FBUyxHQUFHLElBQUksQ0FBQyxZQUFZLENBQ25ELFdBQVcsQ0FBQyxXQUFXLENBQUMsV0FBVyxFQUNuQyxXQUFXLENBQUMsWUFBWSxDQUFDLFdBQVcsQ0FDckMsQ0FBQzs0QkFDRixXQUFXLENBQUMsWUFBWSxDQUFDLFNBQVMsR0FBRyxJQUFJLENBQUMsWUFBWSxDQUNwRCxXQUFXLENBQUMsWUFBWSxDQUFDLFdBQVcsRUFDcEMsV0FBVyxDQUFDLFdBQVcsQ0FBQyxXQUFXLENBQ3BDLENBQUM7NEJBQ0YsV0FBVyxDQUFDLFFBQVEsR0FBRyxNQUFNLENBQUM7NEJBQzlCLFdBQVcsQ0FBQyxRQUFRLEdBQUcsSUFBSSxDQUFDLFVBQVUsQ0FBQyxXQUFXLENBQUMsQ0FBQzt5QkFDckQ7NkJBQU07NEJBQ0wsSUFBSSxDQUFDLElBQUksQ0FBQztnQ0FDUixXQUFXLEVBQUUsSUFBSTtnQ0FDakIsWUFBWTtnQ0FDWixRQUFRLEVBQUUsSUFBSTtnQ0FDZCxRQUFRLEVBQUUsT0FBTztnQ0FDakIsUUFBUSxFQUFFLENBQUM7NkJBQ1osQ0FBQyxDQUFDO3lCQUNKO3dCQUNELFNBQVMsR0FBRyxTQUFTLEdBQUcsQ0FBQyxDQUFDO29CQUM1QixDQUFDLENBQUMsQ0FBQztvQkFDTCxNQUFNO2FBQ1Q7WUFDRCxPQUFPLElBQUksQ0FBQztRQUNkLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQztJQUNULENBQUM7SUFFTyxVQUFVLENBQUMsTUFBMEI7UUFDM0MsSUFBSSxTQUFTLEdBQUcsQ0FBQyxDQUFDO1FBQ2xCLElBQUksTUFBTSxDQUFDLFdBQVcsRUFBRTtZQUN0QixTQUFTLElBQUksTUFBTSxDQUFDLFdBQVcsQ0FBQyxTQUFTLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxDQUFDLE1BQU0sQ0FBQztTQUM5RTtRQUNELElBQUksTUFBTSxDQUFDLFdBQVcsRUFBRTtZQUN0QixTQUFTLElBQUksTUFBTSxDQUFDLFlBQVksQ0FBQyxTQUFTLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxDQUFDLE1BQU0sQ0FBQztTQUMvRTtRQUNELE9BQU8sU0FBUyxDQUFDO0lBQ25CLENBQUM7SUFFTyxZQUFZLENBQUMsS0FBYSxFQUFFLFlBQW9CO1FBQ3RELE1BQU0sU0FBUyxHQUFlLEVBQUUsQ0FBQztRQUNqQyxJQUFJLENBQUMsR0FBRyxDQUFDLENBQUM7UUFDVixJQUFJLENBQUMsR0FBRyxDQUFDLENBQUM7UUFDVixJQUFJLE1BQU0sR0FBRyxFQUFFLENBQUM7UUFDaEIsSUFBSSxJQUFJLEdBQUcsRUFBRSxDQUFDO1FBRWQsT0FBTyxDQUFDLEdBQUcsS0FBSyxDQUFDLE1BQU0sRUFBRTtZQUN2QixJQUFJLEtBQUssQ0FBQyxDQUFDLENBQUMsS0FBSyxZQUFZLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxHQUFHLFlBQVksQ0FBQyxNQUFNLEVBQUU7Z0JBQzNELElBQUksSUFBSSxLQUFLLEVBQUUsRUFBRTtvQkFDZixTQUFTLENBQUMsSUFBSSxDQUFDLEVBQUUsT0FBTyxFQUFFLElBQUksRUFBRSxNQUFNLEVBQUUsSUFBSSxFQUFFLENBQUMsQ0FBQztvQkFDaEQsSUFBSSxHQUFHLEVBQUUsQ0FBQztpQkFDWDtnQkFDRCxNQUFNLElBQUksS0FBSyxDQUFDLENBQUMsQ0FBQyxDQUFDO2FBQ3BCO2lCQUFNO2dCQUNMLElBQUksTUFBTSxLQUFLLEVBQUUsRUFBRTtvQkFDakIsU0FBUyxDQUFDLElBQUksQ0FBQyxFQUFFLE9BQU8sRUFBRSxNQUFNLEVBQUUsTUFBTSxFQUFFLEtBQUssRUFBRSxDQUFDLENBQUM7b0JBQ25ELE1BQU0sR0FBRyxFQUFFLENBQUM7aUJBQ2I7Z0JBQ0QsSUFBSSxJQUFJLEtBQUssQ0FBQyxDQUFDLENBQUMsQ0FBQzthQUNsQjtZQUNELENBQUMsRUFBRSxDQUFDO1lBQ0osQ0FBQyxFQUFFLENBQUM7U0FDTDtRQUVELElBQUksSUFBSSxLQUFLLEVBQUUsRUFBRTtZQUNmLFNBQVMsQ0FBQyxJQUFJLENBQUMsRUFBRSxPQUFPLEVBQUUsSUFBSSxFQUFFLE1BQU0sRUFBRSxJQUFJLEVBQUUsQ0FBQyxDQUFDO1NBQ2pEO2FBQU0sSUFBSSxNQUFNLEtBQUssRUFBRSxFQUFFO1lBQ3hCLFNBQVMsQ0FBQyxJQUFJLENBQUMsRUFBRSxPQUFPLEVBQUUsTUFBTSxFQUFFLE1BQU0sRUFBRSxLQUFLLEVBQUUsQ0FBQyxDQUFDO1NBQ3BEO1FBRUQsT0FBTyxTQUFTLENBQUM7SUFDbkIsQ0FBQztDQUNGLENBQUE7O0FBcE5ZLGtCQUFrQjtJQUg5QixVQUFVLENBQUM7UUFDVixVQUFVLEVBQUUsTUFBTTtLQUNuQixDQUFDOztHQUNXLGtCQUFrQixDQW9OOUI7U0FwTlksa0JBQWtCIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgSW5qZWN0YWJsZSB9IGZyb20gJ0Bhbmd1bGFyL2NvcmUnO1xyXG5pbXBvcnQgeyBEaWZmLCBESUZGX0RFTEVURSwgRElGRl9FUVVBTCwgRElGRl9JTlNFUlQsIGRpZmZfbWF0Y2hfcGF0Y2ggfSBmcm9tICdkaWZmLW1hdGNoLXBhdGNoJztcclxuaW1wb3J0IHsgRGlmZkxpbmVSZXN1bHQsIERpZmZQYXJ0LCBEaWZmVGFibGVSb3dSZXN1bHQgfSBmcm9tICcuL25neC10ZXh0LWRpZmYubW9kZWwnO1xyXG5pbXBvcnQgeyBpc0VtcHR5LCBpc05pbCB9IGZyb20gJy4vbmd4LXRleHQtZGlmZi51dGlscyc7XHJcblxyXG5ASW5qZWN0YWJsZSh7XHJcbiAgcHJvdmlkZWRJbjogJ3Jvb3QnXHJcbn0pXHJcbmV4cG9ydCBjbGFzcyBOZ3hUZXh0RGlmZlNlcnZpY2Uge1xyXG4gIGRpZmZQYXJzZXI6IGRpZmZfbWF0Y2hfcGF0Y2g7XHJcblxyXG4gIGNvbnN0cnVjdG9yKCkge1xyXG4gICAgdGhpcy5pbml0UGFyc2VyKCk7XHJcbiAgfVxyXG5cclxuICBwcml2YXRlIGluaXRQYXJzZXIoKSB7XHJcbiAgICB0aGlzLmRpZmZQYXJzZXIgPSBuZXcgZGlmZl9tYXRjaF9wYXRjaCgpO1xyXG4gIH1cclxuXHJcbiAgZ2V0RGlmZnNCeUxpbmVzKGxlZnQ6IHN0cmluZywgcmlnaHQ6IHN0cmluZyk6IFByb21pc2U8RGlmZlRhYmxlUm93UmVzdWx0W10+IHtcclxuICAgIHJldHVybiBuZXcgUHJvbWlzZTxEaWZmVGFibGVSb3dSZXN1bHRbXT4oKHJlc29sdmUsIHJlamVjdCkgPT4ge1xyXG4gICAgICBjb25zdCBhID0gdGhpcy5kaWZmUGFyc2VyLmRpZmZfbGluZXNUb0NoYXJzXyhsZWZ0LCByaWdodCk7XHJcbiAgICAgIGNvbnN0IGxpbmVUZXh0MSA9IGEuY2hhcnMxO1xyXG4gICAgICBjb25zdCBsaW5lVGV4dDIgPSBhLmNoYXJzMjtcclxuICAgICAgY29uc3QgbGluZXNBcnJheSA9IGEubGluZUFycmF5O1xyXG4gICAgICBjb25zdCBkaWZmczogRGlmZltdID0gdGhpcy5kaWZmUGFyc2VyLmRpZmZfbWFpbihsaW5lVGV4dDEsIGxpbmVUZXh0MiwgdHJ1ZSk7XHJcbiAgICAgIHRoaXMuZGlmZlBhcnNlci5kaWZmX2NoYXJzVG9MaW5lc18oZGlmZnMsIGxpbmVzQXJyYXkpO1xyXG4gICAgICBjb25zdCByb3dzOiBEaWZmVGFibGVSb3dSZXN1bHRbXSA9IHRoaXMuZm9ybWF0T3V0cHV0KGRpZmZzKTtcclxuICAgICAgaWYgKCFyb3dzKSB7XHJcbiAgICAgICAgcmVqZWN0KCdFcnJvcicpO1xyXG4gICAgICB9XHJcblxyXG4gICAgICByZXNvbHZlKHJvd3MpO1xyXG4gICAgfSk7XHJcbiAgfVxyXG5cclxuICBwcml2YXRlIGZvcm1hdE91dHB1dChkaWZmczogRGlmZltdKTogRGlmZlRhYmxlUm93UmVzdWx0W10ge1xyXG4gICAgbGV0IGxpbmVMZWZ0ID0gMTtcclxuICAgIGxldCBsaW5lUmlnaHQgPSAxO1xyXG4gICAgcmV0dXJuIGRpZmZzLnJlZHVjZSgocm93czogRGlmZlRhYmxlUm93UmVzdWx0W10sIGRpZmY6IERpZmYpID0+IHtcclxuICAgICAgaWYgKCFyb3dzKSB7XHJcbiAgICAgICAgcm93cyA9IFtdO1xyXG4gICAgICB9XHJcbiAgICAgIGNvbnN0IGRpZmZUeXBlOiBudW1iZXIgPSBkaWZmWzBdO1xyXG4gICAgICBjb25zdCBkaWZmVmFsdWU6IHN0cmluZyA9IGRpZmZbMV07XHJcbiAgICAgIGxldCBsZWZ0RGlmZlJvdzogRGlmZlRhYmxlUm93UmVzdWx0ID0gbnVsbDtcclxuICAgICAgbGV0IHJpZ2h0RGlmZlJvdzogRGlmZlRhYmxlUm93UmVzdWx0ID0gbnVsbDtcclxuICAgICAgbGV0IGxlZnRDb250ZW50OiBEaWZmTGluZVJlc3VsdCA9IG51bGw7XHJcbiAgICAgIGxldCByaWdodENvbnRlbnQ6IERpZmZMaW5lUmVzdWx0ID0gbnVsbDtcclxuICAgICAgbGV0IHJvd1RlbXA6IERpZmZUYWJsZVJvd1Jlc3VsdCA9IG51bGw7XHJcbiAgICAgIHN3aXRjaCAoZGlmZlR5cGUpIHtcclxuICAgICAgICBjYXNlIERJRkZfRVFVQUw6IC8vIDBcclxuICAgICAgICAgIGRpZmZWYWx1ZVxyXG4gICAgICAgICAgICAuc3BsaXQoJ1xcbicpXHJcbiAgICAgICAgICAgIC5maWx0ZXIoKHZhbHVlLCBpbmRleCwgYXJyYXkpID0+IHtcclxuICAgICAgICAgICAgICBpZiAoaW5kZXggPT09IGFycmF5Lmxlbmd0aCAtIDEpIHtcclxuICAgICAgICAgICAgICAgIHJldHVybiAhaXNFbXB0eSh2YWx1ZSk7XHJcbiAgICAgICAgICAgICAgfVxyXG4gICAgICAgICAgICAgIHJldHVybiB0cnVlO1xyXG4gICAgICAgICAgICB9KVxyXG4gICAgICAgICAgICAuZm9yRWFjaChsaW5lID0+IHtcclxuICAgICAgICAgICAgICBsZWZ0Q29udGVudCA9IHtcclxuICAgICAgICAgICAgICAgIGxpbmVOdW1iZXI6IGxpbmVMZWZ0LFxyXG4gICAgICAgICAgICAgICAgbGluZUNvbnRlbnQ6IGxpbmUsXHJcbiAgICAgICAgICAgICAgICBsaW5lRGlmZnM6IFtdLFxyXG4gICAgICAgICAgICAgICAgcHJlZml4OiAnJ1xyXG4gICAgICAgICAgICAgIH07XHJcbiAgICAgICAgICAgICAgcmlnaHRDb250ZW50ID0ge1xyXG4gICAgICAgICAgICAgICAgbGluZU51bWJlcjogbGluZVJpZ2h0LFxyXG4gICAgICAgICAgICAgICAgbGluZUNvbnRlbnQ6IGxpbmUsXHJcbiAgICAgICAgICAgICAgICBsaW5lRGlmZnM6IFtdLFxyXG4gICAgICAgICAgICAgICAgcHJlZml4OiAnJ1xyXG4gICAgICAgICAgICAgIH07XHJcbiAgICAgICAgICAgICAgcm93VGVtcCA9IHtcclxuICAgICAgICAgICAgICAgIGxlZnRDb250ZW50LFxyXG4gICAgICAgICAgICAgICAgcmlnaHRDb250ZW50LFxyXG4gICAgICAgICAgICAgICAgYmVsb25nVG86ICdib3RoJyxcclxuICAgICAgICAgICAgICAgIGhhc0RpZmZzOiBmYWxzZSxcclxuICAgICAgICAgICAgICAgIG51bURpZmZzOiAwLFxyXG4gICAgICAgICAgICAgIH07XHJcbiAgICAgICAgICAgICAgcm93cy5wdXNoKHJvd1RlbXApO1xyXG4gICAgICAgICAgICAgIGxpbmVSaWdodCA9IGxpbmVSaWdodCArIDE7XHJcbiAgICAgICAgICAgICAgbGluZUxlZnQgPSBsaW5lTGVmdCArIDE7XHJcbiAgICAgICAgICAgIH0pO1xyXG4gICAgICAgICAgYnJlYWs7XHJcbiAgICAgICAgY2FzZSBESUZGX0RFTEVURTogLy8gLTFcclxuICAgICAgICAgIGRpZmZWYWx1ZVxyXG4gICAgICAgICAgICAuc3BsaXQoJ1xcbicpXHJcbiAgICAgICAgICAgIC5maWx0ZXIoKHZhbHVlLCBpbmRleCwgYXJyYXkpID0+IHtcclxuICAgICAgICAgICAgICBpZiAoaW5kZXggPT09IGFycmF5Lmxlbmd0aCAtIDEpIHtcclxuICAgICAgICAgICAgICAgIHJldHVybiAhaXNFbXB0eSh2YWx1ZSk7XHJcbiAgICAgICAgICAgICAgfVxyXG4gICAgICAgICAgICAgIHJldHVybiB0cnVlO1xyXG4gICAgICAgICAgICB9KVxyXG4gICAgICAgICAgICAuZm9yRWFjaChsaW5lID0+IHtcclxuICAgICAgICAgICAgICByaWdodERpZmZSb3cgPSByb3dzLmZpbmQoXHJcbiAgICAgICAgICAgICAgICByb3cgPT4gIXJvdy5sZWZ0Q29udGVudCAmJiByb3cucmlnaHRDb250ZW50ICYmIHJvdy5yaWdodENvbnRlbnQubGluZU51bWJlciA9PT0gbGluZUxlZnQgJiYgcm93LnJpZ2h0Q29udGVudC5wcmVmaXggIT09ICcnXHJcbiAgICAgICAgICAgICAgKTtcclxuICAgICAgICAgICAgICBsZWZ0Q29udGVudCA9IHtcclxuICAgICAgICAgICAgICAgIGxpbmVOdW1iZXI6IGxpbmVMZWZ0LFxyXG4gICAgICAgICAgICAgICAgbGluZUNvbnRlbnQ6IGxpbmUsXHJcbiAgICAgICAgICAgICAgICBsaW5lRGlmZnM6IFt7IGNvbnRlbnQ6IGxpbmUsIGlzRGlmZjogdHJ1ZSB9XSxcclxuICAgICAgICAgICAgICAgIHByZWZpeDogJy0nXHJcbiAgICAgICAgICAgICAgfTtcclxuICAgICAgICAgICAgICBpZiAocmlnaHREaWZmUm93KSB7XHJcbiAgICAgICAgICAgICAgICByaWdodERpZmZSb3cubGVmdENvbnRlbnQgPSBsZWZ0Q29udGVudDtcclxuICAgICAgICAgICAgICAgIHJpZ2h0RGlmZlJvdy5sZWZ0Q29udGVudC5saW5lRGlmZnMgPSB0aGlzLmdldERpZmZQYXJ0cyhcclxuICAgICAgICAgICAgICAgICAgcmlnaHREaWZmUm93LmxlZnRDb250ZW50LmxpbmVDb250ZW50LFxyXG4gICAgICAgICAgICAgICAgICByaWdodERpZmZSb3cucmlnaHRDb250ZW50LmxpbmVDb250ZW50XHJcbiAgICAgICAgICAgICAgICApO1xyXG4gICAgICAgICAgICAgICAgcmlnaHREaWZmUm93LnJpZ2h0Q29udGVudC5saW5lRGlmZnMgPSB0aGlzLmdldERpZmZQYXJ0cyhcclxuICAgICAgICAgICAgICAgICAgcmlnaHREaWZmUm93LnJpZ2h0Q29udGVudC5saW5lQ29udGVudCxcclxuICAgICAgICAgICAgICAgICAgcmlnaHREaWZmUm93LmxlZnRDb250ZW50LmxpbmVDb250ZW50XHJcbiAgICAgICAgICAgICAgICApO1xyXG4gICAgICAgICAgICAgICAgcmlnaHREaWZmUm93LmJlbG9uZ1RvID0gJ2JvdGgnO1xyXG4gICAgICAgICAgICAgICAgcmlnaHREaWZmUm93Lm51bURpZmZzID0gdGhpcy5jb3VudERpZmZzKHJpZ2h0RGlmZlJvdyk7XHJcbiAgICAgICAgICAgICAgfSBlbHNlIHtcclxuICAgICAgICAgICAgICAgIHJvd3MucHVzaCh7XHJcbiAgICAgICAgICAgICAgICAgIGxlZnRDb250ZW50LFxyXG4gICAgICAgICAgICAgICAgICByaWdodENvbnRlbnQ6IG51bGwsXHJcbiAgICAgICAgICAgICAgICAgIGhhc0RpZmZzOiB0cnVlLFxyXG4gICAgICAgICAgICAgICAgICBiZWxvbmdUbzogJ2xlZnQnLFxyXG4gICAgICAgICAgICAgICAgICBudW1EaWZmczogMSxcclxuICAgICAgICAgICAgICAgIH0pO1xyXG4gICAgICAgICAgICAgIH1cclxuICAgICAgICAgICAgICBsaW5lTGVmdCA9IGxpbmVMZWZ0ICsgMTtcclxuICAgICAgICAgICAgfSk7XHJcbiAgICAgICAgICBicmVhaztcclxuICAgICAgICBjYXNlIERJRkZfSU5TRVJUOiAvLyAxXHJcbiAgICAgICAgICBkaWZmVmFsdWVcclxuICAgICAgICAgICAgLnNwbGl0KCdcXG4nKVxyXG4gICAgICAgICAgICAuZmlsdGVyKCh2YWx1ZSwgaW5kZXgsIGFycmF5KSA9PiB7XHJcbiAgICAgICAgICAgICAgaWYgKGluZGV4ID09PSBhcnJheS5sZW5ndGggLSAxKSB7XHJcbiAgICAgICAgICAgICAgICByZXR1cm4gIWlzRW1wdHkodmFsdWUpO1xyXG4gICAgICAgICAgICAgIH1cclxuICAgICAgICAgICAgICByZXR1cm4gdHJ1ZTtcclxuICAgICAgICAgICAgfSlcclxuICAgICAgICAgICAgLmZvckVhY2gobGluZSA9PiB7XHJcbiAgICAgICAgICAgICAgbGVmdERpZmZSb3cgPSByb3dzLmZpbmQoXHJcbiAgICAgICAgICAgICAgICByb3cgPT4gcm93LmxlZnRDb250ZW50ICYmICFyb3cucmlnaHRDb250ZW50ICYmIHJvdy5sZWZ0Q29udGVudC5saW5lTnVtYmVyID09PSBsaW5lUmlnaHQgJiYgcm93LmxlZnRDb250ZW50LnByZWZpeCAhPT0gJydcclxuICAgICAgICAgICAgICApO1xyXG4gICAgICAgICAgICAgIHJpZ2h0Q29udGVudCA9IHtcclxuICAgICAgICAgICAgICAgIGxpbmVOdW1iZXI6IGxpbmVSaWdodCxcclxuICAgICAgICAgICAgICAgIGxpbmVDb250ZW50OiBsaW5lLFxyXG4gICAgICAgICAgICAgICAgbGluZURpZmZzOiBbeyBjb250ZW50OiBsaW5lLCBpc0RpZmY6IHRydWUgfV0sXHJcbiAgICAgICAgICAgICAgICBwcmVmaXg6ICcrJ1xyXG4gICAgICAgICAgICAgIH07XHJcbiAgICAgICAgICAgICAgaWYgKGxlZnREaWZmUm93KSB7XHJcbiAgICAgICAgICAgICAgICBsZWZ0RGlmZlJvdy5yaWdodENvbnRlbnQgPSByaWdodENvbnRlbnQ7XHJcbiAgICAgICAgICAgICAgICBsZWZ0RGlmZlJvdy5sZWZ0Q29udGVudC5saW5lRGlmZnMgPSB0aGlzLmdldERpZmZQYXJ0cyhcclxuICAgICAgICAgICAgICAgICAgbGVmdERpZmZSb3cubGVmdENvbnRlbnQubGluZUNvbnRlbnQsXHJcbiAgICAgICAgICAgICAgICAgIGxlZnREaWZmUm93LnJpZ2h0Q29udGVudC5saW5lQ29udGVudFxyXG4gICAgICAgICAgICAgICAgKTtcclxuICAgICAgICAgICAgICAgIGxlZnREaWZmUm93LnJpZ2h0Q29udGVudC5saW5lRGlmZnMgPSB0aGlzLmdldERpZmZQYXJ0cyhcclxuICAgICAgICAgICAgICAgICAgbGVmdERpZmZSb3cucmlnaHRDb250ZW50LmxpbmVDb250ZW50LFxyXG4gICAgICAgICAgICAgICAgICBsZWZ0RGlmZlJvdy5sZWZ0Q29udGVudC5saW5lQ29udGVudFxyXG4gICAgICAgICAgICAgICAgKTtcclxuICAgICAgICAgICAgICAgIGxlZnREaWZmUm93LmJlbG9uZ1RvID0gJ2JvdGgnO1xyXG4gICAgICAgICAgICAgICAgbGVmdERpZmZSb3cubnVtRGlmZnMgPSB0aGlzLmNvdW50RGlmZnMobGVmdERpZmZSb3cpO1xyXG4gICAgICAgICAgICAgIH0gZWxzZSB7XHJcbiAgICAgICAgICAgICAgICByb3dzLnB1c2goe1xyXG4gICAgICAgICAgICAgICAgICBsZWZ0Q29udGVudDogbnVsbCxcclxuICAgICAgICAgICAgICAgICAgcmlnaHRDb250ZW50LFxyXG4gICAgICAgICAgICAgICAgICBoYXNEaWZmczogdHJ1ZSxcclxuICAgICAgICAgICAgICAgICAgYmVsb25nVG86ICdyaWdodCcsXHJcbiAgICAgICAgICAgICAgICAgIG51bURpZmZzOiAxLFxyXG4gICAgICAgICAgICAgICAgfSk7XHJcbiAgICAgICAgICAgICAgfVxyXG4gICAgICAgICAgICAgIGxpbmVSaWdodCA9IGxpbmVSaWdodCArIDE7XHJcbiAgICAgICAgICAgIH0pO1xyXG4gICAgICAgICAgYnJlYWs7XHJcbiAgICAgIH1cclxuICAgICAgcmV0dXJuIHJvd3M7XHJcbiAgICB9LCBbXSk7XHJcbiAgfVxyXG5cclxuICBwcml2YXRlIGNvdW50RGlmZnMocmVzdWx0OiBEaWZmVGFibGVSb3dSZXN1bHQpOiBudW1iZXIge1xyXG4gICAgbGV0IGRpZmZDb3VudCA9IDA7XHJcbiAgICBpZiAocmVzdWx0LmxlZnRDb250ZW50KSB7XHJcbiAgICAgIGRpZmZDb3VudCArPSByZXN1bHQubGVmdENvbnRlbnQubGluZURpZmZzLmZpbHRlcihkaWZmID0+IGRpZmYuaXNEaWZmKS5sZW5ndGg7XHJcbiAgICB9XHJcbiAgICBpZiAocmVzdWx0LmxlZnRDb250ZW50KSB7XHJcbiAgICAgIGRpZmZDb3VudCArPSByZXN1bHQucmlnaHRDb250ZW50LmxpbmVEaWZmcy5maWx0ZXIoZGlmZiA9PiBkaWZmLmlzRGlmZikubGVuZ3RoO1xyXG4gICAgfVxyXG4gICAgcmV0dXJuIGRpZmZDb3VudDtcclxuICB9XHJcblxyXG4gIHByaXZhdGUgZ2V0RGlmZlBhcnRzKHZhbHVlOiBzdHJpbmcsIGNvbXBhcmVWYWx1ZTogc3RyaW5nKTogRGlmZlBhcnRbXSB7XHJcbiAgICBjb25zdCBkaWZmUGFydHM6IERpZmZQYXJ0W10gPSBbXTtcclxuICAgIGxldCBpID0gMDtcclxuICAgIGxldCBqID0gMDtcclxuICAgIGxldCBzaGFyZWQgPSAnJztcclxuICAgIGxldCBkaWZmID0gJyc7XHJcblxyXG4gICAgd2hpbGUgKGkgPCB2YWx1ZS5sZW5ndGgpIHtcclxuICAgICAgaWYgKHZhbHVlW2ldID09PSBjb21wYXJlVmFsdWVbal0gJiYgaiA8IGNvbXBhcmVWYWx1ZS5sZW5ndGgpIHtcclxuICAgICAgICBpZiAoZGlmZiAhPT0gJycpIHtcclxuICAgICAgICAgIGRpZmZQYXJ0cy5wdXNoKHsgY29udGVudDogZGlmZiwgaXNEaWZmOiB0cnVlIH0pO1xyXG4gICAgICAgICAgZGlmZiA9ICcnO1xyXG4gICAgICAgIH1cclxuICAgICAgICBzaGFyZWQgKz0gdmFsdWVbaV07XHJcbiAgICAgIH0gZWxzZSB7XHJcbiAgICAgICAgaWYgKHNoYXJlZCAhPT0gJycpIHtcclxuICAgICAgICAgIGRpZmZQYXJ0cy5wdXNoKHsgY29udGVudDogc2hhcmVkLCBpc0RpZmY6IGZhbHNlIH0pO1xyXG4gICAgICAgICAgc2hhcmVkID0gJyc7XHJcbiAgICAgICAgfVxyXG4gICAgICAgIGRpZmYgKz0gdmFsdWVbaV07XHJcbiAgICAgIH1cclxuICAgICAgaSsrO1xyXG4gICAgICBqKys7XHJcbiAgICB9XHJcblxyXG4gICAgaWYgKGRpZmYgIT09ICcnKSB7XHJcbiAgICAgIGRpZmZQYXJ0cy5wdXNoKHsgY29udGVudDogZGlmZiwgaXNEaWZmOiB0cnVlIH0pO1xyXG4gICAgfSBlbHNlIGlmIChzaGFyZWQgIT09ICcnKSB7XHJcbiAgICAgIGRpZmZQYXJ0cy5wdXNoKHsgY29udGVudDogc2hhcmVkLCBpc0RpZmY6IGZhbHNlIH0pO1xyXG4gICAgfVxyXG5cclxuICAgIHJldHVybiBkaWZmUGFydHM7XHJcbiAgfVxyXG59XHJcbiJdfQ==