import { __decorate, __metadata, __awaiter, __generator } from 'tslib';
import { ɵɵdefineInjectable, Injectable, ElementRef, Input, Directive, EventEmitter, ChangeDetectorRef, ViewChildren, QueryList, Output, Component, Pipe, NgModule } from '@angular/core';
import { diff_match_patch, DIFF_INSERT, DIFF_DELETE, DIFF_EQUAL } from 'diff-match-patch';
import { Observable } from 'rxjs';
import { ScrollDispatcher, ScrollingModule } from '@angular/cdk/scrolling';
import { CommonModule } from '@angular/common';
import { FormsModule } from '@angular/forms';

var isNil = function (val) { return val === undefined || val === null; };
var isEmpty = function (val) { return val == null || !(Object.keys(val) || val).length || (Object.keys(val) || val).length === 0; };

var NgxTextDiffService = /** @class */ (function () {
    function NgxTextDiffService() {
        this.initParser();
    }
    NgxTextDiffService.prototype.initParser = function () {
        this.diffParser = new diff_match_patch();
    };
    NgxTextDiffService.prototype.getDiffsByLines = function (left, right) {
        var _this = this;
        return new Promise(function (resolve, reject) {
            var a = _this.diffParser.diff_linesToChars_(left, right);
            var lineText1 = a.chars1;
            var lineText2 = a.chars2;
            var linesArray = a.lineArray;
            var diffs = _this.diffParser.diff_main(lineText1, lineText2, true);
            _this.diffParser.diff_charsToLines_(diffs, linesArray);
            var rows = _this.formatOutput(diffs);
            if (!rows) {
                reject('Error');
            }
            resolve(rows);
        });
    };
    NgxTextDiffService.prototype.formatOutput = function (diffs) {
        var _this = this;
        var lineLeft = 1;
        var lineRight = 1;
        return diffs.reduce(function (rows, diff) {
            if (!rows) {
                rows = [];
            }
            var diffType = diff[0];
            var diffValue = diff[1];
            var leftDiffRow = null;
            var rightDiffRow = null;
            var leftContent = null;
            var rightContent = null;
            var rowTemp = null;
            switch (diffType) {
                case DIFF_EQUAL: // 0
                    diffValue
                        .split('\n')
                        .filter(function (value, index, array) {
                        if (index === array.length - 1) {
                            return !isEmpty(value);
                        }
                        return true;
                    })
                        .forEach(function (line) {
                        leftContent = {
                            lineNumber: lineLeft,
                            lineContent: line,
                            lineDiffs: [],
                            prefix: ''
                        };
                        rightContent = {
                            lineNumber: lineRight,
                            lineContent: line,
                            lineDiffs: [],
                            prefix: ''
                        };
                        rowTemp = {
                            leftContent: leftContent,
                            rightContent: rightContent,
                            belongTo: 'both',
                            hasDiffs: false,
                            numDiffs: 0,
                        };
                        rows.push(rowTemp);
                        lineRight = lineRight + 1;
                        lineLeft = lineLeft + 1;
                    });
                    break;
                case DIFF_DELETE: // -1
                    diffValue
                        .split('\n')
                        .filter(function (value, index, array) {
                        if (index === array.length - 1) {
                            return !isEmpty(value);
                        }
                        return true;
                    })
                        .forEach(function (line) {
                        rightDiffRow = rows.find(function (row) { return !row.leftContent && row.rightContent && row.rightContent.lineNumber === lineLeft && row.rightContent.prefix !== ''; });
                        leftContent = {
                            lineNumber: lineLeft,
                            lineContent: line,
                            lineDiffs: [{ content: line, isDiff: true }],
                            prefix: '-'
                        };
                        if (rightDiffRow) {
                            rightDiffRow.leftContent = leftContent;
                            rightDiffRow.leftContent.lineDiffs = _this.getDiffParts(rightDiffRow.leftContent.lineContent, rightDiffRow.rightContent.lineContent);
                            rightDiffRow.rightContent.lineDiffs = _this.getDiffParts(rightDiffRow.rightContent.lineContent, rightDiffRow.leftContent.lineContent);
                            rightDiffRow.belongTo = 'both';
                            rightDiffRow.numDiffs = _this.countDiffs(rightDiffRow);
                        }
                        else {
                            rows.push({
                                leftContent: leftContent,
                                rightContent: null,
                                hasDiffs: true,
                                belongTo: 'left',
                                numDiffs: 1,
                            });
                        }
                        lineLeft = lineLeft + 1;
                    });
                    break;
                case DIFF_INSERT: // 1
                    diffValue
                        .split('\n')
                        .filter(function (value, index, array) {
                        if (index === array.length - 1) {
                            return !isEmpty(value);
                        }
                        return true;
                    })
                        .forEach(function (line) {
                        leftDiffRow = rows.find(function (row) { return row.leftContent && !row.rightContent && row.leftContent.lineNumber === lineRight && row.leftContent.prefix !== ''; });
                        rightContent = {
                            lineNumber: lineRight,
                            lineContent: line,
                            lineDiffs: [{ content: line, isDiff: true }],
                            prefix: '+'
                        };
                        if (leftDiffRow) {
                            leftDiffRow.rightContent = rightContent;
                            leftDiffRow.leftContent.lineDiffs = _this.getDiffParts(leftDiffRow.leftContent.lineContent, leftDiffRow.rightContent.lineContent);
                            leftDiffRow.rightContent.lineDiffs = _this.getDiffParts(leftDiffRow.rightContent.lineContent, leftDiffRow.leftContent.lineContent);
                            leftDiffRow.belongTo = 'both';
                            leftDiffRow.numDiffs = _this.countDiffs(leftDiffRow);
                        }
                        else {
                            rows.push({
                                leftContent: null,
                                rightContent: rightContent,
                                hasDiffs: true,
                                belongTo: 'right',
                                numDiffs: 1,
                            });
                        }
                        lineRight = lineRight + 1;
                    });
                    break;
            }
            return rows;
        }, []);
    };
    NgxTextDiffService.prototype.countDiffs = function (result) {
        var diffCount = 0;
        if (result.leftContent) {
            diffCount += result.leftContent.lineDiffs.filter(function (diff) { return diff.isDiff; }).length;
        }
        if (result.leftContent) {
            diffCount += result.rightContent.lineDiffs.filter(function (diff) { return diff.isDiff; }).length;
        }
        return diffCount;
    };
    NgxTextDiffService.prototype.getDiffParts = function (value, compareValue) {
        var diffParts = [];
        var i = 0;
        var j = 0;
        var shared = '';
        var diff = '';
        while (i < value.length) {
            if (value[i] === compareValue[j] && j < compareValue.length) {
                if (diff !== '') {
                    diffParts.push({ content: diff, isDiff: true });
                    diff = '';
                }
                shared += value[i];
            }
            else {
                if (shared !== '') {
                    diffParts.push({ content: shared, isDiff: false });
                    shared = '';
                }
                diff += value[i];
            }
            i++;
            j++;
        }
        if (diff !== '') {
            diffParts.push({ content: diff, isDiff: true });
        }
        else if (shared !== '') {
            diffParts.push({ content: shared, isDiff: false });
        }
        return diffParts;
    };
    NgxTextDiffService.ɵprov = ɵɵdefineInjectable({ factory: function NgxTextDiffService_Factory() { return new NgxTextDiffService(); }, token: NgxTextDiffService, providedIn: "root" });
    NgxTextDiffService = __decorate([
        Injectable({
            providedIn: 'root'
        }),
        __metadata("design:paramtypes", [])
    ], NgxTextDiffService);
    return NgxTextDiffService;
}());

var ContainerDirective = /** @class */ (function () {
    function ContainerDirective(_el) {
        this._el = _el;
        this.element = _el.nativeElement;
    }
    ContainerDirective.ctorParameters = function () { return [
        { type: ElementRef }
    ]; };
    __decorate([
        Input(),
        __metadata("design:type", String)
    ], ContainerDirective.prototype, "id", void 0);
    ContainerDirective = __decorate([
        Directive({
            selector: '[tdContainer]',
        }),
        __metadata("design:paramtypes", [ElementRef])
    ], ContainerDirective);
    return ContainerDirective;
}());

var NgxTextDiffComponent = /** @class */ (function () {
    function NgxTextDiffComponent(scrollService, diff, cd) {
        this.scrollService = scrollService;
        this.diff = diff;
        this.cd = cd;
        this._hideMatchingLines = false;
        this.format = 'SideBySide';
        this.left = '';
        this.right = '';
        this.loading = false;
        this.showToolbar = true;
        this.showBtnToolbar = true;
        this.synchronizeScrolling = true;
        this.compareResults = new EventEmitter();
        this.subscriptions = [];
        this.tableRows = [];
        this.filteredTableRows = [];
        this.tableRowsLineByLine = [];
        this.filteredTableRowsLineByLine = [];
        this.diffsCount = 0;
        this.formatOptions = [
            {
                id: 'side-by-side',
                name: 'side-by-side',
                label: 'Side by Side',
                value: 'SideBySide',
                icon: 'la-code',
            },
            {
                id: 'line-by-line',
                name: 'line-by-line',
                label: 'Line by Line',
                value: 'LineByLine',
                icon: 'la-file-text',
            },
        ];
    }
    Object.defineProperty(NgxTextDiffComponent.prototype, "hideMatchingLines", {
        get: function () {
            return this._hideMatchingLines;
        },
        set: function (hide) {
            this.hideMatchingLinesChanged(hide);
        },
        enumerable: true,
        configurable: true
    });
    NgxTextDiffComponent.prototype.ngOnInit = function () {
        var _this = this;
        this.loading = true;
        if (this.diffContent) {
            this.subscriptions.push(this.diffContent.subscribe(function (content) {
                _this.loading = true;
                _this.left = content.leftContent;
                _this.right = content.rightContent;
                _this.renderDiffs()
                    .then(function () {
                    _this.cd.detectChanges();
                    _this.loading = false;
                })
                    .catch(function () { return (_this.loading = false); });
            }));
        }
        this.renderDiffs()
            .then(function () { return (_this.loading = false); })
            .catch(function (e) { return (_this.loading = false); });
    };
    NgxTextDiffComponent.prototype.ngAfterViewInit = function () {
        this.initScrollListener();
    };
    NgxTextDiffComponent.prototype.ngOnDestroy = function () {
        if (this.subscriptions) {
            this.subscriptions.forEach(function (subscription) { return subscription.unsubscribe(); });
        }
    };
    NgxTextDiffComponent.prototype.hideMatchingLinesChanged = function (value) {
        this._hideMatchingLines = value;
        if (this.hideMatchingLines) {
            this.filteredTableRows = this.tableRows.filter(function (row) { return (row.leftContent && row.leftContent.prefix === '-') || (row.rightContent && row.rightContent.prefix === '+'); });
            this.filteredTableRowsLineByLine = this.tableRowsLineByLine.filter(function (row) { return (row.leftContent && row.leftContent.prefix === '-') || (row.rightContent && row.rightContent.prefix === '+'); });
        }
        else {
            this.filteredTableRows = this.tableRows;
            this.filteredTableRowsLineByLine = this.tableRowsLineByLine;
        }
    };
    NgxTextDiffComponent.prototype.setDiffTableFormat = function (format) {
        this.format = format;
    };
    NgxTextDiffComponent.prototype.renderDiffs = function () {
        return __awaiter(this, void 0, void 0, function () {
            var _a, e_1;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        _b.trys.push([0, 2, , 3]);
                        this.diffsCount = 0;
                        _a = this;
                        return [4 /*yield*/, this.diff.getDiffsByLines(this.left, this.right)];
                    case 1:
                        _a.tableRows = _b.sent();
                        this.tableRowsLineByLine = this.tableRows.reduce(function (tableLineByLine, row) {
                            if (!tableLineByLine) {
                                tableLineByLine = [];
                            }
                            if (row.hasDiffs) {
                                if (row.leftContent) {
                                    tableLineByLine.push({
                                        leftContent: row.leftContent,
                                        rightContent: null,
                                        belongTo: row.belongTo,
                                        hasDiffs: true,
                                        numDiffs: row.numDiffs,
                                    });
                                }
                                if (row.rightContent) {
                                    tableLineByLine.push({
                                        leftContent: null,
                                        rightContent: row.rightContent,
                                        belongTo: row.belongTo,
                                        hasDiffs: true,
                                        numDiffs: row.numDiffs,
                                    });
                                }
                            }
                            else {
                                tableLineByLine.push(row);
                            }
                            return tableLineByLine;
                        }, []);
                        this.diffsCount = this.tableRows.filter(function (row) { return row.hasDiffs; }).length;
                        this.filteredTableRows = this.tableRows;
                        this.filteredTableRowsLineByLine = this.tableRowsLineByLine;
                        this.emitCompareResultsEvent();
                        return [3 /*break*/, 3];
                    case 2:
                        e_1 = _b.sent();
                        throw e_1;
                    case 3: return [2 /*return*/];
                }
            });
        });
    };
    NgxTextDiffComponent.prototype.emitCompareResultsEvent = function () {
        var diffResults = {
            hasDiff: this.diffsCount > 0,
            diffsCount: this.diffsCount,
            rowsWithDiff: this.tableRows
                .filter(function (row) { return row.hasDiffs; })
                .map(function (row) { return ({
                leftLineNumber: row.leftContent ? row.leftContent.lineNumber : null,
                rightLineNumber: row.rightContent ? row.rightContent.lineNumber : null,
                numDiffs: row.numDiffs,
            }); }),
        };
        this.compareResults.next(diffResults);
    };
    NgxTextDiffComponent.prototype.trackTableRows = function (index, row) {
        return row && row.leftContent ? row.leftContent.lineContent : row && row.rightContent ? row.rightContent.lineContent : undefined;
    };
    NgxTextDiffComponent.prototype.trackDiffs = function (index, diff) {
        return diff && diff.content ? diff.content : undefined;
    };
    NgxTextDiffComponent.prototype.initScrollListener = function () {
        var _this = this;
        this.subscriptions.push(this.scrollService.scrolled().subscribe(function (scrollableEv) {
            if (scrollableEv && _this.synchronizeScrolling) {
                var scrollableId_1 = scrollableEv.getElementRef().nativeElement.id;
                var nonScrolledContainer = _this.containers.find(function (container) { return container.id !== scrollableId_1; });
                if (nonScrolledContainer) {
                    nonScrolledContainer.element.scrollTo({
                        top: scrollableEv.measureScrollOffset('top'),
                        left: scrollableEv.measureScrollOffset('left'),
                    });
                }
            }
        }));
    };
    NgxTextDiffComponent.ctorParameters = function () { return [
        { type: ScrollDispatcher },
        { type: NgxTextDiffService },
        { type: ChangeDetectorRef }
    ]; };
    __decorate([
        ViewChildren(ContainerDirective),
        __metadata("design:type", QueryList)
    ], NgxTextDiffComponent.prototype, "containers", void 0);
    __decorate([
        Input(),
        __metadata("design:type", String)
    ], NgxTextDiffComponent.prototype, "format", void 0);
    __decorate([
        Input(),
        __metadata("design:type", Object)
    ], NgxTextDiffComponent.prototype, "left", void 0);
    __decorate([
        Input(),
        __metadata("design:type", Object)
    ], NgxTextDiffComponent.prototype, "right", void 0);
    __decorate([
        Input(),
        __metadata("design:type", Observable)
    ], NgxTextDiffComponent.prototype, "diffContent", void 0);
    __decorate([
        Input(),
        __metadata("design:type", Object)
    ], NgxTextDiffComponent.prototype, "loading", void 0);
    __decorate([
        Input(),
        __metadata("design:type", Object)
    ], NgxTextDiffComponent.prototype, "showToolbar", void 0);
    __decorate([
        Input(),
        __metadata("design:type", Object)
    ], NgxTextDiffComponent.prototype, "showBtnToolbar", void 0);
    __decorate([
        Input(),
        __metadata("design:type", Boolean),
        __metadata("design:paramtypes", [Boolean])
    ], NgxTextDiffComponent.prototype, "hideMatchingLines", null);
    __decorate([
        Input(),
        __metadata("design:type", String)
    ], NgxTextDiffComponent.prototype, "outerContainerClass", void 0);
    __decorate([
        Input(),
        __metadata("design:type", Object)
    ], NgxTextDiffComponent.prototype, "outerContainerStyle", void 0);
    __decorate([
        Input(),
        __metadata("design:type", String)
    ], NgxTextDiffComponent.prototype, "toolbarClass", void 0);
    __decorate([
        Input(),
        __metadata("design:type", Object)
    ], NgxTextDiffComponent.prototype, "toolbarStyle", void 0);
    __decorate([
        Input(),
        __metadata("design:type", String)
    ], NgxTextDiffComponent.prototype, "compareRowsClass", void 0);
    __decorate([
        Input(),
        __metadata("design:type", Object)
    ], NgxTextDiffComponent.prototype, "compareRowsStyle", void 0);
    __decorate([
        Input(),
        __metadata("design:type", Object)
    ], NgxTextDiffComponent.prototype, "synchronizeScrolling", void 0);
    __decorate([
        Output(),
        __metadata("design:type", Object)
    ], NgxTextDiffComponent.prototype, "compareResults", void 0);
    NgxTextDiffComponent = __decorate([
        Component({
            selector: 'td-ngx-text-diff',
            template: "<td-loader-spinner [active]=\"loading\"></td-loader-spinner>\r\n<div class=\"td-wrapper\" [ngClass]=\"outerContainerClass\" [ngStyle]=\"outerContainerStyle\" *ngIf=\"!loading\">\r\n\r\n  <div [ngClass]=\"toolbarClass\" [ngStyle]=\"toolbarStyle\" *ngIf=\"showToolbar\">\r\n    <div class=\"td-toolbar-show-diff\">\r\n      <label class=\"td-checkbox-container\">\r\n        Only Show Lines with Differences ({{ diffsCount }})\r\n        <input type=\"checkbox\" id=\"showDiffs\" [ngModel]=\"hideMatchingLines\" (ngModelChange)=\"hideMatchingLinesChanged($event)\" />\r\n        <span class=\"checkmark\"></span>\r\n      </label>\r\n    </div>\r\n  </div>\r\n\r\n  <div class=\"td-toolbar-select-format\" *ngIf=\"showToolbar && showBtnToolbar\">\r\n    <div class=\"td-btn-group td-btn-group-toggle\" data-toggle=\"buttons\">\r\n      <button\r\n        *ngFor=\"let option of formatOptions\"\r\n        [ngClass]=\"{ active: format === option.value, disabled: !!option.disabled }\"\r\n        [name]=\"option.name\"\r\n        [id]=\"option.id\"\r\n        [disabled]=\"!!option.disabled\"\r\n        (click)=\"setDiffTableFormat(option.value)\"\r\n      >\r\n        {{ option.label }}\r\n      </button>\r\n    </div>\r\n  </div>\r\n\r\n  <div class=\"td-table-wrapper\" [ngClass]=\"compareRowsClass\" [ngStyle]=\"compareRowsStyle\">\r\n    <!-- Right side-by-side -->\r\n    <div class=\"td-table-container side-by-side\" *ngIf=\"format === 'SideBySide'\" id=\"td-left-compare-container\" tdContainer cdkScrollable>\r\n      <table class=\"td-table\">\r\n        <tbody>\r\n          <tr *ngFor=\"let row of filteredTableRows; trackBy: trackTableRows\">\r\n            <td\r\n              scope=\"row\"\r\n              class=\"fit-column line-number-col\"\r\n              [ngClass]=\"{ 'delete-row': row.leftContent?.prefix === '-', 'empty-row': !row.leftContent?.lineContent }\"\r\n            >\r\n              {{ row.leftContent?.lineNumber !== -1 ? row.leftContent?.lineNumber : ' ' }}\r\n            </td>\r\n            <td\r\n              class=\"fit-column prefix-col\"\r\n              [ngClass]=\"{ 'delete-row': row.leftContent?.prefix === '-', 'empty-row': !row.leftContent?.lineContent }\"\r\n            >\r\n              <span>{{ row.leftContent?.prefix || ' ' }}</span>\r\n            </td>\r\n            <td\r\n              class=\"content-col\"\r\n              [ngClass]=\"{ 'delete-row': row.leftContent?.prefix === '-', 'empty-row': !row.leftContent?.lineContent }\"\r\n              *ngIf=\"!row.hasDiffs\"\r\n            >\r\n              <span [innerHTML]=\"row.leftContent?.lineContent | formatLine\"></span>\r\n            </td>\r\n            <td\r\n              class=\"content-col\"\r\n              [ngClass]=\"{ 'delete-row': row.leftContent?.prefix === '-', 'empty-row': !row.leftContent?.lineContent }\"\r\n              *ngIf=\"row.hasDiffs\"\r\n            >\r\n              <span\r\n                [innerHTML]=\"diff.content | formatLine\"\r\n                [ngClass]=\"{ highlight: diff.isDiff }\"\r\n                *ngFor=\"let diff of row.leftContent?.lineDiffs; trackBy: trackDiffs\"\r\n              ></span>\r\n            </td>\r\n          </tr>\r\n        </tbody>\r\n      </table>\r\n    </div>\r\n    <!-- Left side-by-side -->\r\n    <div class=\"td-table-container side-by-side\" *ngIf=\"format === 'SideBySide'\" id=\"td-right-compare-container\" tdContainer cdkScrollable>\r\n      <table class=\"td-table\">\r\n        <tbody>\r\n          <tr *ngFor=\"let row of filteredTableRows; trackBy: trackTableRows\">\r\n            <td\r\n              scope=\"row\"\r\n              class=\"fit-column line-number-col\"\r\n              [ngClass]=\"{ 'insert-row': row.rightContent?.prefix === '+', 'empty-row': !row.rightContent?.lineContent }\"\r\n            >\r\n              {{ row.rightContent?.lineNumber !== -1 ? row.rightContent?.lineNumber : ' ' }}\r\n            </td>\r\n            <td\r\n              class=\"fit-column prefix-col\"\r\n              [ngClass]=\"{ 'insert-row': row.rightContent?.prefix === '+', 'empty-row': !row.rightContent?.lineContent }\"\r\n            >\r\n              <span>{{ row.rightContent?.prefix || ' ' }}</span>\r\n            </td>\r\n            <td\r\n              class=\"content-col\"\r\n              [ngClass]=\"{ 'insert-row': row.rightContent?.prefix === '+', 'empty-row': !row.rightContent?.lineContent }\"\r\n              *ngIf=\"!row.hasDiffs\"\r\n            >\r\n              <span [innerHTML]=\"row.rightContent?.lineContent | formatLine\"></span>\r\n            </td>\r\n            <td\r\n              class=\"content-col\"\r\n              [ngClass]=\"{ 'insert-row': row.rightContent?.prefix === '+', 'empty-row': !row.rightContent?.lineContent }\"\r\n              *ngIf=\"row.hasDiffs\"\r\n            >\r\n              <span\r\n                [innerHTML]=\"diff.content | formatLine\"\r\n                [ngClass]=\"{ highlight: diff.isDiff }\"\r\n                *ngFor=\"let diff of row.rightContent?.lineDiffs; trackBy: trackDiffs\"\r\n              ></span>\r\n            </td>\r\n          </tr>\r\n        </tbody>\r\n      </table>\r\n    </div>\r\n    <!-- Line By Line - combined table -->\r\n    <div class=\"td-table-container line-by-line\" *ngIf=\"format === 'LineByLine'\">\r\n      <table class=\"td-table\">\r\n        <tbody>\r\n          <tr *ngFor=\"let row of filteredTableRowsLineByLine; trackBy: trackTableRows\">\r\n            <td scope=\"row\" class=\"fit-column line-number-col-left\">{{ row.leftContent?.lineNumber }}</td>\r\n            <td scope=\"row\" class=\"fit-column line-number-col\">{{ row.rightContent?.lineNumber }}</td>\r\n            <td\r\n              class=\"fit-column prefix-col\"\r\n              [ngClass]=\"{ 'delete-row': row.leftContent?.prefix === '-', 'insert-row': row.rightContent?.prefix === '+' }\"\r\n            >\r\n              <span>{{ row.leftContent?.prefix || row.rightContent?.prefix || ' ' }}</span>\r\n            </td>\r\n            <td\r\n              class=\"content-col\"\r\n              [ngClass]=\"{ 'delete-row': row.leftContent?.prefix === '-', 'insert-row': row.rightContent?.prefix === '+' }\"\r\n              *ngIf=\"!row.hasDiffs\"\r\n            >\r\n              <span [innerHTML]=\"row.leftContent?.lineContent | formatLine\"></span>\r\n            </td>\r\n            <td\r\n              class=\"content-col\"\r\n              [ngClass]=\"{ 'delete-row': row.leftContent?.prefix === '-', 'insert-row': row.rightContent?.prefix === '+' }\"\r\n              *ngIf=\"row.hasDiffs && row.leftContent && row.leftContent?.lineDiffs.length !== 0\"\r\n            >\r\n              <span\r\n                [innerHTML]=\"diff.content | formatLine\"\r\n                [ngClass]=\"{ highlight: diff.isDiff }\"\r\n                *ngFor=\"let diff of row.leftContent?.lineDiffs; trackBy: trackDiffs\"\r\n              ></span>\r\n            </td>\r\n            <td\r\n              class=\"content-col\"\r\n              [ngClass]=\"{ 'delete-row': row.leftContent?.prefix === '-', 'insert-row': row.rightContent?.prefix === '+' }\"\r\n              *ngIf=\"row.hasDiffs && row.rightContent && row.rightContent?.lineDiffs.length !== 0\"\r\n            >\r\n              <span\r\n                [innerHTML]=\"diff.content | formatLine\"\r\n                [ngClass]=\"{ highlight: diff.isDiff }\"\r\n                *ngFor=\"let diff of row.rightContent?.lineDiffs; trackBy: trackDiffs\"\r\n              ></span>\r\n            </td>\r\n          </tr>\r\n        </tbody>\r\n      </table>\r\n    </div>\r\n  </div>\r\n</div>\r\n",
            styles: [".td-wrapper{display:grid;width:100%;grid-row-gap:10px;grid-template-columns:repeat(2,[col] 50%);grid-template-rows:repeat(2,[row] auto);background-color:#fff;color:#444}.td-toolbar-show-diff{grid-column:1;grid-row:1}.td-toolbar-select-format{margin-left:auto;grid-column:2;grid-row:1}.td-table-container{grid-column:1/2;grid-row:2;width:100%;max-width:100%;overflow-x:auto}.td-table-wrapper{display:flex;width:200%}.td-table{border:1px solid #a9a9a9;max-height:50vh;width:100%;max-width:100%}.fit-column{width:1px;white-space:nowrap}.line-number-col{position:relative;position:-webkit-sticky;position:sticky;left:0;top:auto;border-right:1px solid #ddd;color:#999;text-align:right;background-color:#f7f7f7;padding-left:10px;padding-right:10px;font-size:87.5%}.line-number-col-left{color:#999;padding-left:10px;padding-right:10px;text-align:right;background-color:#f7f7f7;font-size:87.5%}.insert-row,.insert-row>.line-number-col{background-color:#dfd;border-color:#b4e2b4}.delete-row,.delete-row>.line-number-col{background-color:#fee8e9;border-color:#e9aeae}.empty-row{background-color:#f7f7f7;height:24px}.td-table td{border-top:0;padding-top:0;padding-bottom:0;white-space:nowrap;max-width:50%}pre{margin-bottom:0}td.content-col{padding:0;margin:0;line-height:24px}td.prefix-col{padding-left:10px;padding-right:10px;line-height:24px}.td-btn-group{border-radius:4px}.td-btn-group button{background-color:rgba(23,162,184,.7);border:1px solid #17a2b8;color:#fff;cursor:pointer;float:left}.td-btn-group button:not(:last-child){border-right:none}.td-btn-group button:first-child{-webkit-border-top-left-radius:4px;-webkit-border-bottom-left-radius:4px;-moz-border-radius-topleft:4px;-moz-border-radius-bottomleft:4px;border-top-left-radius:4px;border-bottom-left-radius:4px}.td-btn-group button:last-child{-webkit-border-top-right-radius:4px;-webkit-border-bottom-right-radius:4px;-moz-border-radius-topright:4px;-moz-border-radius-bottomright:4px;border-top-right-radius:4px;border-bottom-right-radius:4px}.td-btn-group:after{content:'';clear:both;display:table}.td-btn-group button.active,.td-btn-group button:hover{background-color:#17a2b8}.td-checkbox-container{display:block;position:relative;padding-left:21px;margin-bottom:0;cursor:pointer;font-size:16px;line-height:28px;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none}.td-checkbox-container input{position:absolute;opacity:0;cursor:pointer;height:0;width:0}.checkmark{position:absolute;top:7px;left:0;height:16px;width:16px;background-color:#eee}.td-checkbox-container:hover input~.checkmark{background-color:#ccc}.td-checkbox-container input:checked~.checkmark{background-color:#17a2b8}.checkmark:after{content:\"\";position:absolute;display:none}.td-checkbox-container input:checked~.checkmark:after{display:block}.td-checkbox-container .checkmark:after{left:5px;top:3px;width:5px;height:10px;border:solid #fff;border-width:0 3px 3px 0;transform:rotate(45deg)}.insert-row>.highlight{background-color:#acf2bd!important}.delete-row>.highlight{background-color:#fdb8c0!important}"]
        }),
        __metadata("design:paramtypes", [ScrollDispatcher, NgxTextDiffService, ChangeDetectorRef])
    ], NgxTextDiffComponent);
    return NgxTextDiffComponent;
}());

var LoaderSpinnerComponent = /** @class */ (function () {
    function LoaderSpinnerComponent() {
        this.active = false;
    }
    LoaderSpinnerComponent.prototype.ngOnInit = function () { };
    __decorate([
        Input(),
        __metadata("design:type", Object)
    ], LoaderSpinnerComponent.prototype, "active", void 0);
    LoaderSpinnerComponent = __decorate([
        Component({
            selector: 'td-loader-spinner',
            template: "<div class=\"td-loading-roller\" *ngIf=\"active\">\r\n  <div></div>\r\n  <div></div>\r\n  <div></div>\r\n  <div></div>\r\n  <div></div>\r\n  <div></div>\r\n  <div></div>\r\n  <div></div>\r\n</div>\r\n",
            styles: [".td-loading-roller{display:inline-block;position:relative;width:64px;height:64px}.td-loading-roller div{-webkit-animation:1.2s cubic-bezier(.5,0,.5,1) infinite lds-roller;animation:1.2s cubic-bezier(.5,0,.5,1) infinite lds-roller;transform-origin:32px 32px}.td-loading-roller div:after{content:\" \";display:block;position:absolute;width:6px;height:6px;border-radius:50%;background:#000;margin:-3px 0 0 -3px}.td-loading-roller div:nth-child(1){-webkit-animation-delay:-36ms;animation-delay:-36ms}.td-loading-roller div:nth-child(1):after{top:50px;left:50px}.td-loading-roller div:nth-child(2){-webkit-animation-delay:-72ms;animation-delay:-72ms}.td-loading-roller div:nth-child(2):after{top:54px;left:45px}.td-loading-roller div:nth-child(3){-webkit-animation-delay:-108ms;animation-delay:-108ms}.td-loading-roller div:nth-child(3):after{top:57px;left:39px}.td-loading-roller div:nth-child(4){-webkit-animation-delay:-144ms;animation-delay:-144ms}.td-loading-roller div:nth-child(4):after{top:58px;left:32px}.td-loading-roller div:nth-child(5){-webkit-animation-delay:-.18s;animation-delay:-.18s}.td-loading-roller div:nth-child(5):after{top:57px;left:25px}.td-loading-roller div:nth-child(6){-webkit-animation-delay:-216ms;animation-delay:-216ms}.td-loading-roller div:nth-child(6):after{top:54px;left:19px}.td-loading-roller div:nth-child(7){-webkit-animation-delay:-252ms;animation-delay:-252ms}.td-loading-roller div:nth-child(7):after{top:50px;left:14px}.td-loading-roller div:nth-child(8){-webkit-animation-delay:-288ms;animation-delay:-288ms}.td-loading-roller div:nth-child(8):after{top:45px;left:10px}@-webkit-keyframes lds-roller{0%{transform:rotate(0)}100%{transform:rotate(360deg)}}@keyframes lds-roller{0%{transform:rotate(0)}100%{transform:rotate(360deg)}}"]
        }),
        __metadata("design:paramtypes", [])
    ], LoaderSpinnerComponent);
    return LoaderSpinnerComponent;
}());

var FormatLinePipe = /** @class */ (function () {
    function FormatLinePipe() {
    }
    FormatLinePipe.prototype.transform = function (line, diffs) {
        if (!line) {
            return ' ';
        }
        if (!!diffs && diffs.length > 0) {
            /*diffs.forEach(diff => {
              line = line.replace(diff, `<span class="highli">${diff}</span>`);
            });*/
        }
        return line
            .replace(/&/g, '&amp;')
            .replace(/</g, '&lt;')
            .replace(/>/g, '&gt;')
            .replace(/"/g, '&quot;')
            .replace(/ /g, '&nbsp;');
    };
    FormatLinePipe = __decorate([
        Pipe({
            name: 'formatLine'
        })
    ], FormatLinePipe);
    return FormatLinePipe;
}());

var NgxTextDiffModule = /** @class */ (function () {
    function NgxTextDiffModule() {
    }
    NgxTextDiffModule = __decorate([
        NgModule({
            imports: [CommonModule, FormsModule, ScrollingModule],
            declarations: [NgxTextDiffComponent, LoaderSpinnerComponent, FormatLinePipe, ContainerDirective],
            exports: [NgxTextDiffComponent],
        })
    ], NgxTextDiffModule);
    return NgxTextDiffModule;
}());

/*
 * Public API Surface of ngx-text-diff
 */

/**
 * Generated bundle index. Do not edit.
 */

export { NgxTextDiffComponent, NgxTextDiffModule, NgxTextDiffService, ContainerDirective as ɵa, LoaderSpinnerComponent as ɵb, FormatLinePipe as ɵc };
//# sourceMappingURL=ngx-text-diff.js.map
