import { ChangeDetectorRef, OnDestroy, OnInit, EventEmitter, QueryList, AfterViewInit } from '@angular/core';
import { DiffContent, DiffPart, DiffTableFormat, DiffTableFormatOption, DiffTableRowResult, DiffResults } from './ngx-text-diff.model';
import { NgxTextDiffService } from './ngx-text-diff.service';
import { Observable, Subscription } from 'rxjs';
import { ContainerDirective } from './ngx-text-diff-container.directive';
import { ScrollDispatcher } from '@angular/cdk/scrolling';
export declare class NgxTextDiffComponent implements OnInit, AfterViewInit, OnDestroy {
    private scrollService;
    private diff;
    private cd;
    private _hideMatchingLines;
    containers: QueryList<ContainerDirective>;
    format: DiffTableFormat;
    left: string;
    right: string;
    diffContent: Observable<DiffContent>;
    loading: boolean;
    showToolbar: boolean;
    showBtnToolbar: boolean;
    get hideMatchingLines(): boolean;
    set hideMatchingLines(hide: boolean);
    outerContainerClass: string;
    outerContainerStyle: any;
    toolbarClass: string;
    toolbarStyle: any;
    compareRowsClass: string;
    compareRowsStyle: any;
    synchronizeScrolling: boolean;
    compareResults: EventEmitter<DiffResults>;
    subscriptions: Subscription[];
    tableRows: DiffTableRowResult[];
    filteredTableRows: DiffTableRowResult[];
    tableRowsLineByLine: DiffTableRowResult[];
    filteredTableRowsLineByLine: DiffTableRowResult[];
    diffsCount: number;
    formatOptions: DiffTableFormatOption[];
    constructor(scrollService: ScrollDispatcher, diff: NgxTextDiffService, cd: ChangeDetectorRef);
    ngOnInit(): void;
    ngAfterViewInit(): void;
    ngOnDestroy(): void;
    hideMatchingLinesChanged(value: boolean): void;
    setDiffTableFormat(format: DiffTableFormat): void;
    renderDiffs(): Promise<void>;
    emitCompareResultsEvent(): void;
    trackTableRows(index: any, row: DiffTableRowResult): string;
    trackDiffs(index: any, diff: DiffPart): string;
    private initScrollListener;
}
