"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var core_1 = require("@angular/core");
var ngx_uploader_1 = require("../services/ngx-uploader");
var index_1 = require("../classes/index");
var NgFileSelectDirective = (function () {
    function NgFileSelectDirective(el, uploader) {
        this.el = el;
        this.uploader = uploader;
        this.onUpload = new core_1.EventEmitter();
        this.onPreviewData = new core_1.EventEmitter();
        this.onUploadRejected = new core_1.EventEmitter();
        this.beforeUpload = new core_1.EventEmitter();
        this.files = [];
    }
    NgFileSelectDirective.prototype.ngOnChanges = function (changes) {
        var _this = this;
        if (!this.options) {
            return;
        }
        this.uploader.setOptions(new index_1.NgUploaderOptions(this.options));
        this.uploader._emitter.subscribe(function (data) {
            _this.onUpload.emit(data);
            if (data.done && _this.files && _this.files.length) {
                _this.files = [].filter.call(_this.files, function (x) { return x.name !== data.originalName; });
            }
        });
        this.uploader._previewEmitter.subscribe(function (data) {
            _this.onPreviewData.emit(data);
        });
        this.uploader._beforeEmitter.subscribe(function (uploadingFile) {
            _this.beforeUpload.emit(uploadingFile);
        });
        if (this.events instanceof core_1.EventEmitter) {
            this.events.subscribe(function (data) {
                if (data === 'startUpload') {
                    _this.uploader.uploadFilesInQueue();
                }
            });
        }
    };
    NgFileSelectDirective.prototype.onChange = function () {
        var _this = this;
        this.files = this.el.nativeElement.files;
        if (!this.files) {
            return;
        }
        if (this.options.filterExtensions && this.options.allowedExtensions && this.files && this.files.length) {
            this.files = [].filter.call(this.files, function (f) {
                var allowedExtensions = _this.options.allowedExtensions || [];
                if (allowedExtensions.indexOf(f.type) !== -1) {
                    return true;
                }
                var ext = f.name.split('.').pop();
                if (allowedExtensions.indexOf(ext) !== -1) {
                    return true;
                }
                _this.onUploadRejected.emit({ file: f, reason: index_1.UploadRejected.EXTENSION_NOT_ALLOWED });
                return false;
            });
        }
        if (this.files.length) {
            this.uploader.addFilesToQueue(this.files);
        }
    };
    return NgFileSelectDirective;
}());
__decorate([
    core_1.Input(),
    __metadata("design:type", index_1.NgUploaderOptions)
], NgFileSelectDirective.prototype, "options", void 0);
__decorate([
    core_1.Input(),
    __metadata("design:type", core_1.EventEmitter)
], NgFileSelectDirective.prototype, "events", void 0);
__decorate([
    core_1.Output(),
    __metadata("design:type", core_1.EventEmitter)
], NgFileSelectDirective.prototype, "onUpload", void 0);
__decorate([
    core_1.Output(),
    __metadata("design:type", core_1.EventEmitter)
], NgFileSelectDirective.prototype, "onPreviewData", void 0);
__decorate([
    core_1.Output(),
    __metadata("design:type", core_1.EventEmitter)
], NgFileSelectDirective.prototype, "onUploadRejected", void 0);
__decorate([
    core_1.Output(),
    __metadata("design:type", core_1.EventEmitter)
], NgFileSelectDirective.prototype, "beforeUpload", void 0);
__decorate([
    core_1.HostListener('change'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], NgFileSelectDirective.prototype, "onChange", null);
NgFileSelectDirective = __decorate([
    core_1.Directive({
        selector: '[ngFileSelect]',
        providers: [
            ngx_uploader_1.NgUploaderService
        ],
    }),
    __param(0, core_1.Inject(core_1.ElementRef)),
    __param(1, core_1.Inject(ngx_uploader_1.NgUploaderService)),
    __metadata("design:paramtypes", [core_1.ElementRef,
        ngx_uploader_1.NgUploaderService])
], NgFileSelectDirective);
exports.NgFileSelectDirective = NgFileSelectDirective;
//# sourceMappingURL=ng-file-select.js.map