"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var core_1 = require("@angular/core");
var uploaded_file_class_1 = require("../classes/uploaded-file.class");
var NgUploaderService = (function () {
    function NgUploaderService() {
        this._queue = [];
        this._emitter = new core_1.EventEmitter();
        this._previewEmitter = new core_1.EventEmitter();
        this._beforeEmitter = new core_1.EventEmitter();
    }
    NgUploaderService.prototype.setOptions = function (opts) {
        this.opts = opts;
    };
    NgUploaderService.prototype.uploadFilesInQueue = function () {
        var _this = this;
        this._queue.forEach(function (file) {
            if (file.uploading) {
                return;
            }
            _this.uploadFile(file);
        });
    };
    ;
    NgUploaderService.prototype.uploadFile = function (file) {
        var _this = this;
        var xhr = new XMLHttpRequest();
        var form = new FormData();
        Object.keys(this.opts.data).forEach(function (k) {
            form.append(k, _this.opts.data[k]);
        });
        form.append(this.opts.fieldName, file, file.name);
        var uploadingFile = new uploaded_file_class_1.UploadedFile(this.generateRandomIndex(), file.name, file.size);
        var queueIndex = this._queue.indexOf(file);
        var time = new Date().getTime();
        var load = 0;
        var speed = 0;
        var speedHumanized = null;
        xhr.upload.onprogress = function (e) {
            if (e.lengthComputable) {
                if (_this.opts.calculateSpeed) {
                    time = new Date().getTime() - time;
                    load = e.loaded - load;
                    speed = load / time * 1000;
                    speed = parseInt(speed, 10);
                    speedHumanized = _this.humanizeBytes(speed);
                }
                var percent = Math.round(e.loaded / e.total * 100);
                if (speed === 0) {
                    uploadingFile.setProgress({
                        total: e.total,
                        loaded: e.loaded,
                        percent: percent
                    });
                }
                else {
                    uploadingFile.setProgress({
                        total: e.total,
                        loaded: e.loaded,
                        percent: percent,
                        speed: speed,
                        speedHumanized: speedHumanized
                    });
                }
                _this._emitter.emit(uploadingFile);
            }
        };
        xhr.upload.onabort = function (e) {
            uploadingFile.setAbort();
            _this._emitter.emit(uploadingFile);
        };
        xhr.upload.onerror = function (e) {
            uploadingFile.setError();
            _this._emitter.emit(uploadingFile);
        };
        xhr.onreadystatechange = function () {
            if (xhr.readyState === XMLHttpRequest.DONE) {
                uploadingFile.onFinished(xhr.status, xhr.statusText, xhr.response);
                _this.removeFileFromQueue(queueIndex);
                _this._emitter.emit(uploadingFile);
            }
        };
        xhr.open(this.opts.method, this.opts.url, true);
        xhr.withCredentials = this.opts.withCredentials;
        if (this.opts.customHeaders) {
            Object.keys(this.opts.customHeaders).forEach(function (key) {
                xhr.setRequestHeader(key, _this.opts.customHeaders[key]);
            });
        }
        if (this.opts.authToken) {
            xhr.setRequestHeader('Authorization', this.opts.authTokenPrefix + " " + this.opts.authToken);
        }
        this._beforeEmitter.emit(uploadingFile);
        if (!uploadingFile.abort) {
            xhr.send(form);
        }
        else {
            this.removeFileFromQueue(queueIndex);
        }
    };
    NgUploaderService.prototype.addFilesToQueue = function (files) {
        var _this = this;
        this.clearQueue();
        [].forEach.call(files, function (file, i) {
            if (!_this.inQueue(file)) {
                _this._queue.push(file);
            }
        });
        if (this.opts.previewUrl) {
            [].forEach.call(files, function (file) { return _this.createFileUrl(file); });
        }
        if (this.opts.autoUpload) {
            this.uploadFilesInQueue();
        }
    };
    NgUploaderService.prototype.createFileUrl = function (file) {
        var _this = this;
        var reader = new FileReader();
        reader.addEventListener('load', function () {
            _this._previewEmitter.emit(reader.result);
        });
        reader.readAsDataURL(file);
    };
    NgUploaderService.prototype.removeFileFromQueue = function (i) {
        this._queue.splice(i, 1);
    };
    NgUploaderService.prototype.clearQueue = function () {
        this._queue = [];
    };
    NgUploaderService.prototype.getQueueSize = function () {
        return this._queue.length;
    };
    NgUploaderService.prototype.inQueue = function (file) {
        var fileInQueue = this._queue.filter(function (f) { return f === file; });
        return fileInQueue.length ? true : false;
    };
    NgUploaderService.prototype.generateRandomIndex = function () {
        return Math.random().toString(36).substring(7);
    };
    NgUploaderService.prototype.humanizeBytes = function (bytes) {
        if (bytes === 0) {
            return '0 Byte';
        }
        var k = 1024;
        var sizes = ['Bytes', 'KB', 'MB', 'GB', 'TB', 'PB'];
        var i = Math.floor(Math.log(bytes) / Math.log(k));
        return parseFloat((bytes / Math.pow(k, i)).toFixed(2)) + ' ' + sizes[i] + '/s';
    };
    return NgUploaderService;
}());
NgUploaderService = __decorate([
    core_1.Injectable(),
    __metadata("design:paramtypes", [])
], NgUploaderService);
exports.NgUploaderService = NgUploaderService;
exports.NgUploaderServiceProvider = {
    provide: NgUploaderService, useClass: NgUploaderService
};
//# sourceMappingURL=ngx-uploader.js.map