# NHS.UK frontend

NHS.UK frontend contains the code you need to start building user interfaces for NHS websites and services.

## Guidance

Visit the [NHS digital service manual](https://service-manual.nhs.uk/) for examples of components and guidance for when to use them. If we haven't yet published guidance on the component you want, please [email us](mailto:service-manual@nhs.net) or get in touch on the [NHS digital service manual Slack workspace](https://join.slack.com/t/nhs-service-manual/shared_invite/enQtNTIyOTEyNjU3NDkyLTk4NDQ3YzkwYzk1Njk5YjAxYTI5YTVkZmUxMGQ0ZjA3NjMyM2ZkNjBlMWMxODVjZjYzNzg1ZmU4MWY1NmE2YzE).

## Quick start

There are 2 ways to start using NHS.UK frontend in your app:

- [using Node.js package manager (npm)](/docs/installation/installing-with-npm.md) (recommended)
- by [copying our CSS, JavaScript and asset files into your project](/docs/installation/installing-compiled.md)

## Browsers and assistive technology

Visit our [support for browsers and assistive technology](/docs/contributing/browser-support.md), for details on operating systems and software.

## Contribute

Read our [contributing guidelines](/CONTRIBUTING.md) to contribute to NHS.UK frontend.

## Development environment

[![Gitpod ready-to-code](https://img.shields.io/badge/Gitpod-ready--to--code-blue?logo=gitpod)](https://gitpod.io/#https://github.com/nhsuk/nhsuk-frontend)

## Get in touch

NHS.UK frontend is maintained by NHS England. [Email us](mailto:service-manual@nhs.net), open a [GitHub issue](https://github.com/nhsuk/nhsuk-frontend/issues/new) or get in touch on the [NHS digital service manual Slack workspace](https://join.slack.com/t/nhs-service-manual/shared_invite/enQtNTIyOTEyNjU3NDkyLTk4NDQ3YzkwYzk1Njk5YjAxYTI5YTVkZmUxMGQ0ZjA3NjMyM2ZkNjBlMWMxODVjZjYzNzg1ZmU4MWY1NmE2YzE).

## Licence

The codebase is released under the MIT Licence, unless stated otherwise. This covers both the codebase and any sample code in the documentation. The documentation is © NHS England and available under the terms of the Open Government 3.0 licence.
