const version="10.0.0";function toggleConditionalInput(e,t){if(!(e&&e instanceof HTMLInputElement&&t))return;const n=e.getAttribute("aria-controls");if(!n)return;const i=document.getElementById(n);i&&(e.setAttribute("aria-expanded",e.checked.toString()),i.classList.toggle(t,!e.checked))}function setFocus(e,t={}){const n=e.getAttribute("tabindex");function onBlur(){e.removeEventListener("blur",onBlur),t.onBlur&&t.onBlur.call(e),n||e.removeAttribute("tabindex")}n||e.setAttribute("tabindex","-1"),e.addEventListener("focus",(function onFocus(){e.removeEventListener("focus",onFocus),e.addEventListener("blur",onBlur)})),t.onBeforeFocus&&t.onBeforeFocus.call(e),e.focus()}function isSupported(e=document.body){return!!e&&e.classList.contains("nhsuk-frontend-supported")}function isObject(e){return!!e&&"object"==typeof e&&!Array.isArray(e)}function isScope(e){return!!e&&(e instanceof Element||e instanceof Document)}function formatErrorMessage(Component,e){return`${Component.moduleName}: ${e}`}function normaliseString(e,t){const n=e?e.trim():"";let i,s=null==t?void 0:t.type;switch(s||(["true","false"].includes(n)&&(s="boolean"),n.length>0&&isFinite(Number(n))&&(s="number")),s){case"boolean":i="true"===n;break;case"number":i=Number(n);break;default:i=e}return i}function extractConfigByNamespace(e,t,n){const i=e.properties[n];if("object"!==(null==i?void 0:i.type))return;const s={[n]:{}};for(const[o,r]of Object.entries(t)){let e=s;const t=o.split(".");for(const[i,s]of t.entries())isObject(e)&&(i<t.length-1?(isObject(e[s])||(e[s]={}),e=e[s]):o!==n&&(e[s]=normaliseString(r)))}return s[n]}function mergeConfigs(...e){const t={};for(const n of e)for(const e of Object.keys(n)){const i=t[e],s=n[e];isObject(i)&&isObject(s)?t[e]=mergeConfigs(i,s):t[e]=s}return t}class NHSUKFrontendError extends Error{constructor(...e){super(...e),this.name="NHSUKFrontendError"}}class SupportError extends NHSUKFrontendError{constructor(e=document.body){const t="noModule"in HTMLScriptElement.prototype?'NHS.UK frontend initialised without `<body class="nhsuk-frontend-supported">` from template `<script>` snippet':"NHS.UK frontend is not supported in this browser";super(e?t:'NHS.UK frontend initialised without `<script type="module">`'),this.name="SupportError"}}class ConfigError extends NHSUKFrontendError{constructor(...e){super(...e),this.name="ConfigError"}}class ElementError extends NHSUKFrontendError{constructor(e){const{component:t,identifier:n,element:i,expectedType:s}=e;let o=n;o+=i?` is not of type ${null!=s?s:"HTMLElement"}`:" not found",t&&(o=formatErrorMessage(t,o)),super(o),this.name="ElementError"}}class InitError extends NHSUKFrontendError{constructor(e){super("string"==typeof e?e:formatErrorMessage(e,"Root element (`$root`) already initialised")),this.name="InitError"}}function normaliseOptions(e){let t,n=document;if(isObject(e)){const i=e;(isScope(i.scope)||null===i.scope)&&(n=i.scope),"function"==typeof i.onError&&(t=i.onError)}return isScope(e)?n=e:null===e?n=null:"function"==typeof e&&(t=e),{scope:n,onError:t}}class Component{constructor(e){this.$root=void 0;const t=this.constructor;if(!(e&&e instanceof t.elementType))throw new ElementError({element:e,component:t,identifier:"Root element (`$root`)",expectedType:t.elementType.name});this.$root=e,t.checkSupport(),this.checkInitialised();const{moduleName:n}=t;this.$root.setAttribute(`data-${n}-init`,"")}checkInitialised(){const e=this.constructor;if(t=this.$root,n=e.moduleName,t instanceof HTMLElement&&t.hasAttribute(`data-${n}-init`))throw new InitError(e);var t,n}static checkSupport(){if(!isSupported())throw new SupportError}}Component.elementType=HTMLElement,Component.moduleName="nhsuk-component";class ConfigurableComponent extends Component{constructor(e,t){super(e),this.config=void 0;const n=this.constructor;if(!isObject(n.defaults))throw new ConfigError(formatErrorMessage(n,"Config passed as parameter into constructor but no defaults defined"));const i=function(Component,e){if(!isObject(Component.schema))throw new ConfigError(formatErrorMessage(Component,"Config passed as parameter into constructor but no schema defined"));const t={},n=Object.entries(Component.schema.properties);for(const i of n){const[n,s]=i,o=n.toString();o in e&&(t[o]=normaliseString(e[o],s)),"object"===(null==s?void 0:s.type)&&(t[o]=extractConfigByNamespace(Component.schema,e,n))}return t}(n,this.$root.dataset);this.config=mergeConfigs(n.defaults,null!=t?t:{}),this.config=mergeConfigs(this.config,this.configOverride(i),i)}configOverride(e={}){return{}}}class Button extends ConfigurableComponent{constructor(e,t={}){super(e,t),this.debounceFormSubmitTimer=null,this.$root.addEventListener("keydown",(e=>this.handleKeyDown(e))),this.$root.addEventListener("click",(e=>this.debounce(e)))}handleKeyDown(e){const t=e.target;" "===e.key&&t instanceof HTMLElement&&"button"===t.getAttribute("role")&&(e.preventDefault(),t.click())}debounce(e){if(this.config.preventDoubleClick)return this.debounceFormSubmitTimer?(e.preventDefault(),!1):void(this.debounceFormSubmitTimer=window.setTimeout((()=>{this.debounceFormSubmitTimer=null}),1e3))}}function initButtons(e){const{scope:t}=normaliseOptions(e),n=null==t?void 0:t.querySelectorAll(`[data-module="${Button.moduleName}"]`);null==n||n.forEach((t=>{new Button(t,e)}))}Button.moduleName="nhsuk-button",Button.defaults=Object.freeze({preventDoubleClick:!1}),Button.schema=Object.freeze({properties:{preventDoubleClick:{type:"boolean"}}});class CharacterCount extends ConfigurableComponent{constructor(e,t={}){var n,i;super(e,t),this.lastInputTimestamp=null,this.lastInputValue="",this.valueChecker=null;const s=this.$root.querySelector(".nhsuk-js-character-count");if(!s||!(s instanceof HTMLTextAreaElement||s instanceof HTMLInputElement))throw new ElementError({component:CharacterCount,element:s,expectedType:"HTMLTextareaElement or HTMLInputElement",identifier:"Form field (`.nhsuk-js-character-count`)"});this.$textarea=s;const o=`${this.$textarea.id}-info`,r=document.getElementById(o);if(!r)throw new ElementError({component:CharacterCount,element:r,identifier:`Count message (\`id="${o}"\`)`});this.$errorMessage=this.$root.querySelector(".nhsuk-error-message"),this.$textarea.insertAdjacentElement("afterend",r);const a=document.createElement("div");a.className="nhsuk-character-count__sr-status nhsuk-u-visually-hidden",a.setAttribute("aria-live","polite"),this.$screenReaderCountMessage=a,r.insertAdjacentElement("afterend",a);const l=document.createElement("div");l.className=r.className,l.classList.add("nhsuk-character-count__status"),l.setAttribute("aria-hidden","true"),this.$visibleCountMessage=l,r.insertAdjacentElement("afterend",l),r.classList.add("nhsuk-u-visually-hidden"),this.maxLength=null!=(n=null!=(i=this.config.maxwords)?i:this.config.maxlength)?n:1/0,this.$textarea.removeAttribute("maxlength"),this.bindChangeEvents(),window.addEventListener("pageshow",(()=>this.updateCountMessage())),this.updateCountMessage()}count(e){let t;if(this.config.maxwords){var n;t=(null!=(n=e.match(/\S+/g))?n:[]).length}else t=e.length;return t}bindChangeEvents(){this.$textarea.addEventListener("keyup",(()=>this.handleKeyUp())),this.$textarea.addEventListener("focus",(()=>this.handleFocus())),this.$textarea.addEventListener("blur",(()=>this.handleBlur()))}checkIfValueChanged(){this.$textarea.value!==this.lastInputValue&&(this.lastInputValue=this.$textarea.value,this.updateCountMessage())}updateCountMessage(){this.updateVisibleCountMessage(),this.updateScreenReaderCountMessage()}updateVisibleCountMessage(){const e=this.maxLength-this.count(this.$textarea.value)<0;this.$visibleCountMessage.classList.toggle("nhsuk-character-count__message--disabled",!this.isOverThreshold()),this.$errorMessage||this.$textarea.classList.toggle("nhsuk-textarea--error",e),this.$visibleCountMessage.classList.toggle("nhsuk-error-message",e),this.$visibleCountMessage.classList.toggle("nhsuk-hint",!e),this.$visibleCountMessage.innerHTML=this.formattedUpdateMessage()}updateScreenReaderCountMessage(){this.isOverThreshold()?this.$screenReaderCountMessage.removeAttribute("aria-hidden"):this.$screenReaderCountMessage.setAttribute("aria-hidden","true"),this.$screenReaderCountMessage.innerHTML=this.formattedUpdateMessage()}formattedUpdateMessage(){const e=this.maxLength-this.count(this.$textarea.value);let t="remaining",n="character",i=e;return this.config.maxwords&&(n="word"),n+=-1===e||1===e?"":"s",t=e<0?"too many":"remaining",i=Math.abs(e),`You have ${i} ${n} ${t}`}isOverThreshold(){var e;const t=this.count(this.$textarea.value),n=null!=(e=this.config.threshold)?e:0;return this.maxLength*n/100<=t}handleKeyUp(){this.updateVisibleCountMessage(),this.lastInputTimestamp=Date.now()}handleFocus(){this.valueChecker=window.setInterval((()=>{(!this.lastInputTimestamp||Date.now()-500>=this.lastInputTimestamp)&&this.checkIfValueChanged()}),1e3)}handleBlur(){this.valueChecker&&window.clearInterval(this.valueChecker)}}function initCharacterCounts(e){const{scope:t}=normaliseOptions(e),n=null==t?void 0:t.querySelectorAll(`[data-module="${CharacterCount.moduleName}"]`);null==n||n.forEach((e=>{new CharacterCount(e)}))}CharacterCount.moduleName="nhsuk-character-count",CharacterCount.defaults=Object.freeze({threshold:0}),CharacterCount.schema=Object.freeze({properties:{maxwords:{type:"number"},maxlength:{type:"number"},threshold:{type:"number"}}});class Checkboxes extends Component{constructor(e){super(e);const t=this.$root.querySelectorAll('input[type="checkbox"]');if(!t.length)throw new ElementError({component:Checkboxes,identifier:'Form inputs (`<input type="checkbox">`)'});this.$inputs=t,this.$inputs.forEach((e=>{const t=e.getAttribute("aria-controls");if(t&&!document.getElementById(t))throw new ElementError({component:Checkboxes,identifier:`Conditional reveal (\`id="${t}"\`)`})})),window.addEventListener("pageshow",(()=>this.syncAllConditionalReveals())),this.syncAllConditionalReveals(),this.$root.addEventListener("click",(e=>this.handleClick(e)))}syncAllConditionalReveals(){this.$inputs.forEach((e=>this.syncConditionalRevealWithInputState(e)))}syncConditionalRevealWithInputState(e){toggleConditionalInput(e,"nhsuk-checkboxes__conditional--hidden")}unCheckAllInputsExcept(e){const{checkboxExclusiveGroup:t}=e.dataset,n=t?`[data-checkbox-exclusive-group="${t}"]`:`[name="${e.name}"]`;document.querySelectorAll(`input[type="checkbox"]${n}`).forEach((n=>{e.form===n.form&&n!==e&&this.setInputState(n,!1,t)}))}unCheckExclusiveInputs(e){const{checkboxExclusiveGroup:t}=e.dataset,n=t?`[data-checkbox-exclusive-group="${t}"]`:`[name="${e.name}"]`;document.querySelectorAll(`input[type="checkbox"][data-checkbox-exclusive]${n}`).forEach((n=>{e.form===n.form&&this.setInputState(n,!1,t)}))}setInputState(e,t,n){const{checkboxExclusiveGroup:i}=e.dataset;n&&i&&i!==n||(e.checked=t,this.syncConditionalRevealWithInputState(e))}handleClick(e){const t=e.target;if(!(t instanceof HTMLInputElement)||"checkbox"!==t.type)return;t.getAttribute("aria-controls")&&this.syncConditionalRevealWithInputState(t),t.checked&&("checkboxExclusive"in t.dataset?this.unCheckAllInputsExcept(t):this.unCheckExclusiveInputs(t))}}function initCheckboxes(e){const{scope:t}=normaliseOptions(e),n=null==t?void 0:t.querySelectorAll(`[data-module="${Checkboxes.moduleName}"]`);null==n||n.forEach((e=>{new Checkboxes(e)}))}Checkboxes.moduleName="nhsuk-checkboxes";class ErrorSummary extends ConfigurableComponent{constructor(e,t={}){super(e,t),this.config.disableAutoFocus||setFocus(this.$root),this.$root.addEventListener("click",(e=>this.handleClick(e)))}configOverride(e){let t={};return"focusOnPageLoad"in this.config&&(console.warn(formatErrorMessage(ErrorSummary,"Option `focusOnPageLoad` is deprecated. Use `disableAutoFocus` instead.")),t.disableAutoFocus=!this.config.focusOnPageLoad),t}getAssociatedLegendOrLabel(e){var t;const n=e.closest("fieldset");if(n){const t=n.getElementsByTagName("legend");if(t.length){const n=t[0];if(e instanceof HTMLInputElement&&("checkbox"===e.type||"radio"===e.type))return n;const i=n.getBoundingClientRect().top,s=e.getBoundingClientRect();if(s.height&&window.innerHeight){if(s.top+s.height-i<window.innerHeight/2)return n}}}return null!=(t=document.querySelector(`label[for='${e.getAttribute("id")}']`))?t:e.closest("label")}focusTarget(e){if(!(e instanceof HTMLAnchorElement))return!1;const t=e.hash.replace("#","");if(!t)return!1;const n=document.getElementById(t);if(!n)return!1;const i=this.getAssociatedLegendOrLabel(n);return!!i&&(i.scrollIntoView(),n.focus({preventScroll:!0}),!0)}handleClick(e){const t=e.target;t&&this.focusTarget(t)&&e.preventDefault()}}function initErrorSummary(e){const{scope:t}=normaliseOptions(e),n=null==t?void 0:t.querySelector(`[data-module="${ErrorSummary.moduleName}"]`);n&&new ErrorSummary(n,e)}ErrorSummary.moduleName="nhsuk-error-summary",ErrorSummary.defaults=Object.freeze({disableAutoFocus:!1}),ErrorSummary.schema=Object.freeze({properties:{focusOnPageLoad:{type:"boolean"},disableAutoFocus:{type:"boolean"}}});class Header extends Component{constructor(e){super(e),this.$navigation=null,this.$navigationList=null,this.$navigationItems=null,this.$menu=null,this.$menuToggle=null,this.$menuList=null,this.width=0,this.breakpoints=[],this.updateNavigationTimer=null,this.menuIsEnabled=!1,this.menuIsOpen=!1;const t=this.$root.querySelector(".nhsuk-header__navigation"),n=this.$root.querySelector(".nhsuk-header__navigation-list"),i=this.$root.querySelectorAll(".nhsuk-header__navigation-item"),s=this.$root.querySelector(".nhsuk-header__menu"),o=this.$root.querySelector(".nhsuk-header__menu-toggle");if(t){if(!(t instanceof HTMLElement))throw new ElementError({component:Header,identifier:'Navigation (`<nav class="nhsuk-header__navigation">`)'});if(!(n&&n instanceof HTMLElement))throw new ElementError({component:Header,identifier:'List (`<ul class="nhsuk-header__navigation-list">`)'});if(!i.length)throw new ElementError({component:Header,identifier:'List items (`<li class="nhsuk-header__navigation-item">`)'});if(!(s&&s instanceof HTMLElement))throw new ElementError({component:Header,identifier:'Menu item (`<li class="nhsuk-header__menu" hidden>`)'});if(!(o&&o instanceof HTMLButtonElement))throw new ElementError({component:Header,identifier:'Menu button (`<button class="nhsuk-header__menu-toggle">`)',expectedType:"HTMLButtonElement"});this.$navigation=t,this.$navigationList=n,this.$navigationItems=i,this.$menu=s,this.$menuToggle=o,this.$menuList=document.createElement("ul")}this.handleEscapeKey=this.onEscapeKey.bind(this),this.handleUpdateNavigation=this.updateNavigation.bind(this),this.handleToggleMenu=this.toggleMenu.bind(this),this.setupNavigation(),this.updateNavigation()}resetNavigation(){const{$menu:e,$navigationList:t}=this;if(!e||!t)return;let n=0;this.breakpoints.forEach((i=>{t.insertBefore(i.element,e),n+=i.element.offsetWidth,i.right=n})),this.width=t.offsetWidth}setupNavigation(){const{$navigationItems:e}=this;e&&(e.forEach((e=>{this.breakpoints.push({element:e,right:0})})),window.addEventListener("resize",(()=>{this.updateNavigationTimer&&window.clearTimeout(this.updateNavigationTimer),this.updateNavigationTimer=window.setTimeout(this.handleUpdateNavigation,100)})))}setupMenu(){const{$menu:e,$menuList:t}=this;e&&t&&!t.parentElement&&(t.classList.add("nhsuk-header__menu-list"),t.setAttribute("hidden",""),e.appendChild(t))}enableMenu(){const{$menu:e,$menuToggle:t}=this;e&&t&&!this.menuIsEnabled&&(this.menuIsEnabled=!0,e.removeAttribute("hidden"),t.addEventListener("click",this.handleToggleMenu))}disableMenu(){const{$menu:e,$menuToggle:t}=this;e&&t&&this.menuIsEnabled&&(this.closeMenu(),this.menuIsEnabled=!1,e.setAttribute("hidden",""),t.removeEventListener("click",this.handleToggleMenu))}closeMenu(){const{$menuList:e,$menuToggle:t,$navigation:n}=this;n&&e&&t&&this.menuIsEnabled&&this.menuIsOpen&&(this.menuIsOpen=!1,e.setAttribute("hidden",""),t.setAttribute("aria-expanded","false"),n.style.removeProperty("border-bottom-width"),document.removeEventListener("keydown",this.handleEscapeKey))}onEscapeKey(e){"Escape"===e.key&&this.closeMenu()}openMenu(){const{$menuList:e,$menuToggle:t,$navigation:n}=this;n&&e&&t&&this.menuIsEnabled&&!this.menuIsOpen&&(this.menuIsOpen=!0,e.removeAttribute("hidden"),t.setAttribute("aria-expanded","true"),n.style.setProperty("border-bottom-width",`${e.offsetHeight}px`),document.addEventListener("keydown",this.handleEscapeKey))}toggleMenu(){this.menuIsEnabled&&(this.menuIsOpen?this.closeMenu():this.openMenu())}updateNavigation(){if(this.resetNavigation(),!this.breakpoints.filter((e=>e.right>this.width)).length)return void this.disableMenu();this.setupMenu(),this.enableMenu();const{$menu:e,$menuList:t,$navigation:n}=this;e&&t&&n&&(this.width-=e.offsetWidth,this.breakpoints.forEach((e=>{e.right>this.width&&t.insertAdjacentElement("beforeend",e.element)})),this.menuIsOpen&&n.style.setProperty("border-bottom-width",`${t.offsetHeight}px`))}}function initHeader(e){const{scope:t}=normaliseOptions(e),n=null==t?void 0:t.querySelector(`[data-module="${Header.moduleName}"]`);n&&new Header(n)}Header.moduleName="nhsuk-header";class NotificationBanner extends ConfigurableComponent{constructor(e,t={}){super(e,t),"alert"!==this.$root.getAttribute("role")||this.config.disableAutoFocus||setFocus(this.$root)}}function initNotificationBanners(e){const{scope:t}=normaliseOptions(e),n=null==t?void 0:t.querySelectorAll(`[data-module="${NotificationBanner.moduleName}"]`);null==n||n.forEach((t=>{new NotificationBanner(t,e)}))}NotificationBanner.moduleName="nhsuk-notification-banner",NotificationBanner.defaults=Object.freeze({disableAutoFocus:!1}),NotificationBanner.schema=Object.freeze({properties:{disableAutoFocus:{type:"boolean"}}});class Radios extends Component{constructor(e){super(e);const t=this.$root.querySelectorAll('input[type="radio"]');if(!t.length)throw new ElementError({component:Radios,identifier:'Form inputs (`<input type="radio">`)'});this.$inputs=t,this.$inputs.forEach((e=>{const t=e.getAttribute("aria-controls");if(t&&!document.getElementById(t))throw new ElementError({component:Radios,identifier:`Conditional reveal (\`id="${t}"\`)`})})),window.addEventListener("pageshow",(()=>this.syncAllConditionalReveals())),this.syncAllConditionalReveals(),this.$root.addEventListener("click",(e=>this.handleClick(e)))}syncAllConditionalReveals(){this.$inputs.forEach((e=>this.syncConditionalRevealWithInputState(e)))}syncConditionalRevealWithInputState(e){toggleConditionalInput(e,"nhsuk-radios__conditional--hidden")}handleClick(e){const t=e.target;if(!(t instanceof HTMLInputElement)||"radio"!==t.type)return;const n=document.querySelectorAll('input[type="radio"][aria-controls]'),i=t.form,s=t.name;n.forEach((e=>{const t=e.form===i;e.name===s&&t&&this.syncConditionalRevealWithInputState(e)}))}}function initRadios(e){const{scope:t}=normaliseOptions(e),n=null==t?void 0:t.querySelectorAll(`[data-module="${Radios.moduleName}"]`);null==n||n.forEach((e=>{new Radios(e)}))}Radios.moduleName="nhsuk-radios";class SkipLink extends Component{constructor(e){var t;super(e);const n=this.$root.hash,i=null!=(t=this.$root.getAttribute("href"))?t:"",s=n.replace("#","");if(!s)throw new ElementError({component:SkipLink,identifier:`Target link (\`href="${i}"\`) hash fragment`});const o=document.getElementById(s);if(!o)throw new ElementError({component:SkipLink,element:o,identifier:`Target content (\`id="${s}"\`)`});this.$root.addEventListener("click",(()=>setFocus(o,{onBeforeFocus(){o.classList.add("nhsuk-skip-link-focused-element")},onBlur(){o.classList.remove("nhsuk-skip-link-focused-element")}})))}}function initSkipLinks(e){const{scope:t}=normaliseOptions(e),n=null==t?void 0:t.querySelectorAll(`[data-module="${SkipLink.moduleName}"]`);null==n||n.forEach((e=>{new SkipLink(e)}))}SkipLink.elementType=HTMLAnchorElement,SkipLink.moduleName="nhsuk-skip-link";class Tabs extends Component{constructor(e){super(e),this.jsHiddenClass="nhsuk-tabs__panel--hidden",this.changingHash=!1,this.mql=null;const t=this.$root.querySelectorAll("a.nhsuk-tabs__tab");if(!t.length)throw new ElementError({component:Tabs,identifier:'Links (`<a class="nhsuk-tabs__tab">`)'});this.$tabs=t,this.boundTabClick=this.onTabClick.bind(this),this.boundTabKeydown=this.onTabKeydown.bind(this),this.boundOnHashChange=this.onHashChange.bind(this);const n=this.$root.querySelector(".nhsuk-tabs__list"),i=this.$root.querySelectorAll(".nhsuk-tabs__list-item");if(!n)throw new ElementError({component:Tabs,identifier:'List (`<ul class="nhsuk-tabs__list">`)'});if(!i.length)throw new ElementError({component:Tabs,identifier:'List items (`<li class="nhsuk-tabs__list-item">`)'});this.$tabList=n,this.$tabListItems=i,this.setupResponsiveChecks()}setupResponsiveChecks(){const e=function(e){const t=`--nhsuk-breakpoint-${e}`;return{property:t,value:window.getComputedStyle(document.documentElement).getPropertyValue(t)||void 0}}("tablet");if(!e.value)throw new ElementError({component:Tabs,identifier:`CSS custom property (\`${e.property}\`) on pseudo-class \`:root\``});this.mql=window.matchMedia(`(min-width: ${e.value})`),"addEventListener"in this.mql?this.mql.addEventListener("change",(()=>this.checkMode())):this.mql.addListener((()=>this.checkMode())),this.checkMode()}checkMode(){var e;null!=(e=this.mql)&&e.matches?this.setup():this.teardown()}setup(){var e;this.$tabList.setAttribute("role","tablist"),this.$tabListItems.forEach((e=>{e.setAttribute("role","presentation")})),this.$tabs.forEach((e=>{this.setAttributes(e),e.addEventListener("click",this.boundTabClick,!0),e.addEventListener("keydown",this.boundTabKeydown,!0),this.hideTab(e)}));const t=null!=(e=this.getTab(window.location.hash))?e:this.$tabs[0];this.showTab(t),window.addEventListener("hashchange",this.boundOnHashChange,!0)}teardown(){this.$tabList.removeAttribute("role"),this.$tabListItems.forEach((e=>{e.removeAttribute("role")})),this.$tabs.forEach((e=>{e.removeEventListener("click",this.boundTabClick,!0),e.removeEventListener("keydown",this.boundTabKeydown,!0),this.unsetAttributes(e)})),window.removeEventListener("hashchange",this.boundOnHashChange,!0)}onHashChange(){const{hash:e}=window.location,t=this.getTab(e);if(!t)return;if(this.changingHash)return void(this.changingHash=!1);const n=this.getCurrentTab();n&&(this.hideTab(n),this.showTab(t),t.focus())}hideTab(e){this.unhighlightTab(e),this.hidePanel(e)}showTab(e){this.highlightTab(e),this.showPanel(e)}getTab(e){return this.$root.querySelector(`a.nhsuk-tabs__tab[href="${e}"]`)}setAttributes(e){const t=e.hash.replace("#","");if(!t)return;e.setAttribute("id",`tab_${t}`),e.setAttribute("role","tab"),e.setAttribute("aria-controls",t),e.setAttribute("aria-selected","false"),e.setAttribute("tabindex","-1");const n=this.getPanel(e);n&&(n.setAttribute("role","tabpanel"),n.setAttribute("aria-labelledby",e.id),n.classList.add(this.jsHiddenClass))}unsetAttributes(e){e.removeAttribute("id"),e.removeAttribute("role"),e.removeAttribute("aria-controls"),e.removeAttribute("aria-selected"),e.removeAttribute("tabindex");const t=this.getPanel(e);t&&(t.removeAttribute("role"),t.removeAttribute("aria-labelledby"),t.removeAttribute("tabindex"),t.classList.remove(this.jsHiddenClass))}onTabClick(e){const t=this.getCurrentTab(),n=e.currentTarget;t&&n instanceof HTMLAnchorElement&&(e.preventDefault(),this.hideTab(t),this.showTab(n),this.createHistoryEntry(n))}createHistoryEntry(e){const t=this.getPanel(e);if(!t)return;const n=t.id;t.id="",this.changingHash=!0,window.location.hash=n,t.id=n}onTabKeydown(e){switch(e.key){case"ArrowLeft":case"ArrowUp":case"Left":case"Up":this.activatePreviousTab(),e.preventDefault();break;case"ArrowRight":case"ArrowDown":case"Right":case"Down":this.activateNextTab(),e.preventDefault()}}activateNextTab(){const e=this.getCurrentTab();if(null==e||!e.parentElement)return;const t=e.parentElement.nextElementSibling;if(!t)return;const n=t.querySelector("a.nhsuk-tabs__tab");n&&(this.hideTab(e),this.showTab(n),n.focus(),this.createHistoryEntry(n))}activatePreviousTab(){const e=this.getCurrentTab();if(null==e||!e.parentElement)return;const t=e.parentElement.previousElementSibling;if(!t)return;const n=t.querySelector("a.nhsuk-tabs__tab");n&&(this.hideTab(e),this.showTab(n),n.focus(),this.createHistoryEntry(n))}getPanel(e){const t=e.hash.replace("#","");return t?this.$root.querySelector(`#${t}`):null}showPanel(e){const t=this.getPanel(e);t&&t.classList.remove(this.jsHiddenClass)}hidePanel(e){const t=this.getPanel(e);t&&t.classList.add(this.jsHiddenClass)}unhighlightTab(e){e.parentElement&&(e.setAttribute("aria-selected","false"),e.parentElement.classList.remove("nhsuk-tabs__list-item--selected"),e.setAttribute("tabindex","-1"))}highlightTab(e){e.parentElement&&(e.setAttribute("aria-selected","true"),e.parentElement.classList.add("nhsuk-tabs__list-item--selected"),e.setAttribute("tabindex","0"))}getCurrentTab(){return this.$root.querySelector(".nhsuk-tabs__list-item--selected a.nhsuk-tabs__tab")}}function initTabs(e){const{scope:t}=normaliseOptions(e),n=null==t?void 0:t.querySelectorAll(`[data-module="${Tabs.moduleName}"]`);null==n||n.forEach((e=>{new Tabs(e)}))}function initAll(e={}){const t=isObject(e)?e:{},n=normaliseOptions(e);try{if(!isSupported())throw new SupportError;if(null===n.scope)throw new ElementError({element:n.scope,identifier:"NHS.UK frontend scope element (`$scope`)"})}catch(i){return void(n.onError?n.onError(i,{config:t}):console.log(i))}[[Button,t.button],[CharacterCount,t.characterCount],[Checkboxes],[ErrorSummary,t.errorSummary],[Header],[NotificationBanner,t.notificationBanner],[Radios],[SkipLink],[Tabs]].forEach((([Component,e])=>{createAll(Component,e,n)}))}function createAll(Component,e,t){let n;const i=normaliseOptions(t);try{var s;if(!isSupported())throw new SupportError;if(null===i.scope)throw new ElementError({element:i.scope,component:Component,identifier:"Scope element (`$scope`)"});n=null==(s=i.scope)?void 0:s.querySelectorAll(`[data-module="${Component.moduleName}"]`)}catch(o){return i.onError?i.onError(o,{component:Component,config:e}):console.log(o),[]}return Array.from(null!=n?n:[]).map((t=>{try{return e&&"defaults"in Component?new Component(t,e):new Component(t)}catch(o){return i.onError?i.onError(o,{element:t,component:Component,config:e}):console.log(o),null}})).filter((e=>!!e))}Tabs.moduleName="nhsuk-tabs";export{Button,CharacterCount,Checkboxes,Component,ConfigError,ConfigurableComponent,ElementError,ErrorSummary,Header,InitError,NHSUKFrontendError,NotificationBanner,Radios,SkipLink,SupportError,Tabs,createAll,initAll,initButtons,initCharacterCounts,initCheckboxes,initErrorSummary,initHeader,initNotificationBanners,initRadios,initSkipLinks,initTabs,isSupported,version};//# sourceMappingURL=nhsuk-frontend.min.js.map
