import "#internal/nitro/virtual/polyfill";
import { requestHasBody } from "../utils.mjs";
import { nitroApp } from "../app.mjs";
export async function onRequest(ctx) {
  try {
    const asset = await ctx.next();
    if (asset.status !== 404) {
      return asset;
    }
  } catch (_err) {
  }
  const url = new URL(ctx.request.url);
  let body;
  if (requestHasBody(ctx.request)) {
    body = Buffer.from(await ctx.request.arrayBuffer());
  }
  const r = await nitroApp.localCall({
    url: url.pathname + url.search,
    method: ctx.request.method,
    headers: ctx.request.headers,
    host: url.hostname,
    protocol: url.protocol,
    body
  });
  return new Response(r.body, {
    headers: normalizeOutgoingHeaders(r.headers),
    status: r.status,
    statusText: r.statusText
  });
}
function normalizeOutgoingHeaders(headers) {
  return Object.entries(headers).map(([k, v]) => [k, Array.isArray(v) ? v.join(",") : v]);
}
