"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _headers = _interopRequireDefault(require("./headers.js"));

var _body = _interopRequireWildcard(require("./body.js"));

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Response.js
 *
 * Response class provides content decoding
 */
const INTERNALS = Symbol('Response internals');
/**
 * Response class
 *
 * @param   Stream  body  Readable stream
 * @param   Object  opts  Response options
 * @return  Void
 */

class Response {
  constructor(body = null, options = {}) {
    _body.default.call(this, body, options);

    const status = options.status || 200;
    const headers = new _headers.default(options.headers);

    if (body !== null && !headers.has('Content-Type')) {
      const contentType = (0, _body.extractContentType)(body);

      if (contentType) {
        headers.append('Content-Type', contentType);
      }
    }

    this[INTERNALS] = {
      url: options.url,
      status,
      statusText: options.statusText || '',
      headers,
      counter: options.counter,
      highWaterMark: options.highWaterMark
    };
  }

  get url() {
    return this[INTERNALS].url || '';
  }

  get status() {
    return this[INTERNALS].status;
  }
  /**
   * Convenience property representing if the request ended normally
   */


  get ok() {
    return this[INTERNALS].status >= 200 && this[INTERNALS].status < 300;
  }

  get redirected() {
    return this[INTERNALS].counter > 0;
  }

  get statusText() {
    return this[INTERNALS].statusText;
  }

  get headers() {
    return this[INTERNALS].headers;
  }

  get highWaterMark() {
    return this[INTERNALS].highWaterMark;
  }
  /**
   * Clone this response
   *
   * @return  Response
   */


  clone() {
    return new Response((0, _body.clone)(this, this.highWaterMark), {
      url: this.url,
      status: this.status,
      statusText: this.statusText,
      headers: this.headers,
      ok: this.ok,
      redirected: this.redirected,
      size: this.size,
      timeout: this.timeout
    });
  }
  /**
   * @param {string} url    The URL that the new response is to originate from.
   * @param {number} status An optional status code for the response (e.g., 302.)
   * @returns {Response}    A Response object.
   */


  static redirect(url, status = 302) {
    if (![301, 302, 303, 307, 308].includes(status)) {
      throw new RangeError('Failed to execute "redirect" on "response": Invalid status code');
    }

    return new Response(null, {
      headers: {
        location: new URL(url).toString()
      },
      status
    });
  }

}

exports.default = Response;

_body.default.mixIn(Response.prototype);

Object.defineProperties(Response.prototype, {
  url: {
    enumerable: true
  },
  status: {
    enumerable: true
  },
  ok: {
    enumerable: true
  },
  redirected: {
    enumerable: true
  },
  statusText: {
    enumerable: true
  },
  headers: {
    enumerable: true
  },
  clone: {
    enumerable: true
  }
});
Object.defineProperty(Response.prototype, Symbol.toStringTag, {
  value: 'Response',
  writable: false,
  enumerable: false,
  configurable: true
});